/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.warps;

import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.tbstcraft.quark.foundation.platform.Players;
import org.tbstcraft.quark.framework.module.CommandModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule
@QuarkCommand(name="random-tp", aliases={"rtp"}, permission="+quark.warps.rtp")
public final class RTP
extends CommandModule {
    public void execute(CommandExecution context) {
        MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)context.getSender(), (String)"start", (Object[])new Object[]{ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"attempt")});
        this.teleport(context.requireSenderAsPlayer(), loc -> {
            if (loc == null) {
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)context.getSender(), (String)"failed", (Object[])new Object[0]);
                return;
            }
            MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)context.getSender(), (String)"success", (Object[])new Object[]{loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()});
        });
    }

    public void attempt(Random random, Player player, Consumer<Location> callback, int counter, boolean async) {
        (async ? TaskService.async() : TaskService.global()).delay(1L, () -> {
            ChunkSnapshot snapshot;
            int limit = ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"limit");
            int max = ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"max-height");
            int min = ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"min-height");
            int attempt = ConfigAccessor.getInt((ConfigEntry)this.getConfig(), (String)"attempt");
            int x = random.nextInt(-limit, limit);
            int z = random.nextInt(-limit, limit);
            World world = player.getWorld();
            if (async) {
                try {
                    snapshot = ((Chunk)world.getChunkAtAsync(x >> 4, z >> 4).get()).getChunkSnapshot();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            } else {
                snapshot = world.getChunkAt(x >> 4, z >> 4).getChunkSnapshot();
            }
            try {
                max = snapshot.getHighestBlockYAt(x & 0xF, z & 0xF) + 4;
            }
            catch (Throwable e) {
                // empty catch block
            }
            for (int y = max; y >= min; --y) {
                Material b = snapshot.getBlockType(x & 0xF, y, z & 0xF);
                Material b1 = snapshot.getBlockType(x & 0xF, y + 1, z & 0xF);
                Material b2 = snapshot.getBlockType(x & 0xF, y + 2, z & 0xF);
                Material b3 = snapshot.getBlockType(x & 0xF, y + 3, z & 0xF);
                if (!b.isSolid() || this.verifyAirBlock(b1) || this.verifyAirBlock(b2) || this.verifyAirBlock(b3)) continue;
                Location loc = new Location(player.getWorld(), (double)x, (double)y, (double)z);
                TaskService.global().run(() -> {
                    Players.teleport((Entity)player, (Location)loc.add(0.5, 1.0, 0.5));
                    callback.accept(loc);
                });
                return;
            }
            if (counter >= attempt) {
                callback.accept(null);
                return;
            }
            this.attempt(random, player, callback, counter + 1, async);
        });
    }

    public void teleport(Player player, Consumer<Location> callback) {
        try {
            World.class.getMethod("getChunkAtAsync", Integer.TYPE, Integer.TYPE);
            this.attempt(new Random(), player, callback, 0, true);
        }
        catch (NoSuchMethodException e) {
            this.getL4jLogger().warn("using legacy thread-sync finder. lags may occur.");
            this.attempt(new Random(), player, callback, 0, false);
        }
    }

    private boolean verifyAirBlock(Material b) {
        return !b.isAir();
    }
}

