/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.warps;

import java.util.Collection;
import me.gb2022.commons.container.RequestStorage;
import org.atcraftmc.qlib.command.AbstractCommand;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.command.execute.CommandSuggestion;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.command.QuarkCommandManager;
import org.tbstcraft.quark.foundation.platform.BukkitUtil;
import org.tbstcraft.quark.foundation.platform.Players;
import org.tbstcraft.quark.framework.module.AbstractModule;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.migration.MessageAccessor;

@QuarkModule(version="1.0.2")
public final class TPA
extends PackageModule {
    private final TPACommand tpa = new TPACommand();
    private final TPAHereCommand tpaHere = new TPAHereCommand();

    public void enable() {
        this.tpa.initContext((AbstractModule)this);
        this.tpaHere.initContext((AbstractModule)this);
        QuarkCommandManager.getInstance().register((AbstractCommand)this.tpa);
        QuarkCommandManager.getInstance().register((AbstractCommand)this.tpaHere);
        BukkitUtil.registerEventListener((Listener)this.tpa);
        BukkitUtil.registerEventListener((Listener)this.tpaHere);
    }

    public void disable() {
        QuarkCommandManager.getInstance().unregister((AbstractCommand)this.tpa);
        QuarkCommandManager.getInstance().unregister((AbstractCommand)this.tpaHere);
        BukkitUtil.unregisterEventListener((Listener)this.tpa);
        BukkitUtil.unregisterEventListener((Listener)this.tpaHere);
    }

    @QuarkCommand(name="tpa", permission="+quark.tpa")
    public static final class TPACommand
    extends AbstractedTPACommand {
        @Override
        public void onAccepted(Player handler, Player target) {
            Players.teleport((Entity)target, (Location)handler.getLocation());
        }
    }

    @QuarkCommand(name="tpahere", permission="+quark.tpahere")
    public static final class TPAHereCommand
    extends AbstractedTPACommand {
        @Override
        public void onAccepted(Player handler, Player target) {
            Players.teleport((Entity)handler, (Location)target.getLocation());
        }
    }

    public static abstract class AbstractedTPACommand
    extends ModuleCommand<TPA> {
        private final RequestStorage storage = new RequestStorage();

        public void suggest(CommandSuggestion suggestion) {
            String sender = suggestion.getSender().getName();
            suggestion.suggest(0, new String[]{"request", "accept", "deny"});
            suggestion.matchArgument(0, "request", s -> s.suggestOnlinePlayers(1));
            suggestion.matchArgument(0, "accept", s -> s.suggest(1, (Collection)this.storage.getRequestList(sender)));
            suggestion.matchArgument(0, "deny", s -> s.suggest(1, (Collection)this.storage.getRequestList(sender)));
        }

        public void execute(CommandExecution context) {
            Player sender = context.requireSenderAsPlayer();
            Player target = context.requirePlayer(1);
            String senderName = sender.getName();
            String targetName = target.getName();
            switch (context.requireEnum(0, new String[]{"request", "accept", "deny"})) {
                case "accept": {
                    if (!this.getStorage().containsRequest(senderName, targetName)) {
                        MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)(this.getName() + "-no-request"), (Object[])new Object[]{targetName});
                        return;
                    }
                    this.onAccepted(sender, target);
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)(this.getName() + "-accept-sender"), (Object[])new Object[]{targetName});
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)target, (String)(this.getName() + "-accept-target"), (Object[])new Object[]{senderName});
                    this.getStorage().removeRequest(senderName, targetName);
                    break;
                }
                case "deny": {
                    if (!this.getStorage().containsRequest(senderName, targetName)) {
                        MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)(this.getName() + "-no-request"), (Object[])new Object[]{targetName});
                        return;
                    }
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)(this.getName() + "-deny-sender"), (Object[])new Object[]{targetName});
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)target, (String)(this.getName() + "-deny-target"), (Object[])new Object[]{senderName});
                    this.getStorage().removeRequest(senderName, targetName);
                    break;
                }
                case "request": {
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)(this.getName() + "-request-sender"), (Object[])new Object[]{targetName});
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)target, (String)(this.getName() + "-request-target"), (Object[])new Object[]{senderName, senderName, senderName});
                    this.getStorage().addRequest(targetName, senderName);
                }
            }
        }

        public RequestStorage getStorage() {
            return this.storage;
        }

        public abstract void onAccepted(Player var1, Player var2);

        @EventHandler
        public void onPlayerQuit(PlayerQuitEvent event) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                this.getStorage().removeRequest(p.getName(), event.getPlayer().getName());
            }
        }
    }
}

