/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.warps;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.gb2022.commons.nbt.NBTTagCompound;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.atcraftmc.qlib.PluginPlatform;
import org.atcraftmc.qlib.command.AbstractCommand;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.assertion.NumberLimitation;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.command.execute.CommandSuggestion;
import org.atcraftmc.qlib.config.ConfigEntry;
import org.atcraftmc.qlib.language.LanguageEntry;
import org.atcraftmc.qlib.language.LanguageItem;
import org.atcraftmc.qlib.language.MinecraftLocale;
import org.atcraftmc.qlib.texts.ComponentBlock;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;
import org.bukkit.permissions.Permission;
import org.tbstcraft.quark.api.PluginStorage;
import org.tbstcraft.quark.data.ModuleDataService;
import org.tbstcraft.quark.data.PlayerDataService;
import org.tbstcraft.quark.foundation.TextSender;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.command.QuarkCommandManager;
import org.tbstcraft.quark.foundation.platform.BukkitCodec;
import org.tbstcraft.quark.foundation.platform.Players;
import org.tbstcraft.quark.framework.module.AbstractModule;
import org.tbstcraft.quark.framework.module.CommandModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.LocaleService;
import org.tbstcraft.quark.migration.ConfigAccessor;
import org.tbstcraft.quark.migration.MessageAccessor;
import org.tbstcraft.quark.util.BukkitSound;

@QuarkCommand(name="waypoint")
@QuarkModule(version="2.0.3")
@CommandProvider(value={WaypointCommand.class})
@AutoRegister(value={"qb:el", "qb:cm"})
public final class Waypoint
extends CommandModule {
    private final SetHomeCommand setHomeCommand = new SetHomeCommand(this);
    private final WarpHomeCommand warpHomeCommand = new WarpHomeCommand(this);
    @Inject(value="-quark.waypoint.public")
    private Permission editPublicPermission;
    @Inject(value="-quark.waypoint.bypass")
    private Permission bypassAddLimitPermission;
    @Inject(value="tip")
    private LanguageItem tip;
    @Inject(value="tip-home")
    private LanguageItem tipHome;

    public void enable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.add(this.tip));
        if (ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"home")) {
            QuarkCommandManager.getInstance().register((AbstractCommand)this.setHomeCommand);
            QuarkCommandManager.getInstance().register((AbstractCommand)this.warpHomeCommand);
            PluginStorage.set((String)"chat_announce/pick/tip", s -> s.add(this.tipHome));
        }
    }

    public void disable() {
        PluginStorage.set((String)"chat_announce/pick/tip", s -> s.remove(this.tip));
        if (ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"home")) {
            QuarkCommandManager.getInstance().unregister((AbstractCommand)this.setHomeCommand);
            QuarkCommandManager.getInstance().unregister((AbstractCommand)this.warpHomeCommand);
            PluginStorage.set((String)"chat_announce/pick/tip", s -> s.remove(this.tipHome));
        }
    }

    @QuarkCommand(name="sethome", playerOnly=true, permission="+quark.warp.sethome")
    public static final class SetHomeCommand
    extends ModuleCommand<Waypoint> {
        public SetHomeCommand(Waypoint waypoint) {
            super((AbstractModule)waypoint);
            this.init();
        }

        public void onCommand(CommandSender sender, String[] args) {
            NBTTagCompound entry = PlayerDataService.getEntry((String)sender.getName(), (String)this.getModuleId());
            if (entry.hasKey("home") && (args.length < 1 || !Objects.equals(args[0], "-f"))) {
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"home-exist-warn", (Object[])new Object[0]);
                return;
            }
            entry.setCompoundTag("home", BukkitCodec.nbt((Location)((Player)sender).getLocation()));
            MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"home-set-success", (Object[])new Object[0]);
        }
    }

    @QuarkCommand(name="home", playerOnly=true, permission="+quark.warp.tphome")
    public static final class WarpHomeCommand
    extends ModuleCommand<Waypoint> {
        public WarpHomeCommand(Waypoint waypoint) {
            super((AbstractModule)waypoint);
            this.init();
        }

        public void onCommand(CommandSender sender, String[] args) {
            NBTTagCompound entry = PlayerDataService.getEntry((String)sender.getName(), (String)this.getModuleId());
            if (!entry.hasKey("home")) {
                MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"home-not-set", (Object[])new Object[0]);
                return;
            }
            Location loc = BukkitCodec.location((NBTTagCompound)entry.getCompoundTag("home"));
            Players.teleport((Entity)((Player)sender), (Location)loc);
            MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"home-tp-success", (Object[])new Object[0]);
            BukkitSound.WARP.play((Player)sender);
        }
    }

    @QuarkCommand(name="waypoint", playerOnly=true, permission="+quark.waypoint.command")
    public static final class WaypointCommand
    extends ModuleCommand<Waypoint> {
        public void execute(CommandExecution context) {
            String mode = context.requireEnum(0, new String[]{"add-private", "remove-private", "tp-private", "list-private", "add", "remove", "tp", "list"});
            boolean isPrivate = mode.contains("private");
            Player sender = context.requireSenderAsPlayer();
            MinecraftLocale locale = LocaleService.locale((CommandSender)sender);
            NBTTagCompound entry = isPrivate ? PlayerDataService.getEntry((String)sender.getName(), (String)((Waypoint)this.getModule()).getId()) : ModuleDataService.getEntry((String)this.getModuleId());
            if (!isPrivate && !mode.contains("tp")) {
                context.requirePermission(((Waypoint)this.getModule()).editPublicPermission);
            }
            switch (mode) {
                case "list": 
                case "list-private": {
                    ComponentBlock list = this.getLanguage().item("list").component(locale, new Object[0]);
                    entry.getTagMap().forEach((name, data) -> {
                        Location loc = BukkitCodec.location((NBTTagCompound)entry.getCompoundTag(name));
                        ComponentBlock component = this.getLanguage().item("list-item").component(locale, new Object[]{name, loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), isPrivate ? "-private" : "", name});
                        ComponentBlock hover = this.getLanguage().item("list-hover").component(locale, new Object[]{name, loc.getWorld().getName(), loc.getX(), loc.getY(), loc.getZ(), Float.valueOf(loc.getYaw()), Float.valueOf(loc.getPitch())});
                        Component line = component.asComponent().hoverEvent((HoverEventSource)hover.asComponent().asHoverEvent()).clickEvent(ClickEvent.runCommand((String)"/waypoint %s %s".formatted(isPrivate ? "tp-private" : "tp", name)));
                        list.add((Object)line);
                    });
                    sender.sendMessage(PluginPlatform.instance().globalFormatMessage("{#line}"));
                    TextSender.sendMessage((CommandSender)sender, (ComponentLike)list);
                    sender.sendMessage(PluginPlatform.instance().globalFormatMessage("{#line}"));
                    break;
                }
                case "tp": 
                case "tp-private": {
                    String id = context.requireArgumentAt(1);
                    NBTTagCompound tag = entry.getCompoundTag(id);
                    if (tag == null || !tag.hasKey("world")) {
                        MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"not-exist", (Object[])new Object[]{id});
                        break;
                    }
                    Players.teleport((Entity)sender, (Location)BukkitCodec.location((NBTTagCompound)tag));
                    BukkitSound.WARP.play(sender);
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"tp-success", (Object[])new Object[]{id});
                    break;
                }
                case "add": 
                case "add-private": {
                    Location loc;
                    String id = context.requireArgumentAt(1);
                    NBTTagCompound tag = entry.getCompoundTag(id);
                    if (tag.hasKey("world")) {
                        MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"exist", (Object[])new Object[]{id});
                        return;
                    }
                    if (!context.hasArgumentAt(2) || Objects.equals(context.requireArgumentAt(2), "@self")) {
                        loc = sender.getLocation();
                    } else {
                        if (!ConfigAccessor.getBool((ConfigEntry)this.getConfig(), (String)"allow-coordinate-add")) {
                            context.requirePermission(((Waypoint)this.getModule()).bypassAddLimitPermission);
                        }
                        loc = new Location(Bukkit.getWorld((String)context.requireEnum(2, Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toSet()))), context.requireArgumentDouble(3, new NumberLimitation[]{NumberLimitation.any()}), context.requireArgumentDouble(4, new NumberLimitation[]{NumberLimitation.any()}), context.requireArgumentDouble(5, new NumberLimitation[]{NumberLimitation.any()}));
                        if (context.hasArgumentAt(6)) {
                            loc.setYaw(context.requireArgumentFloat(6, new NumberLimitation[]{NumberLimitation.any()}));
                            loc.setPitch(context.requireArgumentFloat(7, new NumberLimitation[]{NumberLimitation.any()}));
                        }
                    }
                    tag = BukkitCodec.nbt((Location)loc);
                    entry.setCompoundTag(id, tag);
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"add-success", (Object[])new Object[]{id});
                    PlayerDataService.save((String)sender.getName());
                    ModuleDataService.save((String)this.getModuleId());
                    break;
                }
                case "remove": 
                case "remove-private": {
                    String id = context.requireArgumentAt(1);
                    NBTTagCompound tag = entry.getCompoundTag(id);
                    if (!tag.hasKey("world")) {
                        MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"not-exist", (Object[])new Object[]{id});
                        return;
                    }
                    entry.remove(id);
                    MessageAccessor.send((LanguageEntry)this.getLanguage(), (CommandSender)sender, (String)"remove-success", (Object[])new Object[]{id});
                }
            }
        }

        public void suggest(CommandSuggestion suggestion) {
            suggestion.suggest(0, new String[]{"tp", "tp-private", "list", "list-private", "add-private", "remove-private"});
            suggestion.requireAnyPermission(ctx -> ctx.suggest(0, new String[]{"add", "remove"}), new Permission[]{((Waypoint)this.getModule()).editPublicPermission});
            Player player = suggestion.getSenderAsPlayer();
            Consumer<CommandSuggestion> add = suggestion1 -> {
                suggestion1.suggest(1, new String[]{"[name]"});
                suggestion1.suggest(2, new String[]{"@self"});
                suggestion1.requireAnyPermission(ctx -> {
                    suggestion1.suggest(2, (Collection)Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toSet()));
                    suggestion1.suggest(3, new String[]{String.valueOf(player.getLocation().getX())});
                    suggestion1.suggest(4, new String[]{String.valueOf(player.getLocation().getY())});
                    suggestion1.suggest(5, new String[]{String.valueOf(player.getLocation().getZ())});
                    suggestion1.suggest(6, new String[]{String.valueOf(player.getLocation().getYaw())});
                    suggestion1.suggest(7, new String[]{String.valueOf(player.getLocation().getPitch())});
                }, new Permission[]{((Waypoint)this.getModule()).bypassAddLimitPermission});
            };
            suggestion.matchArgument(0, "add", add);
            suggestion.matchArgument(0, "add-private", add);
            Consumer<CommandSuggestion> privateList = ctx -> {
                Map map = PlayerDataService.getEntry((String)player.getName(), (String)this.getModuleId()).getTagMap();
                ctx.suggest(1, map.keySet());
            };
            Consumer<CommandSuggestion> pubList = ctx -> {
                Map map = ModuleDataService.getEntry((String)this.getModuleId()).getTagMap();
                ctx.suggest(1, map.keySet());
            };
            suggestion.matchArgument(0, "remove", pubList);
            suggestion.matchArgument(0, "tp", pubList);
            suggestion.matchArgument(0, "remove-private", privateList);
            suggestion.matchArgument(0, "tp-private", privateList);
        }
    }
}

