/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.console;

import com.destroystokyo.paper.PaperConfig;
import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.dedicated.DedicatedServer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jline.reader.Candidate;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public final class BrigadierCommandCompleter {
    private final CommandListenerWrapper commandSourceStack;
    private final DedicatedServer server;

    public BrigadierCommandCompleter(@NonNull DedicatedServer server, @NonNull CommandListenerWrapper commandSourceStack) {
        this.server = server;
        this.commandSourceStack = commandSourceStack;
    }

    public void complete(@NonNull LineReader reader, @NonNull ParsedLine line, @NonNull List<Candidate> candidates, @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    AsyncTabCompleteEvent.Completion> existing) {
        if (!PaperConfig.enableBrigadierConsoleCompletions) {
            this.addCandidates(candidates, Collections.emptyList(), existing);
            return;
        }
        CommandDispatcher dispatcher = this.server.aA().a();
        ParseResults results = dispatcher.parse(BrigadierCommandCompleter.prepareStringReader(line.line()), (Object)this.commandSourceStack);
        this.addCandidates(candidates, ((Suggestions)dispatcher.getCompletionSuggestions(results, line.cursor()).join()).getList(), existing);
    }

    private void addCandidates(@NonNull List<Candidate> candidates, @NonNull List<Suggestion> brigSuggestions, @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    AsyncTabCompleteEvent.Completion> existing) {
        ArrayList<AsyncTabCompleteEvent.Completion> completions = new ArrayList<AsyncTabCompleteEvent.Completion>();
        brigSuggestions.forEach(it -> completions.add(BrigadierCommandCompleter.toCompletion(it)));
        for (AsyncTabCompleteEvent.Completion completion : existing) {
            if (completion.suggestion().isEmpty() || brigSuggestions.stream().anyMatch(it -> it.getText().equals(completion.suggestion()))) continue;
            completions.add(completion);
        }
        for (AsyncTabCompleteEvent.Completion completion : completions) {
            if (completion.suggestion().isEmpty()) continue;
            candidates.add(BrigadierCommandCompleter.toCandidate(completion));
        }
    }

    private static @NonNull Candidate toCandidate(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AsyncTabCompleteEvent.Completion completion) {
        String suggestionText = completion.suggestion();
        String suggestionTooltip = (String)PaperAdventure.PLAIN.serializeOr(completion.tooltip(), null);
        return new Candidate(suggestionText, suggestionText, null, suggestionTooltip, null, null, false);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AsyncTabCompleteEvent.Completion toCompletion(@NonNull Suggestion suggestion) {
        if (suggestion.getTooltip() == null) {
            return AsyncTabCompleteEvent.Completion.completion((String)suggestion.getText());
        }
        return AsyncTabCompleteEvent.Completion.completion((String)suggestion.getText(), (Component)PaperAdventure.asAdventure((IChatBaseComponent)ChatComponentUtils.a((Message)suggestion.getTooltip())));
    }

    static @NonNull StringReader prepareStringReader(@NonNull String line) {
        StringReader stringReader = new StringReader(line);
        if (stringReader.canRead() && stringReader.peek() == '/') {
            stringReader.skip();
        }
        return stringReader;
    }
}

