/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.console;

import com.destroystokyo.paper.PaperConfig;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecrell.terminalconsole.TerminalConsoleAppender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.PropertiesUtil;

@Plugin(name="paperMinecraftFormatting", category="Converter")
@ConverterKeys(value={"paperMinecraftFormatting"})
@PerformanceSensitive(value={"allocation"})
public final class HexFormattingConverter
extends LogEventPatternConverter {
    private static final boolean KEEP_FORMATTING = PropertiesUtil.getProperties().getBooleanProperty("terminal.keepMinecraftFormatting");
    private static final String ANSI_RESET = "\u001b[m";
    private static final char COLOR_CHAR = '\u007f';
    public static final LegacyComponentSerializer SERIALIZER = LegacyComponentSerializer.builder().hexColors().flattener(PaperAdventure.FLATTENER).character('\u007f').build();
    private static final String LOOKUP = "0123456789abcdefklmnor";
    private static final String RGB_ANSI = "\u001b[38;2;%d;%d;%dm";
    private static final Pattern NAMED_PATTERN = Pattern.compile("\u007f[0-9a-fk-orA-FK-OR]");
    private static final Pattern RGB_PATTERN = Pattern.compile("\u007f#([0-9a-fA-F]){6}");
    private static final String[] RGB_ANSI_CODES = new String[]{HexFormattingConverter.formatHexAnsi(NamedTextColor.BLACK), HexFormattingConverter.formatHexAnsi(NamedTextColor.DARK_BLUE), HexFormattingConverter.formatHexAnsi(NamedTextColor.DARK_GREEN), HexFormattingConverter.formatHexAnsi(NamedTextColor.DARK_AQUA), HexFormattingConverter.formatHexAnsi(NamedTextColor.DARK_RED), HexFormattingConverter.formatHexAnsi(NamedTextColor.DARK_PURPLE), HexFormattingConverter.formatHexAnsi(NamedTextColor.GOLD), HexFormattingConverter.formatHexAnsi(NamedTextColor.GRAY), HexFormattingConverter.formatHexAnsi(NamedTextColor.DARK_GRAY), HexFormattingConverter.formatHexAnsi(NamedTextColor.BLUE), HexFormattingConverter.formatHexAnsi(NamedTextColor.GREEN), HexFormattingConverter.formatHexAnsi(NamedTextColor.AQUA), HexFormattingConverter.formatHexAnsi(NamedTextColor.RED), HexFormattingConverter.formatHexAnsi(NamedTextColor.LIGHT_PURPLE), HexFormattingConverter.formatHexAnsi(NamedTextColor.YELLOW), HexFormattingConverter.formatHexAnsi(NamedTextColor.WHITE), "\u001b[5m", "\u001b[21m", "\u001b[9m", "\u001b[4m", "\u001b[3m", "\u001b[m"};
    private static final String[] ANSI_ANSI_CODES = new String[]{"\u001b[0;30m", "\u001b[0;34m", "\u001b[0;32m", "\u001b[0;36m", "\u001b[0;31m", "\u001b[0;35m", "\u001b[0;33m", "\u001b[0;37m", "\u001b[0;30;1m", "\u001b[0;34;1m", "\u001b[0;32;1m", "\u001b[0;36;1m", "\u001b[0;31;1m", "\u001b[0;35;1m", "\u001b[0;33;1m", "\u001b[0;37;1m", "\u001b[5m", "\u001b[21m", "\u001b[9m", "\u001b[4m", "\u001b[3m", "\u001b[m"};
    private final boolean ansi;
    private final List<PatternFormatter> formatters;

    protected HexFormattingConverter(List<PatternFormatter> formatters, boolean strip) {
        super("paperMinecraftFormatting", null);
        this.formatters = formatters;
        this.ansi = !strip;
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        int start = toAppendTo.length();
        int size = this.formatters.size();
        for (int i = 0; i < size; ++i) {
            this.formatters.get(i).format(event, toAppendTo);
        }
        if (KEEP_FORMATTING || toAppendTo.length() == start) {
            return;
        }
        boolean useAnsi = this.ansi && TerminalConsoleAppender.isAnsiSupported();
        String content = toAppendTo.substring(start);
        content = useAnsi ? HexFormattingConverter.convertRGBColors(content) : HexFormattingConverter.stripRGBColors(content);
        HexFormattingConverter.format(content, toAppendTo, start, useAnsi);
    }

    private static String convertRGBColors(String input) {
        return RGB_PATTERN.matcher(input).replaceAll(result -> {
            int hex = Integer.decode(result.group().substring(1));
            return HexFormattingConverter.formatHexAnsi(hex);
        });
    }

    private static String formatHexAnsi(TextColor color) {
        return HexFormattingConverter.formatHexAnsi(color.value());
    }

    private static String formatHexAnsi(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        return String.format(RGB_ANSI, red, green, blue);
    }

    private static String stripRGBColors(String input) {
        return RGB_PATTERN.matcher(input).replaceAll("");
    }

    static void format(String content, StringBuilder result, int start, boolean ansi) {
        String[] ansiCodes;
        int next = content.indexOf(127);
        int last = content.length() - 1;
        if (next == -1 || next == last) {
            result.setLength(start);
            result.append(content);
            if (ansi) {
                result.append(ANSI_RESET);
            }
            return;
        }
        Matcher matcher = NAMED_PATTERN.matcher(content);
        StringBuilder buffer = new StringBuilder();
        String[] stringArray = ansiCodes = PaperConfig.useRgbForNamedTextColors ? RGB_ANSI_CODES : ANSI_ANSI_CODES;
        while (matcher.find()) {
            int format = LOOKUP.indexOf(Character.toLowerCase(matcher.group().charAt(1)));
            if (format == -1) continue;
            matcher.appendReplacement(buffer, ansi ? ansiCodes[format] : "");
        }
        matcher.appendTail(buffer);
        result.setLength(start);
        result.append((CharSequence)buffer);
        if (ansi) {
            result.append(ANSI_RESET);
        }
    }

    public static HexFormattingConverter newInstance(Configuration config, String[] options) {
        if (options.length < 1 || options.length > 2) {
            LOGGER.error("Incorrect number of options on paperMinecraftFormatting. Expected at least 1, max 2 received " + options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied on paperMinecraftFormatting");
            return null;
        }
        PatternParser parser = PatternLayout.createPatternParser((Configuration)config);
        List formatters = parser.parse(options[0]);
        boolean strip = options.length > 1 && "strip".equals(options[1]);
        return new HexFormattingConverter(formatters, strip);
    }
}

