/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.proxy;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.nio.charset.StandardCharsets;
import me.gb2022.commons.reflect.AutoRegister;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.tbstcraft.quark.Quark;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.framework.module.component.Components;
import org.tbstcraft.quark.framework.module.component.ModuleComponent;

@QuarkModule(version="1.0.0")
@AutoRegister(value={"qb:el"})
@Components(value={BukkitListener.class, PaperListener.class})
public final class ChatSync
extends PackageModule {
    public void enable() {
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)Quark.getInstance(), "quark_plugin:msg");
    }

    public void send(Player player, Component message) {
        String payload = (String)GsonComponentSerializer.gson().serialize(message);
        player.sendPluginMessage((Plugin)Quark.getInstance(), "quark_plugin:msg", payload.getBytes(StandardCharsets.UTF_8));
    }

    @AutoRegister(value={"qb:el"})
    public static final class PaperListener
    extends ModuleComponent<ChatSync> {
        public void checkCompatibility() throws APIIncompatibleException {
            Compatibility.requireClass(() -> Class.forName("io.papermc.paper.event.player.AsyncChatEvent"));
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onChat(AsyncChatEvent event) {
            ((ChatSync)this.parent).send(event.getPlayer(), event.message());
        }
    }

    @AutoRegister(value={"qb:el"})
    public static final class BukkitListener
    extends ModuleComponent<ChatSync> {
        public void checkCompatibility() throws APIIncompatibleException {
            try {
                Class.forName("io.papermc.paper.event.player.AsyncChatEvent");
                throw new APIIncompatibleException("assertion failed");
            }
            catch (ClassNotFoundException classNotFoundException) {
                return;
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onChat(AsyncPlayerChatEvent event) {
            ((ChatSync)this.parent).send(event.getPlayer(), (Component)Component.text((String)event.getMessage()));
        }
    }
}

