/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.proxy;

import com.destroystokyo.paper.profile.PlayerProfile;
import me.gb2022.commons.reflect.AutoRegister;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.atcraftmc.qlib.command.execute.CommandExecution;
import org.atcraftmc.qlib.command.execute.CommandExecutor;
import org.atcraftmc.qlib.command.execute.CommandSuggestion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.foundation.command.QuarkCommandExecutor;
import org.tbstcraft.quark.foundation.platform.APIIncompatibleException;
import org.tbstcraft.quark.foundation.platform.Compatibility;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;

@QuarkModule
@AutoRegister(value={"qb:el"})
@CommandProvider(value={RedirectSkinCommand.class})
public class GeyserSkinRedirect
extends PackageModule
implements QuarkCommandExecutor {
    public void checkCompatibility() throws APIIncompatibleException {
        Compatibility.requireMethod(() -> OfflinePlayer.class.getMethod("getPlayerProfile", new Class[0]));
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.redirect(event.getPlayer());
    }

    public void redirect(Player player) {
        String prefix = this.getConfig().getString("prefix");
        if (!player.getName().startsWith(prefix)) {
            return;
        }
        TaskService.async().run(() -> {
            this.getL4jLogger().info("redirecting player {}", (Object)player.getName());
            PlayerProfile profile = player.getPlayerProfile();
            PlayerProfile source = Bukkit.getOfflinePlayer((String)player.getName().substring(prefix.length())).getPlayerProfile();
            profile.setTextures(source.getTextures());
            TaskService.global().run(() -> player.setPlayerProfile(profile));
            this.getL4jLogger().info("redirected player {} to {}", (Object)player.getName(), (Object)source.getId());
        });
    }

    public void execute(CommandExecution context) {
        this.redirect(context.requirePlayer(0));
    }

    public void suggest(CommandSuggestion suggestion) {
        suggestion.suggestPlayers(0);
    }

    @QuarkCommand(name="redirect-be-skin", permission="-quark.be.redirectskin")
    public static class RedirectSkinCommand
    extends ModuleCommand<GeyserSkinRedirect> {
        public void init(GeyserSkinRedirect module) {
            this.setExecutor((CommandExecutor)module);
        }
    }
}

