/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.proxy;

import com.google.gson.JsonParser;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import me.gb2022.commons.http.HttpMethod;
import me.gb2022.commons.http.HttpRequest;
import me.gb2022.commons.reflect.AutoRegister;
import me.gb2022.commons.reflect.Inject;
import org.apache.logging.log4j.Logger;
import org.atcraftmc.qlib.command.QuarkCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.tbstcraft.quark.foundation.command.CommandProvider;
import org.tbstcraft.quark.foundation.command.ModuleCommand;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.task.TaskService;
import org.tbstcraft.quark.util.ExceptionUtil;

@QuarkModule(defaultEnable=false, version="1.2")
@AutoRegister(value={"qb:el", "qb:rm"})
@CommandProvider(value={JoinDynamicServerCommand.class})
public final class MCSMDynamicInstance
extends PackageModule {
    @Inject
    private Logger logger;

    public void enable() {
        if (!this.getConfig().getBoolean("instance")) {
            return;
        }
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            this.scheduleStop();
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.getConfig().getBoolean("instance")) {
            return;
        }
        this.logger.info("cancel server stopping process as POWER_SAVING");
        TaskService.async().cancel("quark:ps:countdown");
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (!this.getConfig().getBoolean("instance")) {
            return;
        }
        if (Bukkit.getOnlinePlayers().size() == 1) {
            this.scheduleStop();
        }
    }

    public void scheduleStop() {
        this.logger.info("starting stopping countdown");
        TaskService.async().delay("quark:ps:countdown", (long)this.getConfig().getInt("shutdown-delay"), () -> {
            this.logger.info("stopping server as POWER_SAVING");
            TaskService.global().run(() -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), "stop"));
        });
    }

    public void startServer(CommandSender sender, String name, Consumer<Integer> handler) {
        String apiKey = this.getConfig().getString("api-key");
        String daemon = this.getConfig().getString("daemon");
        TaskService.async().run(() -> {
            String response = HttpRequest.http((HttpMethod)HttpMethod.GET, (String)(daemon + "/api/instance")).param("apikey", apiKey).param("daemonId", this.getConfig().getString("daemon-id")).param("uuid", name).browserBehavior(true).build().request();
            if (JsonParser.parseString((String)response).getAsJsonObject().get("data").getAsJsonObject().get("status").getAsInt() != 0) {
                handler.accept(1);
                return;
            }
            this.getLanguage().sendMessage((Object)sender, "wakeup", new Object[0]);
            String res = HttpRequest.http((HttpMethod)HttpMethod.GET, (String)(daemon + "/api/protected_instance/open")).param("apikey", apiKey).param("daemonId", this.getConfig().getString("daemon-id")).param("uuid", name).build().request();
            this.logger.info("starting instance: " + name);
            if (JsonParser.parseString((String)res).getAsJsonObject().get("status").getAsInt() == 200) {
                handler.accept(0);
                return;
            }
            this.logger.info("starting instance failed: " + response);
            handler.accept(2);
        });
    }

    @QuarkCommand(name="join-dyn-server", permission="+quark.dynserver")
    public static final class JoinDynamicServerCommand
    extends ModuleCommand<MCSMDynamicInstance> {
        public void onCommand(CommandSender sender, String[] args) {
            if (this.getConfig().getBoolean("instance")) {
                return;
            }
            ConfigurationSection servers = this.getConfig().getSection("servers");
            if (!Objects.requireNonNull(servers).contains(args[0])) {
                this.getLanguage().sendMessage((Object)sender, "not-found", new Object[]{args[0]});
                return;
            }
            this.getLanguage().sendMessage((Object)sender, "checking", new Object[0]);
            try {
                ((MCSMDynamicInstance)this.getModule()).startServer(sender, servers.getString(args[0]), i -> {
                    switch (i) {
                        case 0: {
                            this.getLanguage().sendMessage((Object)sender, "starting", new Object[0]);
                            break;
                        }
                        case 1: {
                            this.getLanguage().sendMessage((Object)sender, "running", new Object[0]);
                            break;
                        }
                        case 2: {
                            this.getLanguage().sendMessage((Object)sender, "start-error", new Object[0]);
                        }
                    }
                });
            }
            catch (Exception e) {
                ExceptionUtil.log((Throwable)e);
                this.getLanguage().sendMessage((Object)sender, "start-error", new Object[0]);
            }
        }

        public void onCommandTab(CommandSender sender, String[] buffer, List<String> tabList) {
            if (buffer.length == 1) {
                tabList.addAll(Objects.requireNonNull(this.getConfig().getSection("servers")).getKeys(false));
            }
        }
    }
}

