/*
 * Decompiled with CFR 0.152.
 */
package org.atcraftmc.quark.proxy;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import me.gb2022.apm.local.ListedBroadcastEvent;
import me.gb2022.apm.local.PluginMessageHandler;
import me.gb2022.commons.reflect.AutoRegister;
import org.atcraftmc.qlib.texts.placeholder.ObjectPlaceHolder;
import org.atcraftmc.qlib.texts.placeholder.StringObjectPlaceHolder;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.tbstcraft.quark.foundation.platform.BukkitUtil;
import org.tbstcraft.quark.foundation.platform.Players;
import org.tbstcraft.quark.framework.module.PackageModule;
import org.tbstcraft.quark.framework.module.QuarkModule;
import org.tbstcraft.quark.internal.RemoteMessageService;
import org.tbstcraft.quark.internal.placeholder.PlaceHolderService;
import org.tbstcraft.quark.internal.task.TaskService;

@QuarkModule(defaultEnable=false)
@AutoRegister(value={"qb:el"})
public final class ProxyPing
extends PackageModule {
    private final Map<String, Integer> ping = new HashMap<String, Integer>();

    public void enable() {
        int interval = this.getConfig().getInt("interval");
        TaskService.async().timer("quark:proxy-ping:update", (long)interval, (long)interval, () -> {
            for (Player p : Bukkit.getOnlinePlayers()) {
                this.refreshPing(p);
            }
        });
        PlaceHolderService.PLAYER.register("ping", (ObjectPlaceHolder)((StringObjectPlaceHolder)p -> BukkitUtil.formatPing((int)this.ping((Player)p))));
        PlaceHolderService.PLAYER.register("ping-value", (ObjectPlaceHolder)((StringObjectPlaceHolder)p -> String.valueOf(this.ping((Player)p))));
    }

    public void disable() {
        TaskService.async().cancel("quark:proxy-ping:update");
        PlaceHolderService.PLAYER.register("ping", (ObjectPlaceHolder)((StringObjectPlaceHolder)p -> BukkitUtil.formatPing((int)Players.getPing((Player)p))));
        PlaceHolderService.PLAYER.register("ping-value", (ObjectPlaceHolder)((StringObjectPlaceHolder)p -> String.valueOf(Players.getPing((Player)p))));
    }

    @PluginMessageHandler(value="proxy-ping:update")
    public void onPluginMessage(ListedBroadcastEvent event) {
        this.refreshPing((Player)event.getArgument(0, Player.class));
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.ping(event.getPlayer());
    }

    public int ping(Player player) {
        if (!this.ping.containsKey(player.getName())) {
            return this.refreshPing(player);
        }
        return this.ping.getOrDefault(player.getName(), 0);
    }

    private int refreshPing(Player player) {
        AtomicInteger ping1 = new AtomicInteger(Players.getPing((Player)player));
        RemoteMessageService.instance().query("proxy", "player:ping", (Object)player.getName()).timeout(250L, () -> this.logger.severe("failed to send remote query(%s) for ping!".formatted(player.getName()))).result(b -> ping1.set(Integer.parseInt(b))).request();
        int ping = ping1.get();
        this.ping.put(player.getName(), ping);
        return ping;
    }
}

