/*
 * Decompiled with CFR 0.152.
 */
package com.florlet.quickalias.config;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;

public class AliasNode {
    private String id = UUID.randomUUID().toString();
    private String name;
    private List<String> commands;
    private List<AliasNode> children;
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("^\\{[^}]+}$");

    public AliasNode() {
        this.children = new ArrayList<AliasNode>();
        this.commands = new ArrayList<String>();
        this.name = "";
    }

    public AliasNode(String name) {
        this();
        this.name = name;
    }

    public AliasNode(AliasNode other) {
        this.name = other.name;
        this.commands = new ArrayList<String>(other.commands);
        this.children = new ArrayList<AliasNode>();
        for (AliasNode child : other.children) {
            this.children.add(new AliasNode(child));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    public List<AliasNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<AliasNode> children) {
        this.children = children;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public void addCommand(String cmd) {
        this.commands.add(cmd);
    }

    public void addChild(AliasNode node) {
        this.children.add(node);
    }

    public boolean isVariable() {
        return this.name != null && this.name.length() > 2 && this.name.startsWith("{") && this.name.endsWith("}") && !this.isEndNode();
    }

    public String getVariableName() {
        if (this.isVariable()) {
            return this.name.substring(1, this.name.length() - 1);
        }
        return null;
    }

    public boolean isEndNode() {
        return "{END}".equals(this.name);
    }

    public String toString() {
        return this.name;
    }
}

