/*
 * Decompiled with CFR 0.152.
 */
package com.florlet.quickalias.core;

import com.florlet.quickalias.QuickAliasLogger;
import com.florlet.quickalias.config.AliasNode;
import com.florlet.quickalias.config.ConfigManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.resources.ResourceKey;

public class SuggestionManager {
    private static final SuggestionManager INSTANCE = new SuggestionManager();
    private static Field childrenField;
    private static Field literalsField;
    private static Field argumentsField;
    private CommandDispatcher<SharedSuggestionProvider> dispatcher;
    private List<AliasNode> registeredAliases = new ArrayList<AliasNode>();

    private SuggestionManager() {
    }

    public static SuggestionManager getInstance() {
        return INSTANCE;
    }

    public void init(CommandDispatcher<?> dispatcher) {
        this.dispatcher = dispatcher;
        this.update();
    }

    public void update() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91403_() != null) {
            try {
                this.dispatcher = mc.m_91403_().m_105146_();
            }
            catch (ClassCastException e) {
                QuickAliasLogger.error("Failed to cast command dispatcher", e);
            }
        }
        if (this.dispatcher == null) {
            return;
        }
        try {
            this.removeAliases((CommandNode<SharedSuggestionProvider>)this.dispatcher.getRoot(), this.registeredAliases);
        }
        catch (Exception e) {
            QuickAliasLogger.error("Failed to remove old aliases", e);
        }
        try {
            List<AliasNode> currentAliases = ConfigManager.getInstance().getConfig().aliases;
            this.registerAliases(currentAliases);
            this.registeredAliases = this.deepCopyNodes(currentAliases);
        }
        catch (Exception e) {
            QuickAliasLogger.error("Failed to update command suggestions", e);
        }
    }

    private void registerAliases(List<AliasNode> nodes) {
        for (AliasNode node : nodes) {
            this.registerNode(node, (CommandNode<SharedSuggestionProvider>)this.dispatcher.getRoot());
        }
    }

    private void registerNode(AliasNode aliasNode, CommandNode<SharedSuggestionProvider> parent) {
        CommandNode targetNode;
        CommandNode commandNode;
        CommandNode existingNode;
        String nodeName;
        if (aliasNode.isEndNode()) {
            return;
        }
        String name = aliasNode.getName();
        if (name == null || name.trim().isEmpty()) {
            return;
        }
        boolean isVariable = aliasNode.isVariable();
        String string = nodeName = isVariable ? aliasNode.getVariableName() : name;
        Object builder = isVariable ? ("id".equals(nodeName) ? RequiredArgumentBuilder.argument((String)nodeName, (ArgumentType)StringArgumentType.word()).suggests((context, suggestionsBuilder) -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.m_91403_() != null) {
                Collection players = mc.m_91403_().m_105142_();
                for (PlayerInfo info : players) {
                    suggestionsBuilder.suggest(info.m_105312_().getName());
                }
            }
            return suggestionsBuilder.buildFuture();
        }) : ("dim".equals(nodeName) ? RequiredArgumentBuilder.argument((String)nodeName, (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((context, suggestionsBuilder) -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.m_91403_() != null) {
                Set levels = mc.m_91403_().m_105151_();
                for (ResourceKey levelKey : levels) {
                    suggestionsBuilder.suggest(levelKey.m_135782_().toString());
                }
            }
            return suggestionsBuilder.buildFuture();
        }) : RequiredArgumentBuilder.argument((String)nodeName, (ArgumentType)StringArgumentType.string()))) : LiteralArgumentBuilder.literal((String)nodeName);
        if (!aliasNode.getCommands().isEmpty() || aliasNode.getChildren().isEmpty()) {
            builder.executes(context -> 1);
        }
        if ((existingNode = parent.getChild((commandNode = builder.build()).getName())) != null) {
            targetNode = existingNode;
        } else {
            parent.addChild(commandNode);
            targetNode = commandNode;
        }
        for (AliasNode child : aliasNode.getChildren()) {
            this.registerNode(child, (CommandNode<SharedSuggestionProvider>)targetNode);
        }
    }

    private void removeAliases(CommandNode<SharedSuggestionProvider> parent, List<AliasNode> nodesToRemove) {
        Map argumentsMap;
        Map literalsMap;
        Map childrenMap;
        if (nodesToRemove == null || nodesToRemove.isEmpty()) {
            return;
        }
        if (parent == null) {
            return;
        }
        try {
            childrenMap = (Map)childrenField.get(parent);
            literalsMap = (Map)literalsField.get(parent);
            argumentsMap = (Map)argumentsField.get(parent);
        }
        catch (Exception e) {
            QuickAliasLogger.error("Failed to access CommandNode fields via reflection", e);
            return;
        }
        for (AliasNode alias : nodesToRemove) {
            boolean isVariable;
            String name;
            CommandNode childNode;
            if (alias.isEndNode() || (childNode = (CommandNode)childrenMap.get(name = (isVariable = alias.isVariable()) ? alias.getVariableName() : alias.getName())) == null) continue;
            this.removeAliases((CommandNode<SharedSuggestionProvider>)childNode, alias.getChildren());
            boolean hasChildren = !childNode.getChildren().isEmpty();
            if (hasChildren) continue;
            childrenMap.remove(name);
            if (isVariable) {
                argumentsMap.remove(name);
                continue;
            }
            literalsMap.remove(name);
        }
    }

    private List<AliasNode> deepCopyNodes(List<AliasNode> source) {
        ArrayList<AliasNode> list = new ArrayList<AliasNode>();
        for (AliasNode n : source) {
            AliasNode newNode = new AliasNode(n.getName());
            newNode.setCommands(new ArrayList<String>(n.getCommands()));
            newNode.setChildren(this.deepCopyNodes(n.getChildren()));
            list.add(newNode);
        }
        return list;
    }

    static {
        try {
            childrenField = CommandNode.class.getDeclaredField("children");
            childrenField.setAccessible(true);
            literalsField = CommandNode.class.getDeclaredField("literals");
            literalsField.setAccessible(true);
            argumentsField = CommandNode.class.getDeclaredField("arguments");
            argumentsField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            QuickAliasLogger.error("Failed to initialize reflection for CommandNode", e);
        }
    }
}

