/*
 * Decompiled with CFR 0.152.
 */
package com.florlet.quickalias.gui;

import com.florlet.quickalias.config.AliasNode;
import com.florlet.quickalias.config.ConfigManager;
import com.florlet.quickalias.gui.FlatButton;
import com.florlet.quickalias.gui.SettingsScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class AliasEditorScreen
extends Screen {
    private final Screen parent;
    private final AliasNode originalNode;
    private final AliasNode workingNode;
    private final boolean isNewNode;
    private final int depth;
    private EditBox aliasInput;
    private FlatButton saveButton;
    private FlatButton addSubChildBtn;
    private FlatButton addEndNodeBtn;
    private int cmdAreaTop;
    private int cmdAreaBottom;
    private int childAreaTop;
    private int childAreaBottom;
    private double commandScrollAmount = 0.0;
    private double childScrollAmount = 0.0;
    private final List<AbstractWidget> commandWidgets = new ArrayList<AbstractWidget>();
    private final List<AbstractWidget> childWidgets = new ArrayList<AbstractWidget>();
    private final List<BreadcrumbSeparator> breadcrumbSeparators = new ArrayList<BreadcrumbSeparator>();
    private Component errorMessage = null;
    private boolean saved = false;
    private static final int ITEM_HEIGHT = 20;
    private static final int INPUT_HEIGHT = 14;
    private static final int BUTTON_SIZE = 14;
    private static final int MAX_DEPTH = 10;
    private static final int MAX_COMMANDS = 15;
    private static final Set<String> RESERVED_VARS = Set.of("X", "Y", "Z", "ID", "DIM");
    private static final Pattern VAR_REF_PATTERN = Pattern.compile("(?<!\\\\)\\{([^}]+)}");

    public AliasEditorScreen(Screen parent, AliasNode node, boolean isNewNode) {
        super((Component)Component.m_237115_((String)"quickalias.editor.title"));
        this.parent = parent;
        this.originalNode = node;
        this.isNewNode = isNewNode;
        this.depth = parent instanceof AliasEditorScreen ? ((AliasEditorScreen)parent).depth + 1 : 1;
        this.workingNode = new AliasNode(node);
        if (this.workingNode.getCommands().isEmpty()) {
            this.workingNode.addCommand("");
        }
    }

    protected void m_7856_() {
        int cmdAreaStartY;
        this.m_169413_();
        this.commandWidgets.clear();
        this.childWidgets.clear();
        boolean hasChildren = !this.workingNode.getChildren().isEmpty();
        boolean isMacroMode = this.workingNode.getCommands().size() > 1;
        boolean isEndNode = this.workingNode.isEndNode();
        int breadcrumbBottomY = this.initBreadcrumbs();
        int topMargin = 10;
        int nameInputY = breadcrumbBottomY + topMargin;
        int errorAreaY = nameInputY + 14 + 4;
        int errorHeight = 9;
        this.cmdAreaTop = cmdAreaStartY = errorAreaY + errorHeight + 4;
        int footerHeight = 35;
        int contentBottom = this.f_96544_ - footerHeight;
        if (isMacroMode || isEndNode) {
            this.cmdAreaBottom = contentBottom;
            this.childAreaTop = contentBottom;
            this.childAreaBottom = contentBottom;
        } else if (hasChildren) {
            int singleCmdHeight = 30;
            this.cmdAreaBottom = this.cmdAreaTop + singleCmdHeight;
            this.childAreaTop = this.cmdAreaBottom + 10;
            this.childAreaBottom = contentBottom;
        } else {
            int cmdRows = Math.min(this.workingNode.getCommands().size() + 1, 5);
            int neededCmdHeight = cmdRows * 20 + 10;
            int availableHeight = contentBottom - this.cmdAreaTop;
            int actualCmdHeight = Math.min(neededCmdHeight, (int)((double)availableHeight * 0.6));
            actualCmdHeight = Math.max(actualCmdHeight, 50);
            this.cmdAreaBottom = this.cmdAreaTop + actualCmdHeight;
            this.childAreaTop = this.cmdAreaBottom + 10;
            this.childAreaBottom = contentBottom;
        }
        int centerX = this.f_96543_ / 2;
        int inputWidth = 200;
        int inputX = centerX - 100;
        this.aliasInput = new EditBox(this.f_96547_, inputX, nameInputY, inputWidth, 16, (Component)Component.m_237115_((String)"quickalias.editor.alias_name"));
        this.aliasInput.m_94199_(32);
        this.aliasInput.m_94144_(this.workingNode.getName());
        this.aliasInput.m_94153_(s -> !s.contains(" "));
        this.updateNameInputColor();
        if (isEndNode) {
            this.aliasInput.m_94186_(false);
        }
        this.aliasInput.m_94151_(val -> {
            this.workingNode.setName((String)val);
            this.updateNameInputColor();
            this.validate();
        });
        this.m_142416_((GuiEventListener)this.aliasInput);
        this.buildCommandsList(isMacroMode, hasChildren);
        if (!isMacroMode && !isEndNode) {
            this.buildChildrenList();
        }
        int bottomY = this.f_96544_ - 24;
        this.m_142416_((GuiEventListener)new FlatButton(this.f_96543_ - 130, bottomY, 60, 16, (Component)Component.m_237115_((String)"gui.cancel"), btn -> this.m_7379_()));
        this.saveButton = new FlatButton(this.f_96543_ - 65, bottomY, 60, 16, (Component)Component.m_237115_((String)"gui.done"), btn -> this.saveAndClose());
        this.m_142416_((GuiEventListener)this.saveButton);
        this.validate();
    }

    private void updateNameInputColor() {
        if (this.workingNode.isEndNode()) {
            this.aliasInput.m_94202_(0xAA55FF);
        } else if (this.workingNode.isVariable()) {
            this.aliasInput.m_94202_(0xFFAA00);
        } else {
            this.aliasInput.m_94202_(0xFFFFFF);
        }
    }

    private int initBreadcrumbs() {
        this.breadcrumbSeparators.clear();
        int startX = 10;
        int startY = 8;
        int x = startX;
        int y = startY;
        int lineHeight = 18;
        int indent = 10;
        int maxWidth = this.f_96543_ - 20;
        ArrayList<Screen> chain = new ArrayList<Screen>();
        Screen p = this.parent;
        while (p instanceof AliasEditorScreen) {
            chain.add(p);
            p = ((AliasEditorScreen)p).parent;
        }
        chain.add(p);
        Collections.reverse(chain);
        for (Screen s : chain) {
            MutableComponent labelComp = s instanceof AliasEditorScreen ? Component.m_237113_((String)(((AliasEditorScreen)s).originalNode.getName().isEmpty() ? "?" : ((AliasEditorScreen)s).originalNode.getName())) : Component.m_237115_((String)"quickalias.editor.nav.home");
            int btnWidth = this.f_96547_.m_92852_((FormattedText)labelComp) + 10;
            if (x + btnWidth > maxWidth) {
                x = startX + indent;
                y += lineHeight;
            }
            this.m_142416_((GuiEventListener)new FlatButton(x, y, btnWidth, 14, (Component)labelComp, btn -> {
                this.m_7379_();
                this.f_96541_.m_91152_(s);
            }));
            MutableComponent sepText = Component.m_237113_((String)">");
            int sepWidth = this.f_96547_.m_92852_((FormattedText)sepText);
            if ((x += btnWidth + 2) + sepWidth > maxWidth) {
                x = startX + indent;
                y += lineHeight;
            }
            this.breadcrumbSeparators.add(new BreadcrumbSeparator(x, y + 3, (Component)sepText));
            x += sepWidth + 5;
        }
        String currentName = this.workingNode.getName().isEmpty() ? (this.isNewNode ? "[ ]" : "?") : this.workingNode.getName();
        MutableComponent currentComp = Component.m_237113_((String)currentName);
        int curWidth = this.f_96547_.m_92852_((FormattedText)currentComp) + 10;
        if (x + curWidth > maxWidth) {
            x = startX + indent;
            y += lineHeight;
        }
        FlatButton curBtn = new FlatButton(x, y, curWidth, 14, (Component)currentComp, btn -> {});
        curBtn.f_93623_ = false;
        this.m_142416_((GuiEventListener)curBtn);
        return y + lineHeight;
    }

    private void rebuildInterface() {
        this.m_7856_();
    }

    private void buildCommandsList(boolean isMacroMode, boolean hasChildren) {
        int currentCmdCount = this.workingNode.getCommands().size();
        boolean showAddButton = !hasChildren && currentCmdCount < 15;
        int contentHeight = currentCmdCount * 20 + (showAddButton ? 20 : 0);
        int viewHeight = this.cmdAreaBottom - this.cmdAreaTop;
        double maxScroll = Math.max(0, contentHeight - viewHeight);
        this.commandScrollAmount = Mth.m_14008_((double)this.commandScrollAmount, (double)0.0, (double)maxScroll);
        int startY = (int)((double)this.cmdAreaTop - this.commandScrollAmount);
        int centerX = this.f_96543_ / 2;
        for (int i = 0; i < this.workingNode.getCommands().size(); ++i) {
            int itemY = startY + i * 20;
            boolean isVisible = itemY + 20 > this.cmdAreaTop && itemY < this.cmdAreaBottom;
            String cmd = this.workingNode.getCommands().get(i);
            EditBox cmdBox = new EditBox(this.f_96547_, centerX - 100, itemY + 2, 200, 14, (Component)Component.m_237113_((String)"Cmd"));
            cmdBox.m_94199_(256);
            cmdBox.m_94144_(cmd);
            cmdBox.f_93624_ = isVisible;
            cmdBox.m_94202_(0xFFFFFF);
            int idx = i;
            cmdBox.m_94151_(val -> {
                if (idx < this.workingNode.getCommands().size()) {
                    this.workingNode.getCommands().set(idx, (String)val);
                    this.validate();
                }
            });
            this.m_7787_((GuiEventListener)cmdBox);
            this.commandWidgets.add((AbstractWidget)cmdBox);
            boolean isLastOne = this.workingNode.getCommands().size() == 1;
            FlatButton delBtn = new FlatButton(centerX + 105, itemY + 2, 14, 14, (Component)Component.m_237113_((String)"\u00d7").m_130938_(s -> s.m_178520_(0xFF5555)), btn -> {
                if (isLastOne && hasChildren) {
                    this.workingNode.getCommands().set(0, "");
                    cmdBox.m_94144_("");
                    this.validate();
                } else if (isLastOne) {
                    this.workingNode.getCommands().set(0, "");
                    cmdBox.m_94144_("");
                    this.validate();
                } else {
                    this.workingNode.getCommands().remove(idx);
                    this.rebuildInterface();
                }
            });
            delBtn.f_93624_ = isVisible;
            this.m_7787_((GuiEventListener)delBtn);
            this.commandWidgets.add((AbstractWidget)delBtn);
        }
        if (showAddButton) {
            int addButtonY = startY + this.workingNode.getCommands().size() * 20;
            boolean isVisible = addButtonY + 20 > this.cmdAreaTop && addButtonY < this.cmdAreaBottom;
            FlatButton addBtn = new FlatButton(centerX - 100, addButtonY + 2, 200, 16, (Component)Component.m_237115_((String)"quickalias.editor.add_cmd"), btn -> {
                this.workingNode.addCommand("");
                if (contentHeight + 20 > viewHeight) {
                    this.commandScrollAmount = contentHeight + 20 - viewHeight;
                }
                this.rebuildInterface();
            });
            addBtn.f_93624_ = isVisible;
            this.m_7787_((GuiEventListener)addBtn);
            this.commandWidgets.add((AbstractWidget)addBtn);
        }
    }

    private Component formatCommandWithVariables(String cmd) {
        MutableComponent root = Component.m_237119_();
        Matcher m = VAR_REF_PATTERN.matcher(cmd);
        int lastEnd = 0;
        while (m.find()) {
            if (m.start() > lastEnd) {
                root.m_7220_((Component)Component.m_237113_((String)cmd.substring(lastEnd, m.start())).m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)));
            }
            root.m_7220_((Component)Component.m_237113_((String)m.group()).m_130948_(Style.f_131099_.m_178520_(0xFFAA00)));
            lastEnd = m.end();
        }
        if (lastEnd < cmd.length()) {
            root.m_7220_((Component)Component.m_237113_((String)cmd.substring(lastEnd)).m_130948_(Style.f_131099_.m_178520_(0xFFFFFF)));
        }
        return root;
    }

    private void buildChildrenList() {
        boolean isVisible;
        int contentHeight = this.workingNode.getChildren().size() * 20 + 20;
        int viewHeight = this.childAreaBottom - this.childAreaTop;
        double maxScroll = Math.max(0, contentHeight - viewHeight);
        this.childScrollAmount = Mth.m_14008_((double)this.childScrollAmount, (double)0.0, (double)maxScroll);
        int startY = (int)((double)this.childAreaTop - this.childScrollAmount);
        int centerX = this.f_96543_ / 2;
        boolean hasVariableChild = this.workingNode.getChildren().stream().anyMatch(AliasNode::isVariable);
        boolean hasEndNode = this.workingNode.getChildren().stream().anyMatch(AliasNode::isEndNode);
        for (int i = 0; i < this.workingNode.getChildren().size(); ++i) {
            int itemY = startY + i * 20;
            boolean isVisible2 = itemY + 20 > this.childAreaTop && itemY < this.childAreaBottom;
            AliasNode child = this.workingNode.getChildren().get(i);
            String rawLabel = child.getName() + " -> " + (child.getCommands().isEmpty() ? "..." : child.getCommands().get(0));
            String childName = child.getName();
            String childCmd = child.getCommands().isEmpty() ? "..." : child.getCommands().get(0);
            int nameColor = 0xFFFFFF;
            if (child.isVariable()) {
                nameColor = 0xFFAA00;
            }
            if (child.isEndNode()) {
                nameColor = 0xAA55FF;
            }
            Component cmdComponent = this.formatCommandWithVariables(childCmd);
            MutableComponent buttonLabel = Component.m_237113_((String)childName).m_130948_(Style.f_131099_.m_178520_(nameColor)).m_7220_((Component)Component.m_237113_((String)" -> ").m_130948_(Style.f_131099_.m_178520_(0x888888))).m_7220_(cmdComponent);
            FlatButton childBtn = new FlatButton(centerX - 100, itemY + 2, 200, 14, (Component)buttonLabel, btn -> this.f_96541_.m_91152_((Screen)new AliasEditorScreen(this, child, false)));
            childBtn.f_93624_ = isVisible2;
            this.m_7787_((GuiEventListener)childBtn);
            this.childWidgets.add((AbstractWidget)childBtn);
            FlatButton delBtn = new FlatButton(centerX + 105, itemY + 2, 14, 14, (Component)Component.m_237113_((String)"\u00d7").m_130938_(s -> s.m_178520_(0xFF5555)), btn -> {
                this.workingNode.getChildren().remove(child);
                this.rebuildInterface();
            });
            delBtn.f_93624_ = isVisible2;
            this.m_7787_((GuiEventListener)delBtn);
            this.childWidgets.add((AbstractWidget)delBtn);
        }
        int addButtonY = startY + this.workingNode.getChildren().size() * 20;
        boolean bl = isVisible = addButtonY + 20 > this.childAreaTop && addButtonY < this.childAreaBottom;
        if (hasVariableChild) {
            if (!hasEndNode) {
                MutableComponent endLabel = Component.m_237113_((String)"+ ").m_7220_((Component)Component.m_237113_((String)"END").m_130948_(Style.f_131099_.m_178520_(0xAA55FF)));
                this.addEndNodeBtn = new FlatButton(centerX - 100, addButtonY + 2, 200, 16, (Component)endLabel, btn -> {
                    AliasNode newChild = new AliasNode("{END}");
                    this.workingNode.addChild(newChild);
                    this.f_96541_.m_91152_((Screen)new AliasEditorScreen(this, newChild, true));
                });
                this.addEndNodeBtn.f_93624_ = isVisible;
                this.m_7787_((GuiEventListener)this.addEndNodeBtn);
                this.childWidgets.add((AbstractWidget)this.addEndNodeBtn);
            }
        } else {
            this.addSubChildBtn = new FlatButton(centerX - 100, addButtonY + 2, 200, 16, (Component)Component.m_237115_((String)"quickalias.editor.add_sub"), btn -> {
                AliasNode newChild = new AliasNode("");
                this.workingNode.addChild(newChild);
                this.f_96541_.m_91152_((Screen)new AliasEditorScreen(this, newChild, true));
            });
            this.addSubChildBtn.f_93624_ = isVisible;
            this.m_7787_((GuiEventListener)this.addSubChildBtn);
            this.childWidgets.add((AbstractWidget)this.addSubChildBtn);
        }
    }

    private void validate() {
        List<AliasNode> siblings;
        this.errorMessage = null;
        boolean valid = true;
        String name = this.aliasInput.m_94155_().trim();
        if (name.isEmpty()) {
            valid = false;
        }
        for (String cmd : this.workingNode.getCommands()) {
            if (!cmd.contains("{END}")) continue;
            this.errorMessage = Component.m_237115_((String)"quickalias.editor.error.reserved");
            valid = false;
            break;
        }
        if (valid && this.isRootNode()) {
            if (this.isVariable(name)) {
                this.errorMessage = Component.m_237115_((String)"quickalias.editor.error.root_variable");
                valid = false;
            }
            if ("{END}".equals(name)) {
                this.errorMessage = Component.m_237115_((String)"quickalias.editor.error.root_variable");
                valid = false;
            }
        }
        if (valid) {
            siblings = this.getSiblings();
            boolean isCurrentVar = this.isVariable(name);
            if (isCurrentVar) {
                for (AliasNode s : siblings) {
                    if (s == this.originalNode || s.isEndNode()) continue;
                    this.errorMessage = Component.m_237115_((String)"quickalias.editor.error.variable_sibling");
                    valid = false;
                    break;
                }
            } else if (!this.workingNode.isEndNode()) {
                for (AliasNode s : siblings) {
                    if (s == this.originalNode || !s.isVariable()) continue;
                    this.errorMessage = Component.m_237115_((String)"quickalias.editor.error.variable_sibling");
                    valid = false;
                    break;
                }
            }
        }
        if (valid) {
            siblings = this.getSiblings();
            for (AliasNode n : siblings) {
                if (n == this.originalNode || !n.getName().equalsIgnoreCase(name)) continue;
                this.errorMessage = Component.m_237115_((String)"quickalias.editor.warning.duplicate");
                valid = false;
                break;
            }
        }
        if (valid && RESERVED_VARS.contains(name.toUpperCase())) {
            this.errorMessage = Component.m_237115_((String)"quickalias.editor.error.reserved");
            valid = false;
        }
        if (valid && this.isVariable(name)) {
            String varName = name.substring(1, name.length() - 1);
            if (this.getParentVariableNames().contains(varName)) {
                this.errorMessage = Component.m_237115_((String)"quickalias.editor.error.duplicate_var");
                valid = false;
            }
        }
        if (valid) {
            HashSet<String> validVars = new HashSet<String>();
            validVars.addAll(RESERVED_VARS);
            validVars.addAll(this.getParentVariableNames());
            if (this.isVariable(name)) {
                validVars.add(name.substring(1, name.length() - 1));
            }
            for (String cmd : this.workingNode.getCommands()) {
                Matcher m = VAR_REF_PATTERN.matcher(cmd);
                while (m.find()) {
                    String ref = m.group(1);
                    if (validVars.contains(ref)) continue;
                    this.errorMessage = Component.m_237110_((String)"quickalias.editor.error.unknown_var", (Object[])new Object[]{ref});
                    valid = false;
                    break;
                }
                if (valid) continue;
                break;
            }
        }
        if (this.saveButton != null) {
            this.saveButton.f_93623_ = valid;
        }
        if (this.addSubChildBtn != null) {
            boolean isEnd = this.workingNode.isEndNode();
            long cmdCount = this.workingNode.getCommands().size();
            boolean isMacroMode = cmdCount > 1L;
            boolean hasVariableChild = this.workingNode.getChildren().stream().anyMatch(AliasNode::isVariable);
            boolean bl = this.addSubChildBtn.f_93623_ = valid && !isEnd && this.depth < 10 && !isMacroMode && !hasVariableChild;
        }
        if (this.addEndNodeBtn != null) {
            boolean isEnd = this.workingNode.isEndNode();
            long cmdCount = this.workingNode.getCommands().size();
            boolean isMacroMode = cmdCount > 1L;
            this.addEndNodeBtn.f_93623_ = valid && !isEnd && this.depth < 10 && !isMacroMode;
        }
    }

    private boolean isRootNode() {
        return this.depth == 1;
    }

    private boolean isVariable(String s) {
        return s.startsWith("{") && s.endsWith("}") && s.length() > 2 && !"{END}".equals(s);
    }

    private List<AliasNode> getSiblings() {
        if (this.isRootNode()) {
            return ConfigManager.getInstance().getConfig().aliases;
        }
        if (this.parent instanceof AliasEditorScreen) {
            return ((AliasEditorScreen)this.parent).workingNode.getChildren();
        }
        return Collections.emptyList();
    }

    private Set<String> getParentVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        Screen p = this.parent;
        while (p instanceof AliasEditorScreen) {
            AliasNode n = ((AliasEditorScreen)p).workingNode;
            if (n.isVariable()) {
                vars.add(n.getVariableName());
            }
            p = ((AliasEditorScreen)p).parent;
        }
        return vars;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY == 0.0) {
            return false;
        }
        double scrollSpeed = 15.0;
        int centerX = this.f_96543_ / 2;
        int areaLeft = centerX - 120;
        int areaRight = centerX + 120;
        if (mouseX >= (double)areaLeft && mouseX <= (double)areaRight) {
            if (mouseY >= (double)this.cmdAreaTop && mouseY <= (double)this.cmdAreaBottom) {
                this.commandScrollAmount -= scrollY * scrollSpeed;
                this.rebuildInterface();
                return true;
            }
            if (mouseY >= (double)this.childAreaTop && mouseY <= (double)this.childAreaBottom) {
                this.childScrollAmount -= scrollY * scrollSpeed;
                this.rebuildInterface();
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, scrollX, scrollY);
    }

    private void saveAndClose() {
        if (!this.saveButton.f_93623_) {
            return;
        }
        this.saved = true;
        this.workingNode.setName(this.aliasInput.m_94155_().trim());
        this.workingNode.getCommands().removeIf(String::isEmpty);
        if (this.isNewNode && this.isRootNode()) {
            ConfigManager.getInstance().getConfig().aliases.add(this.workingNode);
        } else {
            this.copyNodeData(this.workingNode, this.originalNode);
        }
        ConfigManager.getInstance().save();
        if (this.parent instanceof SettingsScreen) {
            ((SettingsScreen)this.parent).refreshList();
        }
        if (this.parent instanceof AliasEditorScreen) {
            ((AliasEditorScreen)this.parent).rebuildInterface();
        }
        this.f_96541_.m_91152_(this.parent);
    }

    private void copyNodeData(AliasNode source, AliasNode target) {
        target.setName(source.getName());
        target.setCommands(new ArrayList<String>(source.getCommands()));
        target.setChildren(new ArrayList<AliasNode>(source.getChildren()));
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics, mouseX, mouseY, partialTick);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        for (BreadcrumbSeparator sep : this.breadcrumbSeparators) {
            guiGraphics.m_280430_(this.f_96547_, sep.text, sep.x, sep.y, 0xAAAAAA);
        }
        guiGraphics.m_280588_(0, this.cmdAreaTop, this.f_96543_, this.cmdAreaBottom);
        for (AbstractWidget widget : this.commandWidgets) {
            widget.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        guiGraphics.m_280618_();
        boolean isMacroMode = this.workingNode.getCommands().size() > 1;
        boolean isEndNode = this.workingNode.isEndNode();
        if (!isMacroMode && !isEndNode) {
            guiGraphics.m_280588_(0, this.childAreaTop, this.f_96543_, this.childAreaBottom);
            for (AbstractWidget widget : this.childWidgets) {
                widget.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }
            guiGraphics.m_280618_();
        }
        int centerX = this.f_96543_ / 2;
        int inputLeftX = centerX - 100;
        int labelAnchorX = inputLeftX - 15;
        if (this.isRootNode()) {
            guiGraphics.m_280168_().m_85836_();
            float scale = 1.5f;
            guiGraphics.m_280168_().m_252880_((float)(labelAnchorX + 4), (float)(this.aliasInput.m_252907_() + 2), 0.0f);
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280488_(this.f_96547_, "/", 0, 0, 0xAAAAAA);
            guiGraphics.m_280168_().m_85849_();
        }
        MutableComponent aliasLabel = Component.m_237115_((String)"quickalias.editor.label.alias");
        guiGraphics.m_280430_(this.f_96547_, (Component)aliasLabel, labelAnchorX - this.f_96547_.m_92852_((FormattedText)aliasLabel), this.aliasInput.m_252907_() + 4, 0xAAAAAA);
        MutableComponent cmdLabel = Component.m_237115_((String)"quickalias.editor.label.cmd");
        guiGraphics.m_280430_(this.f_96547_, (Component)cmdLabel, labelAnchorX - this.f_96547_.m_92852_((FormattedText)cmdLabel), this.cmdAreaTop + 4, 0xAAAAAA);
        if (!isMacroMode && !isEndNode) {
            MutableComponent subLabel = Component.m_237115_((String)"quickalias.editor.label.sub_options");
            guiGraphics.m_280430_(this.f_96547_, (Component)subLabel, labelAnchorX - this.f_96547_.m_92852_((FormattedText)subLabel), this.childAreaTop + 4, 0xAAAAAA);
        }
        if (this.errorMessage != null) {
            int errorY = this.aliasInput.m_252907_() + 14 + 6;
            guiGraphics.m_280430_(this.f_96547_, this.errorMessage, centerX - 100, errorY, 0xFF5555);
        }
    }

    public void m_7379_() {
        Screen screen;
        if (!this.saved && this.isNewNode && (screen = this.parent) instanceof AliasEditorScreen) {
            AliasEditorScreen pEditor = (AliasEditorScreen)screen;
            pEditor.workingNode.getChildren().remove(this.originalNode);
            pEditor.rebuildInterface();
        }
        this.f_96541_.m_91152_(this.parent);
    }

    private record BreadcrumbSeparator(int x, int y, Component text) {
    }
}

