/*
 * Decompiled with CFR 0.152.
 */
package com.florlet.quickalias.mixin;

import com.florlet.quickalias.config.ConfigManager;
import com.florlet.quickalias.core.InputHandler;
import com.florlet.quickalias.core.SuggestionManager;
import com.florlet.quickalias.gui.FlatButton;
import com.florlet.quickalias.gui.SettingsScreen;
import com.florlet.quickalias.gui.ShortcutOverlay;
import com.florlet.quickalias.mixin.ChatScreenAccessor;
import com.florlet.quickalias.mixin.EditBoxAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatScreen.class})
public class ChatScreenMixin
extends Screen {
    @Unique
    private ShortcutOverlay quickAlias$shortcutOverlay;
    @Unique
    private Button quickAlias$qaSettingsButton;
    @Unique
    private Button quickAlias$qaShortcutButton;
    @Unique
    private int quickAlias$qaChatInputX = -1;
    @Unique
    private int quickAlias$qaChatInputY = 0;

    protected ChatScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        int barTopY;
        SuggestionManager.getInstance().update();
        ConfigManager.AliasConfig config = ConfigManager.getInstance().getConfig();
        EditBox input = ((ChatScreenAccessor)((Object)this)).getInput();
        int buttonSize = 20;
        int spacing = 2;
        int marginLeft = 2;
        int marginBottom = 2;
        int barHeight = 20;
        int inputWidgetHeight = 12;
        this.quickAlias$qaChatInputY = barTopY = this.f_96544_ - barHeight - marginBottom;
        int currentX = marginLeft;
        if (config.settings.showSettingsButton) {
            this.quickAlias$qaSettingsButton = new FlatButton(currentX, barTopY, buttonSize, buttonSize, (Component)Component.m_237113_((String)"\u2699"), btn -> Minecraft.m_91087_().m_91152_((Screen)new SettingsScreen(this)));
            this.m_142416_((GuiEventListener)this.quickAlias$qaSettingsButton);
            currentX += buttonSize + spacing;
        }
        if (config.settings.showShortcutButton) {
            this.quickAlias$qaShortcutButton = new FlatButton(currentX, barTopY, buttonSize, buttonSize, (Component)Component.m_237113_((String)"/"), btn -> {
                if (this.quickAlias$shortcutOverlay == null) {
                    this.quickAlias$shortcutOverlay = new ShortcutOverlay(this.f_96543_, this.f_96544_);
                }
                this.quickAlias$shortcutOverlay.toggle();
                if (!this.quickAlias$shortcutOverlay.isVisible() && input != null) {
                    this.m_7522_((GuiEventListener)input);
                }
            });
            this.m_142416_((GuiEventListener)this.quickAlias$qaShortcutButton);
            currentX += buttonSize + spacing;
        }
        this.quickAlias$shortcutOverlay = new ShortcutOverlay(this.f_96543_, this.f_96544_);
        this.quickAlias$qaChatInputX = currentX;
        if (input != null) {
            int extra = 4;
            ((EditBoxAccessor)input).setHeight(inputWidgetHeight);
            int centeredY = barTopY + (barHeight - inputWidgetHeight + extra) / 2;
            input.m_253211_(centeredY);
            input.m_252865_(this.quickAlias$qaChatInputX + extra);
            input.m_93674_(this.f_96543_ - this.quickAlias$qaChatInputX - 2);
        }
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V"))
    private void quickalias$redirectChatBackgroundFill(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int color) {
        int modifiedX1 = x1;
        int modifiedY1 = y1;
        if (y2 >= this.f_96544_ - 5 && this.quickAlias$qaChatInputX > 0) {
            modifiedX1 = this.quickAlias$qaChatInputX;
            modifiedY1 = this.quickAlias$qaChatInputY;
        }
        guiGraphics.m_280509_(modifiedX1, modifiedY1, x2, y2, color);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (this.quickAlias$shortcutOverlay != null && this.quickAlias$shortcutOverlay.isVisible()) {
            int anchorX = this.quickAlias$qaShortcutButton != null ? this.quickAlias$qaShortcutButton.m_252754_() : 0;
            int anchorY = this.quickAlias$qaShortcutButton != null ? this.quickAlias$qaShortcutButton.m_252907_() : this.f_96544_;
            Minecraft mc = Minecraft.m_91087_();
            double rawMouseX = mc.f_91067_.m_91589_() * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85443_();
            double rawMouseY = mc.f_91067_.m_91594_() * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85444_();
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 500.0f);
            this.quickAlias$shortcutOverlay.render(guiGraphics, (int)rawMouseX, (int)rawMouseY, anchorX, anchorY);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (this.quickAlias$shortcutOverlay != null && this.quickAlias$shortcutOverlay.isVisible()) {
            if (this.quickAlias$shortcutOverlay.mouseClicked(mouseX, mouseY, button)) {
                EditBox input = ((ChatScreenAccessor)((Object)this)).getInput();
                if (input != null) {
                    this.m_7522_((GuiEventListener)input);
                }
                cir.setReturnValue((Object)true);
            } else {
                EditBox input = ((ChatScreenAccessor)((Object)this)).getInput();
                if (input != null) {
                    this.m_7522_((GuiEventListener)input);
                }
            }
        }
    }

    @Inject(method={"mouseScrolled"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY, CallbackInfoReturnable<Boolean> cir) {
        if (this.quickAlias$shortcutOverlay != null && this.quickAlias$shortcutOverlay.isVisible() && this.quickAlias$shortcutOverlay.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void onKeyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (this.quickAlias$shortcutOverlay != null && this.quickAlias$shortcutOverlay.isVisible()) {
            if (keyCode == 256) {
                this.quickAlias$shortcutOverlay.toggle();
                EditBox input = ((ChatScreenAccessor)((Object)this)).getInput();
                if (input != null) {
                    this.m_7522_((GuiEventListener)input);
                }
                cir.setReturnValue((Object)true);
                return;
            }
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"handleChatInput"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHandleChatInput(String message, boolean addToHistory, CallbackInfoReturnable<Boolean> cir) {
        if (InputHandler.handleChatInput(message)) {
            cir.setReturnValue((Object)true);
        }
    }
}

