/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.util.function.Consumer;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AirdropAnimation {
    private final AthiSAirdrops plugin;
    private BukkitTask animationTask;
    private ArmorStand currentDropStand;

    public AirdropAnimation(AthiSAirdrops plugin) {
        this.plugin = plugin;
    }

    public void start(final Location target, final Consumer<Location> onFinish) {
        this.stop();
        if (target == null) {
            return;
        }
        boolean enabled = this.plugin.getConfig().getBoolean("animation.enabled", true);
        if (!enabled) {
            try {
                onFinish.accept(target);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        World world = target.getWorld();
        if (world == null) {
            return;
        }
        int height = Math.max(0, this.plugin.getConfig().getInt("animation.height", 50));
        long intervalTicks = Math.max(1, this.plugin.getConfig().getInt("animation.interval_ticks", 2));
        double blocksPerTick = this.plugin.getConfig().getDouble("animation.blocks_per_tick", 0.1);
        if (blocksPerTick <= 0.0) {
            blocksPerTick = 0.1;
        }
        final Location startLoc = target.clone().add(0.0, (double)height, 0.0);
        this.currentDropStand = (ArmorStand)world.spawnEntity(startLoc, EntityType.ARMOR_STAND);
        this.currentDropStand.setInvisible(true);
        this.currentDropStand.setMarker(true);
        this.currentDropStand.setGravity(false);
        this.currentDropStand.setInvulnerable(true);
        this.currentDropStand.setCollidable(false);
        this.currentDropStand.getEquipment().setHelmet(new ItemStack(Material.CHEST));
        this.currentDropStand.setCustomNameVisible(false);
        final double descentPerRun = blocksPerTick * (double)intervalTicks;
        this.animationTask = new BukkitRunnable(){
            double currentY;
            {
                this.currentY = startLoc.getY();
            }

            public void run() {
                if (AirdropAnimation.this.currentDropStand == null || AirdropAnimation.this.currentDropStand.isDead()) {
                    this.cancel();
                    AirdropAnimation.this.animationTask = null;
                    return;
                }
                this.currentY -= descentPerRun;
                if (this.currentY <= target.getY()) {
                    if (AirdropAnimation.this.currentDropStand != null) {
                        AirdropAnimation.this.currentDropStand.remove();
                        AirdropAnimation.this.currentDropStand = null;
                    }
                    try {
                        onFinish.accept(target);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.cancel();
                    AirdropAnimation.this.animationTask = null;
                    return;
                }
                Location newLoc = AirdropAnimation.this.currentDropStand.getLocation();
                newLoc.setY(this.currentY);
                AirdropAnimation.this.currentDropStand.teleport(newLoc);
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, intervalTicks);
    }

    public void stop() {
        if (this.animationTask != null) {
            this.animationTask.cancel();
            this.animationTask = null;
        }
        if (this.currentDropStand != null) {
            this.currentDropStand.remove();
            this.currentDropStand = null;
        }
    }
}

