/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.util.Random;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class AirdropLocationPicker {
    private final AthiSAirdrops plugin;
    private final Random random = new Random();

    public AirdropLocationPicker(AthiSAirdrops plugin) {
        this.plugin = plugin;
    }

    public Location pickRandomValidLocation(World world) {
        boolean onlyLoaded = this.plugin.getConfig().getBoolean("spawn_in_loaded_chunks_only", true);
        int radius = Math.max(10, this.plugin.getConfig().getInt("spawn_radius", 1000));
        int centerX = this.plugin.getConfig().getInt("center_x", world.getSpawnLocation().getBlockX());
        int centerZ = this.plugin.getConfig().getInt("center_z", world.getSpawnLocation().getBlockZ());
        int MAX_ATTEMPTS = this.plugin.getConfig().getInt("max_location_attempts", 100);
        if (onlyLoaded) {
            Chunk[] loaded = world.getLoadedChunks();
            if (loaded.length == 0) {
                this.plugin.getLogger().info("AirdropLocationPicker: no loaded chunks in world '" + world.getName() + "'. Falling back to radius-based search.");
            } else {
                for (int attempts = 0; attempts < MAX_ATTEMPTS; ++attempts) {
                    Block below;
                    int bz;
                    int by;
                    Chunk c = loaded[this.random.nextInt(loaded.length)];
                    int bx = (c.getX() << 4) + this.random.nextInt(16);
                    Location loc = new Location(world, (double)bx + 0.5, (double)(by = world.getHighestBlockYAt(bx, bz = (c.getZ() << 4) + this.random.nextInt(16))) + 1.0, (double)bz + 0.5);
                    Block block = loc.getBlock();
                    if (!this.isValidSurface(block, below = loc.clone().subtract(0.0, 1.0, 0.0).getBlock())) continue;
                    return loc;
                }
                this.plugin.getLogger().info("AirdropLocationPicker: failed to find valid location in loaded chunks after " + MAX_ATTEMPTS + " attempts.");
                return null;
            }
        }
        boolean loadIfGenerated = this.plugin.getConfig().getBoolean("load_generated_chunk_if_unloaded", false);
        for (int i = 0; i < MAX_ATTEMPTS; ++i) {
            Block below;
            int y;
            Location loc;
            Block block;
            boolean generated;
            int x = centerX + this.random.nextInt(radius * 2 + 1) - radius;
            int z = centerZ + this.random.nextInt(radius * 2 + 1) - radius;
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            try {
                generated = world.isChunkGenerated(chunkX, chunkZ);
            }
            catch (NoSuchMethodError | UnsupportedOperationException ex) {
                if (!world.isChunkLoaded(chunkX, chunkZ)) continue;
                generated = true;
            }
            if (!generated) continue;
            if (!world.isChunkLoaded(chunkX, chunkZ)) {
                if (!loadIfGenerated) continue;
                world.getChunkAt(chunkX, chunkZ).load(true);
            }
            if (!this.isValidSurface(block = (loc = new Location(world, (double)x + 0.5, (double)(y = world.getHighestBlockYAt(x, z)) + 1.0, (double)z + 0.5)).getBlock(), below = loc.clone().subtract(0.0, 1.0, 0.0).getBlock())) continue;
            return loc;
        }
        this.plugin.getLogger().info("AirdropLocationPicker: failed to find valid location in radius-based search after " + MAX_ATTEMPTS + " attempts.");
        return null;
    }

    private boolean isValidSurface(Block block, Block below) {
        if (block == null || below == null) {
            return false;
        }
        Material b = block.getType();
        Material bl = below.getType();
        if (b == Material.LAVA || b == Material.WATER) {
            return false;
        }
        if (bl == Material.LAVA || bl == Material.WATER) {
            return false;
        }
        return below.getType().isSolid();
    }
}

