/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.athlantes.athiSAirdrops.BlockLocationKey;
import org.bukkit.Location;

public class AirdropLockManager {
    private final ConcurrentMap<BlockLocationKey, Long> unlockTimes = new ConcurrentHashMap<BlockLocationKey, Long>();

    public void addLock(Location loc, long unlockAtMillis) {
        this.unlockTimes.put(BlockLocationKey.from(loc), unlockAtMillis);
    }

    public boolean isLocked(Location loc) {
        BlockLocationKey key = BlockLocationKey.from(loc);
        Long at = (Long)this.unlockTimes.get(key);
        if (at == null) {
            return false;
        }
        if (System.currentTimeMillis() >= at) {
            this.unlockTimes.remove(key);
            return false;
        }
        return true;
    }

    public void removeLock(Location loc) {
        this.unlockTimes.remove(BlockLocationKey.from(loc));
    }

    public void clear() {
        this.unlockTimes.clear();
    }
}

