/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.athlantes.athiSAirdrops.BlockLocationKey;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AirdropAnimation {
    private final AthiSAirdrops plugin;
    private final Map<BlockLocationKey, AnimationState> animations = new ConcurrentHashMap<BlockLocationKey, AnimationState>();

    public AirdropAnimation(AthiSAirdrops plugin) {
        this.plugin = plugin;
    }

    public void start(final Location target, final Consumer<Location> onFinish) {
        if (target == null) {
            return;
        }
        boolean enabled = this.plugin.getConfig().getBoolean("animation.enabled", true);
        if (!enabled) {
            try {
                onFinish.accept(target);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        World world = target.getWorld();
        if (world == null) {
            return;
        }
        this.stop(target);
        int height = Math.max(0, this.plugin.getConfig().getInt("animation.height", 50));
        long intervalTicks = Math.max(1, this.plugin.getConfig().getInt("animation.interval_ticks", 2));
        double blocksPerTick = this.plugin.getConfig().getDouble("animation.blocks_per_tick", 0.1);
        if (blocksPerTick <= 0.0) {
            blocksPerTick = 0.1;
        }
        final Location startLoc = target.clone().add(0.0, (double)height, 0.0);
        final ArmorStand stand = (ArmorStand)world.spawnEntity(startLoc, EntityType.ARMOR_STAND);
        stand.setInvisible(true);
        stand.setMarker(true);
        stand.setGravity(false);
        stand.setInvulnerable(true);
        stand.setCollidable(false);
        stand.getEquipment().setHelmet(new ItemStack(Material.CHEST));
        stand.setCustomNameVisible(false);
        final double descentPerRun = blocksPerTick * (double)intervalTicks;
        final BlockLocationKey key = BlockLocationKey.from(target);
        BukkitTask task = new BukkitRunnable(){
            double currentY;
            {
                this.currentY = startLoc.getY();
            }

            public void run() {
                if (stand == null || stand.isDead()) {
                    this.cancel();
                    AirdropAnimation.this.animations.remove(key);
                    return;
                }
                this.currentY -= descentPerRun;
                if (this.currentY <= target.getY()) {
                    try {
                        stand.remove();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    AirdropAnimation.this.animations.remove(key);
                    try {
                        onFinish.accept(target);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.cancel();
                    return;
                }
                Location newLoc = stand.getLocation();
                newLoc.setY(this.currentY);
                stand.teleport(newLoc);
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, intervalTicks);
        this.animations.put(key, new AnimationState(stand, task));
    }

    public void stop(Location loc) {
        if (loc == null) {
            return;
        }
        AnimationState s = this.animations.remove(BlockLocationKey.from(loc));
        if (s == null) {
            return;
        }
        try {
            s.task.cancel();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (s.stand != null && !s.stand.isDead()) {
                s.stand.remove();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void stopAll() {
        for (AnimationState s : this.animations.values()) {
            try {
                s.task.cancel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (s.stand == null || s.stand.isDead()) continue;
                s.stand.remove();
            }
            catch (Throwable throwable) {}
        }
        this.animations.clear();
    }

    private static final class AnimationState {
        final ArmorStand stand;
        final BukkitTask task;

        AnimationState(ArmorStand stand, BukkitTask task) {
            this.stand = stand;
            this.task = task;
        }
    }
}

