/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.athlantes.athiSAirdrops.AirdropManager;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.athlantes.athiSAirdrops.Messages;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class AirdropCommand
implements CommandExecutor {
    public static final Map<String, Subcommand> SUBCOMMANDS = new LinkedHashMap<String, Subcommand>();

    public AirdropCommand(AthiSAirdrops plugin, AirdropManager manager) {
        this.register(new Subcommand("locate", "athisairdrops.locate", "/airdrop locate", (sender, args) -> Messages.send(sender, "messages.airdrop_locate_hint", new String[0])));
        this.register(new Subcommand("start", "athisairdrops.admin", "/airdrop start", (sender, args) -> {
            if (manager.isRunning()) {
                Messages.send(sender, "messages.system_already_running", new String[0]);
            } else {
                manager.start();
                Messages.send(sender, "messages.autostart", new String[0]);
            }
        }));
        this.register(new Subcommand("stop", "athisairdrops.admin", "/airdrop stop", (sender, args) -> {
            boolean wasRunning = manager.isRunning();
            manager.stop();
            if (wasRunning) {
                Messages.send(sender, "messages.system_stopped", new String[0]);
            } else if (!manager.getActiveAirdrops().isEmpty()) {
                Messages.send(sender, "messages.system_stopped_manual", new String[0]);
            } else {
                Messages.send(sender, "messages.system_not_running", new String[0]);
            }
        }));
        this.register(new Subcommand("spawn", "athisairdrops.admin", "/airdrop spawn <player|x y z> [lootTable]", (sender, args) -> {
            if (args.length >= 2) {
                if (args.length == 2 || args.length == 3) {
                    Player target = Bukkit.getPlayer((String)args[1]);
                    if (target == null) {
                        Messages.send(sender, "messages.player_not_found", new String[0]);
                        return;
                    }
                    String lootTableName = args.length == 3 ? args[2] : null;
                    Location loc = target.getLocation().clone();
                    loc.setY((double)loc.getWorld().getHighestBlockYAt(loc) + 1.0);
                    boolean ok = manager.spawnAt(loc, lootTableName);
                    if (ok) {
                        if (lootTableName != null) {
                            Messages.send(sender, "messages.spawned_at_player", "%player%", target.getName(), "%table%", lootTableName);
                        } else {
                            Messages.send(sender, "messages.spawned_at_player", "%player%", target.getName());
                        }
                    } else {
                        Messages.send(sender, "messages.spawn_capacity_full", new String[0]);
                    }
                    return;
                }
                if (args.length == 4 || args.length == 5) {
                    try {
                        double x = Double.parseDouble(args[1]);
                        double y = Double.parseDouble(args[2]);
                        double z = Double.parseDouble(args[3]);
                        String lootTableName = args.length == 5 ? args[4] : null;
                        World world = Bukkit.getWorld((String)plugin.getConfig().getString("world", "world"));
                        if (world == null) {
                            Messages.send(sender, "messages.invalid_world", new String[0]);
                            return;
                        }
                        Location loc = new Location(world, x, y, z);
                        loc.setY(Math.max(y, (double)world.getHighestBlockYAt(loc) + 1.0));
                        boolean ok = manager.spawnAt(loc, lootTableName);
                        if (ok) {
                            if (lootTableName != null) {
                                Messages.send(sender, "messages.spawned_at_coords", "%x%", String.valueOf(x), "%y%", String.valueOf(loc.getY()), "%z%", String.valueOf(z), "%table%", lootTableName);
                            } else {
                                Messages.send(sender, "messages.spawned_at_coords", "%x%", String.valueOf(x), "%y%", String.valueOf(loc.getY()), "%z%", String.valueOf(z));
                            }
                        } else {
                            Messages.send(sender, "messages.spawn_capacity_full", new String[0]);
                        }
                    }
                    catch (NumberFormatException e) {
                        Messages.send(sender, "messages.invalid_coordinates", new String[0]);
                    }
                    return;
                }
            }
            Messages.send(sender, "messages.usage_spawn", new String[0]);
        }));
        this.register(new Subcommand("list", "athisairdrops.admin", "/airdrop list", (sender, args) -> {
            Set<Location> visible = manager.getAllVisibleAirdrops();
            if (visible.isEmpty()) {
                Messages.send(sender, "messages.list_empty", new String[0]);
                return;
            }
            Messages.send(sender, "messages.list_header", "%count%", String.valueOf(visible.size()));
            visible.stream().sorted(Comparator.comparing(l -> l.getWorld() != null ? l.getWorld().getName() : "").thenComparing(Location::getBlockX).thenComparing(Location::getBlockZ).thenComparing(Location::getBlockY)).forEach(l -> {
                Location norm = new Location(l.getWorld(), (double)l.getBlockX(), (double)l.getBlockY(), (double)l.getBlockZ());
                Messages.send(sender, "messages.list_item", "%x%", String.valueOf(l.getBlockX()), "%y%", String.valueOf(l.getBlockY()), "%z%", String.valueOf(l.getBlockZ()), "%world%", l.getWorld() != null ? l.getWorld().getName() : "unknown", "%state%", manager.getActiveAirdrops().contains(l) ? "landed" : "falling", "%locked%", manager.isChestLocked(norm) ? "yes" : "no", "%table%", manager.getLootTableFor(norm) != null ? manager.getLootTableFor(norm) : "<none>");
            });
        }));
        this.register(new Subcommand("clear", "athisairdrops.admin", "/airdrop clear <nearest|x y z>", (sender, args) -> {
            if (args.length < 2) {
                Messages.send(sender, "messages.usage_clear", new String[0]);
                return;
            }
            if (args[1].equalsIgnoreCase("nearest")) {
                if (!(sender instanceof Player)) {
                    Messages.send(sender, "messages.clear_player_only_nearest", new String[0]);
                    return;
                }
                Player p = (Player)sender;
                Optional<Location> nearest = this.findNearest(manager.getAllVisibleAirdrops(), p.getLocation());
                if (nearest.isEmpty()) {
                    Messages.send(sender, "messages.no_active_airdrop", new String[0]);
                    return;
                }
                Location loc = nearest.get();
                manager.cleanupAirdropAt(loc, true);
                Messages.send(sender, "messages.cleared_nearest", "%x%", String.valueOf(loc.getBlockX()), "%y%", String.valueOf(loc.getBlockY()), "%z%", String.valueOf(loc.getBlockZ()));
                return;
            }
            if (args.length >= 4) {
                try {
                    World world;
                    int x = (int)Math.floor(Double.parseDouble(args[1]));
                    int y = (int)Math.floor(Double.parseDouble(args[2]));
                    int z = (int)Math.floor(Double.parseDouble(args[3]));
                    if (sender instanceof Player) {
                        Player p = (Player)sender;
                        world = p.getWorld();
                    } else {
                        world = Bukkit.getWorld((String)plugin.getConfig().getString("world", "world"));
                    }
                    if (world == null) {
                        Messages.send(sender, "messages.invalid_world", new String[0]);
                        return;
                    }
                    Location target = new Location(world, (double)x, (double)y, (double)z);
                    boolean exists = manager.getAllVisibleAirdrops().stream().anyMatch(l -> l.getWorld() != null && l.getWorld().equals((Object)world) && l.getBlockX() == x && l.getBlockY() == y && l.getBlockZ() == z);
                    if (!exists) {
                        Messages.send(sender, "messages.clear_not_found", new String[0]);
                        return;
                    }
                    manager.cleanupAirdropAt(target, true);
                    Messages.send(sender, "messages.cleared_at_coords", "%x%", String.valueOf(x), "%y%", String.valueOf(y), "%z%", String.valueOf(z));
                }
                catch (NumberFormatException ex) {
                    Messages.send(sender, "messages.invalid_coordinates", new String[0]);
                }
                return;
            }
            Messages.send(sender, "messages.usage_clear", new String[0]);
        }));
        this.register(new Subcommand("reload", "athisairdrops.admin", "/airdrop reload", (sender, args) -> {
            plugin.reloadConfig();
            manager.reload();
            Messages.send(sender, "messages.reload_success", new String[0]);
        }));
        this.register(new Subcommand("status", "athisairdrops.admin", "/airdrop status", (sender, args) -> Messages.send(sender, "messages.status", "%status%", String.valueOf(manager.isRunning()))));
    }

    private void register(Subcommand sub) {
        SUBCOMMANDS.put(sub.name().toLowerCase(), sub);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            this.showUsage(sender);
            return true;
        }
        Subcommand sub = SUBCOMMANDS.get(args[0].toLowerCase());
        if (sub == null) {
            Messages.send(sender, "messages.unknown_command", new String[0]);
            return true;
        }
        if (!sender.hasPermission(sub.permission())) {
            Messages.send(sender, "messages.no_permission", new String[0]);
            return true;
        }
        sub.handler().execute(sender, args);
        return true;
    }

    private void showUsage(CommandSender sender) {
        Messages.send(sender, "messages.available_commands_header", new String[0]);
        for (Subcommand sub : SUBCOMMANDS.values()) {
            if (!sender.hasPermission(sub.permission())) continue;
            Messages.send(sender, "messages.command_usage_format", "%usage%", sub.usage());
        }
    }

    private Optional<Location> findNearest(Set<Location> locations, Location ref) {
        if (locations == null || locations.isEmpty() || ref == null) {
            return Optional.empty();
        }
        return locations.stream().filter(l -> l.getWorld() != null && l.getWorld().equals((Object)ref.getWorld())).min(Comparator.comparingDouble(l -> l.distanceSquared(ref)));
    }

    public record Subcommand(String name, String permission, String usage, CommandHandler handler) {
    }

    @FunctionalInterface
    public static interface CommandHandler {
        public void execute(CommandSender var1, String[] var2);
    }
}

