/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.athlantes.athiSAirdrops.CommandLootProvider;
import org.athlantes.athiSAirdrops.ItemsAdderLootProvider;
import org.athlantes.athiSAirdrops.MMOItemsLootProvider;
import org.athlantes.athiSAirdrops.NexoLootProvider;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Chest;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AirdropLoot {
    private final AthiSAirdrops plugin;
    private final LootTableSelector lootTableSelector;
    private final List<LootProvider> lootProviders;
    private static final Logger LOGGER = Logger.getLogger(AirdropLoot.class.getName());

    public AirdropLoot(AthiSAirdrops plugin) {
        this.plugin = plugin;
        this.migrateLootYmlToFolderIfNeeded();
        this.lootTableSelector = new LootTableSelector(plugin);
        this.lootProviders = new ArrayList<LootProvider>();
        if (plugin.isItemsAdderEnabled()) {
            this.lootProviders.add(new ItemsAdderLootProvider(plugin));
        }
        if (plugin.isMMOItemsEnabled()) {
            this.lootProviders.add(new MMOItemsLootProvider(plugin));
        }
        if (plugin.isNexoEnabled()) {
            this.lootProviders.add(new NexoLootProvider(plugin));
        }
        this.lootProviders.add(new VanillaLootProvider(plugin));
        this.lootProviders.add(new CommandLootProvider(plugin));
    }

    private void migrateLootYmlToFolderIfNeeded() {
        File lootYml = new File(this.plugin.getDataFolder(), "loot.yml");
        File lootDir = new File(this.plugin.getDataFolder(), "loot");
        if (lootYml.exists() && (!lootDir.exists() || Objects.requireNonNull(lootDir.listFiles()).length == 0)) {
            try {
                YamlConfiguration lootConfig = YamlConfiguration.loadConfiguration((File)lootYml);
                lootDir.mkdirs();
                for (String tableName : lootConfig.getKeys(false)) {
                    ConfigurationSection tableSection = lootConfig.getConfigurationSection(tableName);
                    if (tableSection == null) continue;
                    File outFile = new File(lootDir, tableName + ".yml");
                    YamlConfiguration outConfig = new YamlConfiguration();
                    for (String key : tableSection.getKeys(false)) {
                        outConfig.set(key, tableSection.get(key));
                    }
                    outConfig.save(outFile);
                }
                this.plugin.getLogger().info("[AthiSAirdrops] Migrated loot tables from loot.yml to loot/ folder.");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("[AthiSAirdrops] Failed to migrate loot.yml to loot folder: " + e.getMessage());
            }
        }
    }

    public static int randomBetween(int min, int max) {
        Random random = new Random();
        return max <= min ? min : min + random.nextInt(max - min + 1);
    }

    public String fillChestWithLoot(Chest chest, String tableName) {
        if (chest == null) {
            return null;
        }
        String chosenId = this.lootTableSelector.selectLootTableId(tableName);
        if (chosenId == null) {
            LOGGER.info("No loot table selected; chest will remain empty.");
            return null;
        }
        ConfigurationSection lootTable = this.lootTableSelector.getById(chosenId);
        if (lootTable == null) {
            LOGGER.warning("Chosen loot table id '" + chosenId + "' configuration not found; chest will remain empty.");
            return null;
        }
        int maxItems = this.plugin.getConfig().getInt("max_items_per_airdrop", 5);
        int remaining = Math.max(0, maxItems);
        boolean anySectionFound = false;
        int totalAdded = 0;
        for (LootProvider provider : this.lootProviders) {
            if (remaining <= 0) break;
            try {
                ConfigurationSection section = provider.getSection(lootTable);
                if (section == null) continue;
                anySectionFound = true;
                int added = provider.fillChest(chest, section, remaining);
                if (added > 0) {
                    remaining -= added;
                    totalAdded += added;
                    continue;
                }
                LOGGER.info("[AirdropLoot] " + provider.getClass().getSimpleName() + " did not add any items (section empty, chance rolls, or errors).");
            }
            catch (Exception e) {
                LOGGER.warning("Error while filling chest with provider " + provider.getClass().getSimpleName() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (!anySectionFound) {
            LOGGER.warning("[AirdropLoot] No loot provider found a valid section in the selected loot table. Check your loot.yml structure.");
        }
        if (totalAdded == 0) {
            LOGGER.info("[AirdropLoot] No items were added to the airdrop chest (all providers skipped or failed).");
        }
        return chosenId;
    }

    public String fillChestWithLoot(Chest chest) {
        return this.fillChestWithLoot(chest, null);
    }

    public static class LootTableSelector {
        private final AthiSAirdrops plugin;
        private final Map<String, ConfigurationSection> lootTables = new LinkedHashMap<String, ConfigurationSection>();

        public LootTableSelector(AthiSAirdrops plugin) {
            this.plugin = plugin;
            this.loadLootTables();
        }

        public void reload() {
            this.lootTables.clear();
            this.loadLootTables();
        }

        private void loadLootTables() {
            File[] files;
            File lootDir = new File(this.plugin.getDataFolder(), "loot");
            if (!lootDir.exists()) {
                lootDir.mkdirs();
            }
            if ((files = lootDir.listFiles((dir, name) -> name.endsWith(".yml"))) == null) {
                return;
            }
            boolean mmoItemsEnabled = Bukkit.getPluginManager().isPluginEnabled("MMOItems");
            boolean itemsAdderEnabled = Bukkit.getPluginManager().isPluginEnabled("ItemsAdder");
            for (File file : files) {
                String tableId = file.getName().replaceFirst("\\.yml$", "");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                this.lootTables.put(tableId, (ConfigurationSection)config);
                if (config.isConfigurationSection("mmoitems_loot") && !mmoItemsEnabled) {
                    this.plugin.getLogger().warning("[AthiSAirdrops] Loot table '" + tableId + "' contains MMOItems loot, but MMOItems is not enabled. These items will be skipped.");
                }
                if (!config.isConfigurationSection("itemsadder_loot") || itemsAdderEnabled) continue;
                this.plugin.getLogger().warning("[AthiSAirdrops] Loot table '" + tableId + "' contains ItemsAdder loot, but ItemsAdder is not enabled. These items will be skipped.");
            }
        }

        public String selectLootTableId(String requestedName) {
            if (requestedName != null && !requestedName.isEmpty()) {
                for (String key : this.lootTables.keySet()) {
                    if (!key.equalsIgnoreCase(requestedName)) continue;
                    return key;
                }
            }
            LinkedHashMap<String, Double> tableChances = new LinkedHashMap<String, Double>();
            double totalChance = 0.0;
            for (Map.Entry<String, ConfigurationSection> entry : this.lootTables.entrySet()) {
                double chance = entry.getValue().getDouble("chance", 1.0);
                if (!(chance > 0.0)) continue;
                tableChances.put(entry.getKey(), chance);
                totalChance += chance;
            }
            if (tableChances.isEmpty()) {
                return null;
            }
            double roll = Math.random() * totalChance;
            for (Map.Entry entry : tableChances.entrySet()) {
                if (!((roll -= ((Double)entry.getValue()).doubleValue()) <= 0.0)) continue;
                return (String)entry.getKey();
            }
            return null;
        }

        public ConfigurationSection getById(String id) {
            if (id == null) {
                return null;
            }
            return this.lootTables.get(id);
        }

        public ConfigurationSection getByName(String name) {
            if (name == null) {
                return null;
            }
            ConfigurationSection exact = this.lootTables.get(name);
            if (exact != null) {
                return exact;
            }
            for (Map.Entry<String, ConfigurationSection> e : this.lootTables.entrySet()) {
                if (!e.getKey().equalsIgnoreCase(name)) continue;
                return e.getValue();
            }
            return null;
        }
    }

    public static class VanillaLootProvider
    implements LootProvider {
        private static final Random RANDOM = new Random();
        private final AthiSAirdrops plugin;

        public VanillaLootProvider(AthiSAirdrops plugin) {
            this.plugin = plugin;
        }

        @Override
        public ConfigurationSection getSection(ConfigurationSection lootTable) {
            return lootTable.getConfigurationSection("loot");
        }

        @Override
        public int fillChest(Chest chest, ConfigurationSection section, int maxItems) {
            if (section == null) {
                LOGGER.warning("Section is null, skipping fillChest.");
                return 0;
            }
            Set keys = section.getKeys(false);
            if (keys == null) {
                LOGGER.warning("Section keys are null, skipping.");
                return 0;
            }
            ArrayList<ItemStack> pool = new ArrayList<ItemStack>();
            for (String key : keys) {
                Material mat;
                double chance = section.getDouble(key + ".chance", 1.0);
                if (RANDOM.nextDouble() > chance || (mat = Material.matchMaterial((String)section.getString(key + ".material", "STONE"))) == null) continue;
                int min = Math.max(1, section.getInt(key + ".min", 1));
                int max = Math.max(min, section.getInt(key + ".max", min));
                ItemStack base = new ItemStack(mat, AirdropLoot.randomBetween(min, max));
                if (section.isConfigurationSection(key + ".enchantments")) {
                    ItemMeta meta = base.getItemMeta();
                    ConfigurationSection enchSection = section.getConfigurationSection(key + ".enchantments");
                    if (enchSection != null) {
                        for (String enchKey : enchSection.getKeys(false)) {
                            NamespacedKey nsKey = NamespacedKey.minecraft((String)enchKey.toLowerCase(Locale.ROOT));
                            Enchantment ench = Enchantment.getByKey((NamespacedKey)nsKey);
                            if (ench != null) {
                                int level = Math.max(1, enchSection.getInt(enchKey, 1));
                                meta.addEnchant(ench, level, true);
                                continue;
                            }
                            LOGGER.warning("Unknown enchantment: " + enchKey);
                        }
                    }
                    base.setItemMeta(meta);
                }
                pool.add(base.clone());
            }
            Collections.shuffle(pool, RANDOM);
            int size = chest.getInventory().getSize();
            HashSet<Integer> usedSlots = new HashSet<Integer>();
            int added = 0;
            block2: for (ItemStack item : pool) {
                if (added >= maxItems) break;
                for (int tries = 0; tries < 40; ++tries) {
                    int slot = RANDOM.nextInt(size);
                    if (usedSlots.contains(slot)) continue;
                    chest.getInventory().setItem(slot, item);
                    usedSlots.add(slot);
                    ++added;
                    continue block2;
                }
            }
            return added;
        }
    }

    public static interface LootProvider {
        public ConfigurationSection getSection(ConfigurationSection var1);

        public int fillChest(Chest var1, ConfigurationSection var2, int var3);
    }
}

