/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.athlantes.athiSAirdrops.AirdropAnimation;
import org.athlantes.athiSAirdrops.AirdropLocationPicker;
import org.athlantes.athiSAirdrops.AirdropLockManager;
import org.athlantes.athiSAirdrops.AirdropLoot;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.athlantes.athiSAirdrops.BlockLocationKey;
import org.athlantes.athiSAirdrops.HologramManager;
import org.athlantes.athiSAirdrops.Messages;
import org.athlantes.athiSAirdrops.ParticleManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AirdropManager {
    private final AthiSAirdrops plugin;
    private final Set<Location> activeAirdrops = ConcurrentHashMap.newKeySet();
    private final Set<Location> protectedChests = ConcurrentHashMap.newKeySet();
    private final Set<Location> pendingAirdrops = ConcurrentHashMap.newKeySet();
    private final AirdropLockManager lockManager;
    private final ParticleManager particleManager;
    private final HologramManager hologramManager;
    private final AirdropAnimation animation;
    private final Map<BlockLocationKey, BukkitTask> despawnTasks = new ConcurrentHashMap<BlockLocationKey, BukkitTask>();
    private final Map<BlockLocationKey, String> pendingRequestedLoot = new ConcurrentHashMap<BlockLocationKey, String>();
    private final Map<BlockLocationKey, String> lootTableByLocation = new ConcurrentHashMap<BlockLocationKey, String>();
    private BukkitTask spawnTask;
    private boolean running = false;
    private boolean shutdown = false;

    public AirdropManager(AthiSAirdrops plugin) {
        this.plugin = plugin;
        this.lockManager = new AirdropLockManager();
        this.particleManager = new ParticleManager(plugin);
        this.hologramManager = new HologramManager((Plugin)plugin);
        this.animation = new AirdropAnimation(plugin);
        try {
            this.particleManager.setInterval(Math.max(1, plugin.getConfig().getInt("particle_interval_ticks", 10)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void cleanupLeftovers() {
        try {
            this.plugin.getLogger().info("AirdropManager: cleaning up leftover armor stands/holograms...");
            for (World world : Bukkit.getWorlds()) {
                world.getEntitiesByClass(ArmorStand.class).stream().filter(as -> as != null && !as.isDead()).filter(as -> as.isMarker() && as.isInvisible()).filter(as -> {
                    try {
                        EntityEquipment eq = as.getEquipment();
                        if (eq == null) {
                            return false;
                        }
                        ItemStack helm = eq.getHelmet();
                        if (helm != null && helm.getType() == Material.CHEST) {
                            return true;
                        }
                        String name = as.getCustomName();
                        return name != null && (name.contains("Unlock") || name.contains("Despawn") || name.contains("Items Left"));
                    }
                    catch (Throwable t) {
                        return false;
                    }
                }).forEach(as -> {
                    try {
                        as.remove();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
            }
            try {
                this.hologramManager.removeAll();
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable t) {
            this.plugin.getLogger().warning("AirdropManager: cleanupLeftovers failed: " + t.getMessage());
        }
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        int interval = Math.max(1, this.plugin.getConfig().getInt("spawn_interval_seconds", 240) * 20);
        if (this.shouldSpawnAirdrop()) {
            this.spawnAirdrop();
        }
        this.spawnTask = new BukkitRunnable(){

            public void run() {
                if (AirdropManager.this.shouldSpawnAirdrop()) {
                    AirdropManager.this.spawnAirdrop();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, (long)interval, (long)interval);
    }

    public void stop() {
        this.running = false;
        this.shutdown = true;
        if (this.spawnTask != null) {
            try {
                this.spawnTask.cancel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.spawnTask = null;
        }
        try {
            for (BukkitTask t : new ArrayList<BukkitTask>(this.despawnTasks.values())) {
                if (t == null) continue;
                try {
                    t.cancel();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.despawnTasks.clear();
        try {
            this.animation.stopAll();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.hologramManager.removeAll();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.particleManager.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Location loc : new HashSet<Location>(this.activeAirdrops)) {
            try {
                this.cleanupAirdropAt(loc, false);
            }
            catch (Throwable throwable) {}
        }
        for (Location loc : new HashSet<Location>(this.pendingAirdrops)) {
            try {
                this.cleanupAirdropAt(loc, false);
            }
            catch (Throwable throwable) {}
        }
        this.activeAirdrops.clear();
        this.pendingAirdrops.clear();
        this.protectedChests.clear();
        try {
            this.lockManager.clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.shutdown = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public Set<Location> getActiveAirdrops() {
        return new HashSet<Location>(this.activeAirdrops);
    }

    public Set<Location> getAllVisibleAirdrops() {
        HashSet<Location> all = new HashSet<Location>(this.activeAirdrops);
        all.addAll(this.pendingAirdrops);
        return all;
    }

    public boolean isProtectedChest(Chest chest) {
        return this.protectedChests.contains(chest.getLocation());
    }

    public boolean isChestLocked(Location location) {
        return this.lockManager.isLocked(location);
    }

    private int getMaxConcurrent() {
        return Math.max(1, this.plugin.getConfig().getInt("max_concurrent_airdrops", 3));
    }

    private boolean hasCapacity() {
        int total = this.activeAirdrops.size() + this.pendingAirdrops.size();
        return total < this.getMaxConcurrent();
    }

    private boolean shouldSpawnAirdrop() {
        int minPlayers = this.plugin.getConfig().getInt("min_players_to_spawn", 3);
        if (Bukkit.getOnlinePlayers().size() < minPlayers) {
            return false;
        }
        return this.hasCapacity();
    }

    private void spawnAirdrop() {
        World world = Bukkit.getWorld((String)this.plugin.getConfig().getString("world", "world"));
        if (world == null) {
            this.plugin.getLogger().warning("Airdrop: configured world not found");
            return;
        }
        AirdropLocationPicker picker = new AirdropLocationPicker(this.plugin);
        Location location = picker.pickRandomValidLocation(world);
        if (location == null) {
            this.plugin.getLogger().info("Airdrop: no valid spawn location found");
            return;
        }
        boolean started = this.spawnAt(location);
        if (!started) {
            this.plugin.getLogger().info("Airdrop: capacity full (max=" + this.getMaxConcurrent() + "), skipping spawn attempt.");
        }
    }

    public String getLootTableFor(Location location) {
        if (location == null || location.getWorld() == null) {
            return null;
        }
        BlockLocationKey key = BlockLocationKey.from(location);
        String active = this.lootTableByLocation.get(key);
        if (active != null) {
            return active;
        }
        return this.pendingRequestedLoot.get(key);
    }

    public void spawnAirdropAt(Location location) {
        this.spawnAirdropAt(location, null);
    }

    public void spawnAirdropAt(Location location, String lootTableName) {
        if (location == null) {
            return;
        }
        Location blockTarget = new Location(location.getWorld(), (double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ());
        BlockLocationKey key = BlockLocationKey.from(blockTarget);
        if (lootTableName != null && !lootTableName.isEmpty()) {
            this.pendingRequestedLoot.put(key, lootTableName);
            this.plugin.getLogger().info("[Airdrop] Pending loot table requested '" + lootTableName + "' at " + String.valueOf(key));
        }
        this.pendingAirdrops.add(blockTarget);
        this.notifyPlayersOfAirdrop(blockTarget);
        this.animation.start(blockTarget, target -> {
            try {
                Block block = target.getBlock();
                if (!this.plugin.getConfig().getBoolean("replace_existing_block", true) && block.getType() != Material.AIR) {
                    this.plugin.getLogger().warning("[Airdrop] Target block occupied, aborting spawn at " + String.valueOf(target));
                    try {
                        this.pendingAirdrops.remove(target);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        this.pendingRequestedLoot.remove(key);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return;
                }
                block.setType(Material.CHEST);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    AirdropLoot loot;
                    String chosenId;
                    Block b = target.getBlock();
                    BlockState patt0$temp22 = b.getState();
                    if (!(patt0$temp22 instanceof Chest)) {
                        try {
                            this.pendingAirdrops.remove(target);
                        }
                        catch (Throwable patt0$temp22) {
                            // empty catch block
                        }
                        try {
                            this.pendingRequestedLoot.remove(key);
                        }
                        catch (Throwable patt0$temp22) {
                            // empty catch block
                        }
                        return;
                    }
                    Chest chestState = (Chest)patt0$temp22;
                    try {
                        this.pendingAirdrops.remove(target);
                    }
                    catch (Throwable patt0$temp22) {
                        // empty catch block
                    }
                    Location chestLoc = chestState.getLocation();
                    BlockLocationKey chestKey = BlockLocationKey.from(chestLoc);
                    boolean added = this.activeAirdrops.add(chestLoc);
                    this.protectedChests.add(chestLoc);
                    if (this.plugin.getConfig().getBoolean("lock-airdrop", true)) {
                        int lockTime = this.plugin.getConfig().getInt("time-before-unlock", 30);
                        long unlockAtMillis = System.currentTimeMillis() + (long)lockTime * 1000L;
                        try {
                            this.lockManager.addLock(chestLoc, unlockAtMillis);
                            this.plugin.getLogger().info("[Airdrop] Applied lock until " + unlockAtMillis + " (ms) for landed airdrop at " + String.valueOf(chestKey));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if ((chosenId = (loot = new AirdropLoot(this.plugin)).fillChestWithLoot(chestState, lootTableName)) != null) {
                        this.lootTableByLocation.put(chestKey, chosenId);
                        this.plugin.getLogger().info("[Airdrop] Loot table chosen '" + chosenId + "' for airdrop at " + String.valueOf(chestKey));
                    } else {
                        String pendingReq = this.pendingRequestedLoot.get(key);
                        if (pendingReq != null && !pendingReq.isEmpty()) {
                            this.lootTableByLocation.put(chestKey, pendingReq);
                        }
                    }
                    this.pendingRequestedLoot.remove(key);
                    this.startVisualEffects(chestLoc);
                    this.scheduleDespawn(chestLoc);
                });
            }
            catch (Throwable t) {
                this.plugin.getLogger().warning("AirdropManager: error finalizing airdrop after animation: " + t.getMessage());
                try {
                    this.pendingAirdrops.remove(blockTarget);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.pendingRequestedLoot.remove(key);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    private void startVisualEffects(Location location) {
        if (location == null) {
            return;
        }
        Block block = location.getBlock();
        this.particleManager.addChest(block);
        BlockState blockState = block.getState();
        if (blockState instanceof Chest) {
            Chest chest = (Chest)blockState;
            int unlockTime = this.plugin.getConfig().getInt("time-before-unlock", 30);
            int despawnTime = this.plugin.getConfig().getInt("time-before-despawn", 120);
            Runnable onEmpty = () -> this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.cleanupAirdropAt(location, true));
            Runnable onDespawn = () -> this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.cleanupAirdropAt(location, true));
            this.hologramManager.spawnHologram(location, chest, unlockTime, despawnTime, onEmpty, onDespawn);
        }
    }

    private void scheduleDespawn(final Location location) {
        if (location == null) {
            return;
        }
        int despawnTimeTicks = this.plugin.getConfig().getInt("time-before-despawn", 120) * 20;
        BlockLocationKey key = BlockLocationKey.from(location);
        BukkitTask prev = this.despawnTasks.remove(key);
        if (prev != null) {
            prev.cancel();
        }
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                if (AirdropManager.this.activeAirdrops.contains(location)) {
                    AirdropManager.this.cleanupAirdropAt(location, true);
                }
            }
        }.runTaskLater((Plugin)this.plugin, (long)despawnTimeTicks);
        this.despawnTasks.put(key, task);
    }

    private void notifyPlayersOfAirdrop(Location location) {
        if (location == null) {
            return;
        }
        boolean compassEnabled = this.plugin.getConfig().getBoolean("enable-compass", true);
        String biome = location.getBlock().getBiome().name().toLowerCase().replace("_", " ");
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getWorld().equals((Object)location.getWorld())) continue;
            if (compassEnabled) {
                try {
                    player.setCompassTarget(location);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                double distance = Math.floor(player.getLocation().distance(location));
                String distanceStr = String.valueOf((int)distance);
                Messages.send((CommandSender)player, "messages.airdrop_spawned", "%biome%", biome, "%distance%", distanceStr);
                continue;
            }
            Messages.send((CommandSender)player, "messages.compass_coords", "%x%", String.valueOf(location.getBlockX()), "%y%", String.valueOf(location.getBlockY()), "%z%", String.valueOf(location.getBlockZ()));
        }
    }

    private String calculateDirection(Player player, Location target) {
        double playerYaw;
        double relAngle;
        double dz;
        double dx = target.getX() - player.getLocation().getX();
        double angle = Math.toDegrees(Math.atan2(-dx, dz = target.getZ() - player.getLocation().getZ()));
        if (angle < 0.0) {
            angle += 360.0;
        }
        if ((relAngle = (angle - (playerYaw = (double)((player.getLocation().getYaw() + 360.0f) % 360.0f)) + 360.0) % 360.0) >= 337.5 || relAngle < 22.5) {
            return "ahead";
        }
        if (relAngle < 67.5) {
            return "ahead-right";
        }
        if (relAngle < 112.5) {
            return "right";
        }
        if (relAngle < 157.5) {
            return "behind-right";
        }
        if (relAngle < 202.5) {
            return "behind";
        }
        if (relAngle < 247.5) {
            return "behind-left";
        }
        if (relAngle < 292.5) {
            return "left";
        }
        return "ahead-left";
    }

    public void cleanupAirdropAt(Location location) {
        this.cleanupAirdropAt(location, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cleanupAirdropAt(Location location, boolean broadcast) {
        BlockLocationKey key;
        block17: {
            if (location == null) {
                return;
            }
            if (broadcast) {
                this.plugin.getLogger().info("[Airdrop] Airdrop at " + location.getBlockX() + ", " + location.getBlockZ() + " has despawned.");
            }
            try {
                this.animation.stop(location);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            key = BlockLocationKey.from(location);
            BukkitTask scheduled = this.despawnTasks.remove(key);
            if (scheduled != null) {
                scheduled.cancel();
            }
            try {
                BlockState blockState;
                Block preBlock = location.getBlock();
                if (preBlock.getType() == Material.CHEST && (blockState = preBlock.getState()) instanceof Chest) {
                    Chest preChest = (Chest)blockState;
                    if (!preChest.getInventory().getViewers().isEmpty()) {
                        if (!this.shutdown) {
                            new ArrayList<HumanEntity>(preChest.getInventory().getViewers()).forEach(v -> {
                                try {
                                    v.closeInventory();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            });
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.cleanupAirdropAt(location, broadcast));
                            return;
                        }
                        new ArrayList<HumanEntity>(preChest.getInventory().getViewers()).forEach(v -> {
                            try {
                                v.closeInventory();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        });
                        preBlock.setType(Material.AIR);
                        break block17;
                    } else {
                        preBlock.setType(Material.AIR);
                    }
                    break block17;
                }
                preBlock.setType(Material.AIR);
            }
            catch (Throwable t) {
                this.plugin.getLogger().warning("AirdropManager: viewer pre-close check failed: " + t.getMessage());
            }
        }
        boolean removedPending = this.pendingAirdrops.remove(location);
        boolean removedActive = this.activeAirdrops.remove(location);
        if (!removedPending && !removedActive) {
            this.plugin.getLogger().info("AirdropManager: cleanup ignored - airdrop was not active/pending for " + String.valueOf(location));
            return;
        }
        this.protectedChests.remove(location);
        this.lockManager.removeLock(location);
        try {
            this.pendingRequestedLoot.remove(key);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.lootTableByLocation.remove(key);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.particleManager.removeChest(location.getBlock());
        this.hologramManager.removeHologram(location);
        if (broadcast) {
            Messages.broadcast("messages.airdrop_despawned", "%x%", String.valueOf(location.getBlockX()), "%z%", String.valueOf(location.getBlockZ()));
        }
    }

    public boolean spawnAt(Location location) {
        return this.spawnAt(location, null);
    }

    public boolean spawnAt(Location location, String lootTableName) {
        if (location == null) {
            return false;
        }
        if (!this.hasCapacity()) {
            return false;
        }
        this.spawnAirdropAt(location, lootTableName);
        return true;
    }

    public void reload() {
        this.stop();
        this.activeAirdrops.clear();
        this.pendingAirdrops.clear();
        this.protectedChests.clear();
        this.lockManager.clear();
        this.particleManager.stop();
        this.hologramManager.removeAll();
    }
}

