/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.athlantes.athiSAirdrops.AirdropCommand;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class AirdropTabCompleter
implements TabCompleter {
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            return this.filter(sender, args[0]);
        }
        if (args.length >= 2 && args[0].equalsIgnoreCase("spawn")) {
            if (args.length == 2) {
                try {
                    Double.parseDouble(args[1]);
                    return List.of("<y>");
                }
                catch (NumberFormatException numberFormatException) {
                    return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).toList();
                }
            }
            if (args.length == 3) {
                try {
                    Double.parseDouble(args[1]);
                    return List.of("<y>");
                }
                catch (NumberFormatException ignored) {
                    return this.listLootTables().stream().filter(t -> t.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
                }
            }
            if (args.length == 4) {
                try {
                    Double.parseDouble(args[1]);
                    return List.of("<z>");
                }
                catch (NumberFormatException ignored) {
                    return List.of();
                }
            }
            if (args.length == 5) {
                return this.listLootTables().stream().filter(t -> t.toLowerCase().startsWith(args[4].toLowerCase())).collect(Collectors.toList());
            }
            return List.of("<x>", "<y>", "<z>");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("clear")) {
            ArrayList<String> opts = new ArrayList<String>();
            if ("nearest".startsWith(args[1].toLowerCase())) {
                opts.add("nearest");
            }
            opts.add("<x>");
            return opts;
        }
        if (args.length >= 3 && args[0].equalsIgnoreCase("clear")) {
            return List.of("<" + (args.length == 3 ? "y" : "z") + ">");
        }
        return Collections.emptyList();
    }

    private List<String> filter(CommandSender sender, String partial) {
        ArrayList<String> subs = new ArrayList<String>();
        for (AirdropCommand.Subcommand sub : AirdropCommand.SUBCOMMANDS.values()) {
            if (!sender.hasPermission(sub.permission()) || !sub.name().toLowerCase().startsWith(partial.toLowerCase())) continue;
            subs.add(sub.name());
        }
        return subs;
    }

    private List<String> listLootTables() {
        File lootDir = new File(AthiSAirdrops.getInstance().getDataFolder(), "loot");
        if (!lootDir.exists()) {
            return List.of();
        }
        File[] files = lootDir.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null || files.length == 0) {
            return List.of();
        }
        return Arrays.stream(files).map(File::getName).map(n -> n.replaceFirst("\\.yml$", "")).collect(Collectors.toList());
    }
}

