/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.athlantes.athiSAirdrops.AirdropCommand;
import org.athlantes.athiSAirdrops.AirdropListeners;
import org.athlantes.athiSAirdrops.AirdropManager;
import org.athlantes.athiSAirdrops.AirdropTabCompleter;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class AthiSAirdrops
extends JavaPlugin {
    private static AthiSAirdrops instance;
    private AirdropManager manager;
    private boolean nexoEnabled = false;
    private boolean itemsAdderEnabled = false;
    private boolean mmoItemsEnabled = false;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.ensureLootFolderAndMigrate();
        this.itemsAdderEnabled = this.getServer().getPluginManager().isPluginEnabled("ItemsAdder");
        if (this.itemsAdderEnabled) {
            this.getLogger().info("ItemsAdder detected! Enabling ItemsAdder support.");
        }
        this.nexoEnabled = this.getServer().getPluginManager().isPluginEnabled("Nexo");
        if (this.nexoEnabled) {
            this.getLogger().info("Nexo detected! Enabling Nexo integration.");
        }
        this.mmoItemsEnabled = this.getServer().getPluginManager().isPluginEnabled("MMOItems");
        if (this.mmoItemsEnabled) {
            this.getLogger().info("MMOItems detected! Enabling MMOItems integration.");
        }
        this.manager = new AirdropManager(this);
        this.manager.cleanupLeftovers();
        this.getServer().getPluginManager().registerEvents((Listener)new AirdropListeners(this, this.manager), (Plugin)this);
        this.getCommand("airdrop").setExecutor((CommandExecutor)new AirdropCommand(this, this.manager));
        this.getCommand("airdrop").setTabCompleter((TabCompleter)new AirdropTabCompleter());
        if (this.getConfig().getBoolean("autostart", false)) {
            this.manager.start();
        }
        this.getLogger().info("AthiSAirdrops has been enabled!");
    }

    private void ensureLootFolderAndMigrate() {
        File lootDir;
        File data = this.getDataFolder();
        if (!data.exists()) {
            data.mkdirs();
        }
        if (!(lootDir = new File(data, "loot")).exists()) {
            lootDir.mkdirs();
        }
        File lootYml = new File(data, "loot.yml");
        boolean lootDirEmpty = lootDir.listFiles() == null || lootDir.listFiles().length == 0;
        try {
            if (lootYml.exists() && lootDirEmpty) {
                YamlConfiguration lootConfig = YamlConfiguration.loadConfiguration((File)lootYml);
                this.migrateConfigToFolder((FileConfiguration)lootConfig, lootDir);
                if (!lootYml.delete()) {
                    this.getLogger().warning("Could not delete legacy loot.yml after migration. You may remove it manually.");
                } else {
                    this.getLogger().info("Migrated legacy loot.yml to loot/ and removed the old file.");
                }
                return;
            }
            if (lootDirEmpty) {
                InputStream in = this.getResource("loot.yml");
                if (in != null) {
                    YamlConfiguration embedded = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
                    this.migrateConfigToFolder((FileConfiguration)embedded, lootDir);
                    this.getLogger().info("Initialized loot/ from embedded default loot.yml.");
                } else {
                    this.getLogger().info("loot/ folder created. No default loot.yml found in resources; folder left empty.");
                }
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to set up loot folder: " + e.getMessage());
        }
    }

    private void migrateConfigToFolder(FileConfiguration source, File lootDir) {
        for (String tableName : source.getKeys(false)) {
            ConfigurationSection table = source.getConfigurationSection(tableName);
            if (table == null) continue;
            try {
                File out = new File(lootDir, tableName + ".yml");
                YamlConfiguration cfg = new YamlConfiguration();
                for (String k : table.getKeys(false)) {
                    cfg.set(k, table.get(k));
                }
                cfg.save(out);
            }
            catch (Exception ex) {
                this.getLogger().warning("Failed to write loot table '" + tableName + "': " + ex.getMessage());
            }
        }
    }

    public void onDisable() {
        if (this.manager != null) {
            this.manager.stop();
        }
        this.getLogger().info("AthiSAirdrops has been disabled!");
    }

    public static AthiSAirdrops getInstance() {
        return instance;
    }

    public AirdropManager getManager() {
        return this.manager;
    }

    public boolean isItemsAdderEnabled() {
        return this.itemsAdderEnabled;
    }

    public boolean isNexoEnabled() {
        return this.nexoEnabled;
    }

    public boolean isMMOItemsEnabled() {
        return this.mmoItemsEnabled;
    }
}

