/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class FakeVanillaCommandHandler {
    public static boolean handle(Player player, String commandLine) {
        String[] args = commandLine.trim().split("\\s+");
        if (args.length == 0) {
            return false;
        }
        String cmd = args[0].toLowerCase(Locale.ROOT);
        try {
            switch (cmd) {
                case "give": {
                    if (args.length < 4) break;
                    String targetName = args[1];
                    Player target = Bukkit.getPlayerExact((String)targetName);
                    if (target == null) {
                        return false;
                    }
                    String itemName = args[2];
                    int amount = Integer.parseInt(args[3]);
                    Material mat = Material.matchMaterial((String)itemName.replace("minecraft:", ""));
                    if (mat == null) {
                        return false;
                    }
                    target.getInventory().addItem(new ItemStack[]{new ItemStack(mat, amount)});
                    return true;
                }
                case "gamemode": {
                    String targetName;
                    String modeArg;
                    if (args.length != 3) break;
                    if (args[1].matches("[a-zA-Z]+")) {
                        modeArg = args[1];
                        targetName = args[2];
                    } else {
                        targetName = args[1];
                        modeArg = args[2];
                    }
                    Player target = Bukkit.getPlayerExact((String)targetName);
                    if (target == null) {
                        return false;
                    }
                    GameMode mode = FakeVanillaCommandHandler.parseGameMode(modeArg);
                    if (mode == null) {
                        return false;
                    }
                    target.setGameMode(mode);
                    return true;
                }
                case "effect": {
                    if (args.length < 5) break;
                    Player target = Bukkit.getPlayerExact((String)args[1]);
                    if (target == null) {
                        return false;
                    }
                    String effectName = args[2].toUpperCase(Locale.ROOT);
                    PotionEffectType type = PotionEffectType.getByName((String)effectName);
                    if (type == null) {
                        return false;
                    }
                    int duration = Integer.parseInt(args[3]);
                    int amplifier = Integer.parseInt(args[4]);
                    target.addPotionEffect(new PotionEffect(type, duration, amplifier));
                    return true;
                }
                case "xp": {
                    Player target;
                    if (args.length < 2) break;
                    String amountArg = args[1];
                    boolean isLevel = false;
                    if (amountArg.endsWith("l") || amountArg.endsWith("L")) {
                        isLevel = true;
                        amountArg = amountArg.substring(0, amountArg.length() - 1);
                    }
                    int amount = Integer.parseInt(amountArg);
                    Player player2 = target = args.length >= 3 ? Bukkit.getPlayerExact((String)args[2]) : player;
                    if (target == null) {
                        return false;
                    }
                    if (isLevel) {
                        target.giveExpLevels(amount);
                    } else {
                        target.giveExp(amount);
                    }
                    return true;
                }
                case "enchant": {
                    if (args.length < 3) break;
                    Player target = Bukkit.getPlayerExact((String)args[1]);
                    if (target == null) {
                        return false;
                    }
                    String enchName = args[2].toLowerCase(Locale.ROOT);
                    int level = args.length >= 4 ? Integer.parseInt(args[3]) : 1;
                    Enchantment ench = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchName));
                    if (ench == null) {
                        return false;
                    }
                    ItemStack item = target.getInventory().getItemInMainHand();
                    if (item == null || item.getType() == Material.AIR) {
                        return false;
                    }
                    item.addEnchantment(ench, level);
                    return true;
                }
                case "advancement": {
                    if (args.length < 4 || !args[1].equalsIgnoreCase("grant")) break;
                    Player target = Bukkit.getPlayerExact((String)args[2]);
                    if (target == null) {
                        return false;
                    }
                    String adv = args[3];
                    try {
                        target.getAdvancementProgress(Bukkit.getAdvancement((NamespacedKey)NamespacedKey.minecraft((String)adv))).awardCriteria("impossible");
                    }
                    catch (Exception level) {
                        // empty catch block
                    }
                    return true;
                }
                case "attribute": {
                    if (args.length < 5) break;
                    Player target = Bukkit.getPlayerExact((String)args[1]);
                    if (target == null) {
                        return false;
                    }
                    String attrName = args[2].toUpperCase(Locale.ROOT);
                    String op = args[3].toLowerCase(Locale.ROOT);
                    double amount = Double.parseDouble(args[4]);
                    Attribute attr = Attribute.valueOf((String)attrName);
                    if (attr == null) {
                        return false;
                    }
                    AttributeInstance inst = target.getAttribute(attr);
                    if (inst == null) {
                        return false;
                    }
                    if (op.equals("add")) {
                        inst.setBaseValue(inst.getBaseValue() + amount);
                    } else if (op.equals("set")) {
                        inst.setBaseValue(amount);
                    }
                    return true;
                }
                case "clear": {
                    if (args.length < 2) break;
                    Player target = Bukkit.getPlayerExact((String)args[1]);
                    if (target == null) {
                        return false;
                    }
                    target.getInventory().clear();
                    return true;
                }
                case "kill": {
                    if (args.length < 2) break;
                    Player target = Bukkit.getPlayerExact((String)args[1]);
                    if (target == null) {
                        return false;
                    }
                    target.setHealth(0.0);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static GameMode parseGameMode(String arg) {
        switch (arg = arg.toLowerCase(Locale.ROOT)) {
            case "0": 
            case "survival": {
                return GameMode.SURVIVAL;
            }
            case "1": 
            case "creative": {
                return GameMode.CREATIVE;
            }
            case "2": 
            case "adventure": {
                return GameMode.ADVENTURE;
            }
            case "3": 
            case "spectator": {
                return GameMode.SPECTATOR;
            }
        }
        return null;
    }
}

