/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.lang.reflect.Method;
import java.util.Random;
import java.util.logging.Logger;
import org.athlantes.athiSAirdrops.AirdropLoot;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.bukkit.block.Chest;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class ItemsAdderLootProvider
implements AirdropLoot.LootProvider {
    private static final Random RANDOM = new Random();
    private static final Logger LOGGER = Logger.getLogger(ItemsAdderLootProvider.class.getName());
    private final AthiSAirdrops plugin;
    private Class<?> customStackClass;
    private Method getInstanceMethod;
    private Method getItemStackMethod;

    public ItemsAdderLootProvider(AthiSAirdrops plugin) {
        this.plugin = plugin;
        try {
            this.customStackClass = Class.forName("dev.lone.itemsadder.api.CustomStack");
            this.getInstanceMethod = this.customStackClass.getMethod("getInstance", String.class);
            this.getItemStackMethod = this.customStackClass.getMethod("getItemStack", new Class[0]);
        }
        catch (ClassNotFoundException e) {
            plugin.getLogger().info("ItemsAdder not found. Skipping IA loot.");
            this.customStackClass = null;
        }
        catch (Exception e) {
            plugin.getLogger().warning("Failed to load ItemsAdder API methods: " + e.getMessage());
            this.customStackClass = null;
        }
    }

    @Override
    public ConfigurationSection getSection(ConfigurationSection lootTable) {
        return lootTable.getConfigurationSection("itemsadder_loot");
    }

    @Override
    public int fillChest(Chest chest, ConfigurationSection section, int maxItems) {
        if (section == null || this.customStackClass == null) {
            return 0;
        }
        int added = 0;
        try {
            for (String key : section.getKeys(false)) {
                if (added < maxItems) {
                    String id;
                    double chance = section.getDouble(key + ".chance", 1.0);
                    if (RANDOM.nextDouble() > chance || (id = section.getString(key + ".material")) == null) continue;
                    Object customStack = this.getInstanceMethod.invoke(null, id);
                    if (customStack == null) {
                        this.plugin.getLogger().warning("[AthisAirdrops] Unknown IA item ID: " + id + " (table: " + section.getCurrentPath() + ", itemsadder_loot: " + key + ")");
                        continue;
                    }
                    ItemStack base = (ItemStack)this.getItemStackMethod.invoke(customStack, new Object[0]);
                    int min = Math.max(1, section.getInt(key + ".min", 1));
                    int max = Math.max(min, section.getInt(key + ".max", min));
                    base.setAmount(AirdropLoot.randomBetween(min, max));
                    chest.getInventory().addItem(new ItemStack[]{base.clone()});
                    ++added;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LOGGER.warning("Exception occurred: " + e.getMessage());
        }
        return added;
    }
}

