/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.athlantes.athiSAirdrops.AirdropAnimation;
import org.athlantes.athiSAirdrops.AirdropLocationPicker;
import org.athlantes.athiSAirdrops.AirdropLockManager;
import org.athlantes.athiSAirdrops.AirdropLoot;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.athlantes.athiSAirdrops.BlockLocationKey;
import org.athlantes.athiSAirdrops.HologramManager;
import org.athlantes.athiSAirdrops.Messages;
import org.athlantes.athiSAirdrops.ParticleManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AirdropManager {
    private final AthiSAirdrops plugin;
    private final Set<Location> activeAirdrops = ConcurrentHashMap.newKeySet();
    private final Set<Location> protectedChests = ConcurrentHashMap.newKeySet();
    private final Set<Location> pendingAirdrops = ConcurrentHashMap.newKeySet();
    private final AirdropLockManager lockManager;
    private final ParticleManager particleManager;
    private final HologramManager hologramManager;
    private final AirdropAnimation animation;
    private final Map<BlockLocationKey, BukkitTask> despawnTasks = new ConcurrentHashMap<BlockLocationKey, BukkitTask>();
    private BukkitTask spawnTask;
    private boolean running = false;
    private boolean shutdown = false;

    public AirdropManager(AthiSAirdrops plugin) {
        this.plugin = plugin;
        this.lockManager = new AirdropLockManager();
        this.particleManager = new ParticleManager(plugin);
        this.hologramManager = new HologramManager((Plugin)plugin);
        this.animation = new AirdropAnimation(plugin);
    }

    public void cleanupLeftovers() {
        try {
            this.plugin.getLogger().info("AirdropManager: cleaning up leftover armor stands/holograms...");
            for (World world : Bukkit.getWorlds()) {
                world.getEntitiesByClass(ArmorStand.class).stream().filter(as -> as != null && !as.isDead()).filter(as -> as.isMarker() && as.isInvisible()).filter(as -> {
                    try {
                        EntityEquipment eq = as.getEquipment();
                        if (eq == null) {
                            return false;
                        }
                        ItemStack helm = eq.getHelmet();
                        if (helm != null && helm.getType() == Material.CHEST) {
                            return true;
                        }
                        String name = as.getCustomName();
                        return name != null && (name.contains("Unlock") || name.contains("Despawn") || name.contains("Items Left"));
                    }
                    catch (Throwable t) {
                        return false;
                    }
                }).forEach(as -> {
                    try {
                        as.remove();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
            }
            try {
                this.hologramManager.removeAll();
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable t) {
            this.plugin.getLogger().warning("AirdropManager: cleanupLeftovers failed: " + t.getMessage());
        }
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        int interval = Math.max(1, this.plugin.getConfig().getInt("spawn_interval_seconds", 240) * 20);
        if (this.shouldSpawnAirdrop()) {
            this.spawnAirdrop();
        }
        this.spawnTask = new BukkitRunnable(){

            public void run() {
                if (AirdropManager.this.shouldSpawnAirdrop()) {
                    AirdropManager.this.spawnAirdrop();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, (long)interval, (long)interval);
    }

    public void stop() {
        this.running = false;
        this.shutdown = true;
        if (this.spawnTask != null) {
            try {
                this.spawnTask.cancel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.spawnTask = null;
        }
        try {
            for (BukkitTask t : new ArrayList<BukkitTask>(this.despawnTasks.values())) {
                if (t == null) continue;
                try {
                    t.cancel();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.despawnTasks.clear();
        try {
            this.animation.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.hologramManager.removeAll();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.particleManager.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Location loc : new HashSet<Location>(this.activeAirdrops)) {
            try {
                this.cleanupAirdropAt(loc, false);
            }
            catch (Throwable throwable) {}
        }
        this.activeAirdrops.clear();
        this.protectedChests.clear();
        try {
            this.lockManager.clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.shutdown = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public Set<Location> getActiveAirdrops() {
        return new HashSet<Location>(this.activeAirdrops);
    }

    public Set<Location> getAllVisibleAirdrops() {
        HashSet<Location> all = new HashSet<Location>(this.activeAirdrops);
        all.addAll(this.pendingAirdrops);
        return all;
    }

    public boolean isProtectedChest(Chest chest) {
        return this.protectedChests.contains(chest.getLocation());
    }

    public boolean isChestLocked(Location location) {
        return this.lockManager.isLocked(location);
    }

    private boolean shouldSpawnAirdrop() {
        int minPlayers = this.plugin.getConfig().getInt("min_players_to_spawn", 3);
        return Bukkit.getOnlinePlayers().size() >= minPlayers;
    }

    private void spawnAirdrop() {
        World world = Bukkit.getWorld((String)this.plugin.getConfig().getString("world", "world"));
        if (world == null) {
            this.plugin.getLogger().warning("Airdrop: configured world not found");
            return;
        }
        AirdropLocationPicker picker = new AirdropLocationPicker(this.plugin);
        Location location = picker.pickRandomValidLocation(world);
        if (location == null) {
            this.plugin.getLogger().info("Airdrop: no valid spawn location found");
            return;
        }
        this.spawnAt(location);
    }

    public void spawnAirdropAt(Location location) {
        if (location == null) {
            return;
        }
        this.pendingAirdrops.add(location);
        this.notifyPlayersOfAirdrop(location);
        this.animation.start(location, target -> {
            try {
                Block block = target.getBlock();
                if (!this.plugin.getConfig().getBoolean("replace_existing_block", true) && block.getType() != Material.AIR) {
                    this.plugin.getLogger().warning("[Airdrop] Target block occupied, aborting spawn at " + String.valueOf(target));
                    try {
                        this.pendingAirdrops.remove(target);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return;
                }
                block.setType(Material.CHEST);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    Block b = target.getBlock();
                    BlockState patt0$temp22 = b.getState();
                    if (!(patt0$temp22 instanceof Chest)) {
                        try {
                            this.pendingAirdrops.remove(target);
                        }
                        catch (Throwable patt0$temp22) {
                            // empty catch block
                        }
                        return;
                    }
                    Chest chestState = (Chest)patt0$temp22;
                    try {
                        this.pendingAirdrops.remove(target);
                    }
                    catch (Throwable patt0$temp22) {
                        // empty catch block
                    }
                    boolean added = this.activeAirdrops.add((Location)target);
                    this.protectedChests.add((Location)target);
                    if (this.plugin.getConfig().getBoolean("lock-airdrop", true)) {
                        int lockTime = this.plugin.getConfig().getInt("time-before-unlock", 30);
                        long unlockAtMillis = System.currentTimeMillis() + (long)lockTime * 1000L;
                        this.lockManager.addLock((Location)target, unlockAtMillis);
                    }
                    AirdropLoot loot = new AirdropLoot(this.plugin);
                    loot.fillChestWithLoot(chestState);
                    this.startVisualEffects((Location)target);
                    this.scheduleDespawn((Location)target);
                });
            }
            catch (Throwable t) {
                this.plugin.getLogger().warning("AirdropManager: error finalizing airdrop after animation: " + t.getMessage());
                try {
                    this.pendingAirdrops.remove(location);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    private void startVisualEffects(Location location) {
        if (location == null) {
            return;
        }
        Block block = location.getBlock();
        this.particleManager.addChest(block);
        BlockState blockState = block.getState();
        if (blockState instanceof Chest) {
            Chest chest = (Chest)blockState;
            int unlockTime = this.plugin.getConfig().getInt("time-before-unlock", 30);
            int despawnTime = this.plugin.getConfig().getInt("time-before-despawn", 120);
            Runnable onEmpty = () -> this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.cleanupAirdropAt(location, true));
            Runnable onDespawn = () -> this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.cleanupAirdropAt(location, true));
            this.hologramManager.spawnHologram(location, chest, unlockTime, despawnTime, onEmpty, onDespawn);
        }
    }

    private void scheduleDespawn(final Location location) {
        if (location == null) {
            return;
        }
        int despawnTimeTicks = this.plugin.getConfig().getInt("time-before-despawn", 120) * 20;
        BlockLocationKey key = BlockLocationKey.from(location);
        BukkitTask prev = this.despawnTasks.remove(key);
        if (prev != null) {
            prev.cancel();
        }
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                if (AirdropManager.this.activeAirdrops.contains(location)) {
                    AirdropManager.this.cleanupAirdropAt(location, true);
                }
            }
        }.runTaskLater((Plugin)this.plugin, (long)despawnTimeTicks);
        this.despawnTasks.put(key, task);
    }

    private void notifyPlayersOfAirdrop(Location location) {
        if (location == null) {
            return;
        }
        boolean compassEnabled = this.plugin.getConfig().getBoolean("enable-compass", true);
        String biome = location.getBlock().getBiome().name().toLowerCase().replace("_", " ");
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getWorld().equals((Object)location.getWorld())) continue;
            if (compassEnabled) {
                try {
                    player.setCompassTarget(location);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                double distance = Math.floor(player.getLocation().distance(location));
                String distanceStr = String.valueOf((int)distance);
                Messages.send((CommandSender)player, "messages.airdrop_spawned", "%biome%", biome, "%distance%", distanceStr);
                continue;
            }
            Messages.send((CommandSender)player, "messages.compass_coords", "%x%", String.valueOf(location.getBlockX()), "%y%", String.valueOf(location.getBlockY()), "%z%", String.valueOf(location.getBlockZ()));
        }
    }

    private String calculateDirection(Player player, Location target) {
        double playerYaw;
        double relAngle;
        double dz;
        double dx = target.getX() - player.getLocation().getX();
        double angle = Math.toDegrees(Math.atan2(-dx, dz = target.getZ() - player.getLocation().getZ()));
        if (angle < 0.0) {
            angle += 360.0;
        }
        if ((relAngle = (angle - (playerYaw = (double)((player.getLocation().getYaw() + 360.0f) % 360.0f)) + 360.0) % 360.0) >= 337.5 || relAngle < 22.5) {
            return "ahead";
        }
        if (relAngle < 67.5) {
            return "ahead-right";
        }
        if (relAngle < 112.5) {
            return "right";
        }
        if (relAngle < 157.5) {
            return "behind-right";
        }
        if (relAngle < 202.5) {
            return "behind";
        }
        if (relAngle < 247.5) {
            return "behind-left";
        }
        if (relAngle < 292.5) {
            return "left";
        }
        return "ahead-left";
    }

    public void cleanupAirdropAt(Location location) {
        this.cleanupAirdropAt(location, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cleanupAirdropAt(Location location, boolean broadcast) {
        block11: {
            BlockLocationKey key;
            BukkitTask scheduled;
            if (location == null) {
                return;
            }
            if (broadcast) {
                this.plugin.getLogger().info("[Airdrop] Airdrop at " + location.getBlockX() + ", " + location.getBlockZ() + " has despawned.");
            }
            if ((scheduled = this.despawnTasks.remove(key = BlockLocationKey.from(location))) != null) {
                scheduled.cancel();
            }
            try {
                BlockState blockState;
                Block preBlock = location.getBlock();
                if (preBlock.getType() == Material.CHEST && (blockState = preBlock.getState()) instanceof Chest) {
                    Chest preChest = (Chest)blockState;
                    if (!preChest.getInventory().getViewers().isEmpty()) {
                        if (!this.shutdown) {
                            new ArrayList<HumanEntity>(preChest.getInventory().getViewers()).forEach(v -> {
                                try {
                                    v.closeInventory();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            });
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.cleanupAirdropAt(location, broadcast));
                            return;
                        }
                        new ArrayList<HumanEntity>(preChest.getInventory().getViewers()).forEach(v -> {
                            try {
                                v.closeInventory();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        });
                        preBlock.setType(Material.AIR);
                        break block11;
                    } else {
                        preBlock.setType(Material.AIR);
                    }
                    break block11;
                }
                preBlock.setType(Material.AIR);
            }
            catch (Throwable t) {
                this.plugin.getLogger().warning("AirdropManager: viewer pre-close check failed: " + t.getMessage());
            }
        }
        boolean removedPending = this.pendingAirdrops.remove(location);
        boolean removedActive = this.activeAirdrops.remove(location);
        if (!removedPending && !removedActive) {
            this.plugin.getLogger().info("AirdropManager: cleanup ignored - airdrop was not active/pending for " + String.valueOf(location));
            return;
        }
        this.protectedChests.remove(location);
        this.lockManager.removeLock(location);
        this.particleManager.removeChest(location.getBlock());
        this.hologramManager.removeHologram(location);
        if (broadcast) {
            Messages.broadcast("messages.airdrop_despawned", "%x%", String.valueOf(location.getBlockX()), "%z%", String.valueOf(location.getBlockZ()));
        }
    }

    public boolean spawnAt(Location location) {
        if (location == null) {
            return false;
        }
        this.spawnAirdropAt(location);
        return true;
    }

    public void reload() {
        this.stop();
        this.activeAirdrops.clear();
        this.protectedChests.clear();
        this.lockManager.clear();
        this.particleManager.stop();
        this.hologramManager.removeAll();
    }
}

