/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.athlantes.athiSAirdrops.BlockLocationKey;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class HologramManager {
    private final Plugin plugin;
    private final Map<BlockLocationKey, HologramData> holograms = new ConcurrentHashMap<BlockLocationKey, HologramData>();
    private final Method armorStandCustomNameComponent = this.findCustomNameComponentMethod();
    private final Map<ChunkKey, Integer> forceLoadedChunkRefCounts = new ConcurrentHashMap<ChunkKey, Integer>();

    public HologramManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public void spawnHologram(Location location, Chest chest, int unlockSeconds, int despawnSeconds, Runnable onEmpty, Runnable onDespawn) {
        if (location == null || location.getWorld() == null || chest == null) {
            return;
        }
        this.removeHologram(location);
        Chunk chunk = location.getChunk();
        if (!chunk.isLoaded()) {
            chunk.load(true);
        }
        this.forceLoadChunk(chunk);
        int createDelay = Math.max(1, this.plugin.getConfig().getInt("hologram.create_delay_ticks", 2));
        int retries = Math.max(0, this.plugin.getConfig().getInt("hologram.spawn_retries", 3));
        long retryDelay = Math.max(1, this.plugin.getConfig().getInt("hologram.retry_delay_ticks", 10));
        this.plugin.getServer().getScheduler().runTaskLater(this.plugin, () -> {
            if (!location.getChunk().isLoaded()) {
                this.trySpawnWithRetries(location, chest, unlockSeconds, despawnSeconds, onEmpty, onDespawn, retries, retryDelay);
                return;
            }
            this.createHologramEntities(location, chest, unlockSeconds, despawnSeconds, onEmpty, onDespawn);
        }, (long)createDelay);
    }

    private void trySpawnWithRetries(Location location, Chest chest, int unlockSeconds, int despawnSeconds, Runnable onEmpty, Runnable onDespawn, int retries, long retryDelay) {
        if (retries <= 0) {
            this.plugin.getLogger().warning("Hologram spawn failed: chunk never loaded for " + String.valueOf(location));
            return;
        }
        this.plugin.getServer().getScheduler().runTaskLater(this.plugin, () -> {
            if (location.getChunk().isLoaded()) {
                this.createHologramEntities(location, chest, unlockSeconds, despawnSeconds, onEmpty, onDespawn);
            } else {
                this.trySpawnWithRetries(location, chest, unlockSeconds, despawnSeconds, onEmpty, onDespawn, retries - 1, retryDelay);
            }
        }, retryDelay);
    }

    private void createHologramEntities(Location location, Chest chest, int unlockSeconds, int despawnSeconds, Runnable onEmpty, Runnable onDespawn) {
        Block chestBlock = chest.getBlock();
        double centerX = (double)chestBlock.getX() + 0.5;
        double centerZ = (double)chestBlock.getZ() + 0.5;
        double baseY = chestBlock.getY();
        Block other = null;
        for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
            Block nb = chestBlock.getRelative(face);
            if (nb.getType() != chestBlock.getType()) continue;
            other = nb;
            break;
        }
        if (other != null) {
            centerX = ((double)chestBlock.getX() + (double)other.getX()) / 2.0 + 0.5;
            centerZ = ((double)chestBlock.getZ() + (double)other.getZ()) / 2.0 + 0.5;
        }
        Location topLoc = new Location(location.getWorld(), centerX, baseY + 1.9, centerZ);
        Location bottomLoc = new Location(location.getWorld(), centerX, baseY + 1.6, centerZ);
        ArmorStand top = this.spawnArmorStand(topLoc);
        ArmorStand bottom = this.spawnArmorStand(bottomLoc);
        int[] despawnSecondsLeft = new int[]{despawnSeconds};
        boolean lockAirdrop = this.plugin.getConfig().getBoolean("lock-airdrop", true);
        int[] unlockSecondsLeft = new int[]{lockAirdrop ? unlockSeconds : 0};
        BlockLocationKey key = BlockLocationKey.from(location);
        BukkitTask task = this.plugin.getServer().getScheduler().runTaskTimer(this.plugin, () -> {
            TextComponent topComp;
            if (chest.getBlock().getType() != Material.CHEST) {
                this.removeHologram(location);
                return;
            }
            long itemsLeft = Arrays.stream(chest.getInventory().getContents()).filter(i -> i != null && i.getType() != Material.AIR).count();
            if (unlockSecondsLeft[0] > 0) {
                String leftTime = String.format("%d:%02d", unlockSecondsLeft[0] / 60, unlockSecondsLeft[0] % 60);
                topComp = Component.text((String)("\ud83d\udd12 Unlock in: " + leftTime));
                unlockSecondsLeft[0] = unlockSecondsLeft[0] - 1;
            } else {
                String leftTime = String.format("%d:%02d", despawnSecondsLeft[0] / 60, despawnSecondsLeft[0] % 60);
                topComp = Component.text((String)("\u23f3 Despawn in: " + leftTime));
                despawnSecondsLeft[0] = despawnSecondsLeft[0] - 1;
            }
            TextComponent bottomComp = Component.text((String)("\ud83c\udf81 Items Left: " + itemsLeft));
            this.setName(top, (Component)topComp);
            this.setName(bottom, (Component)bottomComp);
            if (itemsLeft <= 0L) {
                try {
                    if (onEmpty != null) {
                        onEmpty.run();
                    }
                }
                catch (Exception ex) {
                    this.plugin.getLogger().warning("onEmpty callback failed: " + ex.getMessage());
                }
                this.removeHologram(location);
                return;
            }
            if (unlockSecondsLeft[0] <= 0 && despawnSecondsLeft[0] < 0) {
                try {
                    if (onDespawn != null) {
                        onDespawn.run();
                    }
                }
                catch (Exception ex) {
                    this.plugin.getLogger().warning("onDespawn callback failed: " + ex.getMessage());
                }
                this.removeHologram(location);
                return;
            }
        }, 0L, 20L);
        this.holograms.put(key, new HologramData(task, List.of(top, bottom)));
    }

    public void removeHologram(Location location) {
        if (location == null || location.getWorld() == null) {
            return;
        }
        BlockLocationKey key = BlockLocationKey.from(location);
        HologramData data = this.holograms.remove(key);
        if (data == null) {
            return;
        }
        data.task.cancel();
        for (ArmorStand as : data.stands) {
            try {
                if (as == null || as.isDead()) continue;
                as.remove();
            }
            catch (Throwable throwable) {}
        }
        Chunk chunk = location.getChunk();
        this.unforceLoadChunkIfUnused(chunk);
    }

    public boolean hasHologram(Location location) {
        if (location == null || location.getWorld() == null) {
            return false;
        }
        BlockLocationKey key = BlockLocationKey.from(location);
        return this.holograms.containsKey(key);
    }

    public void removeAll() {
        for (BlockLocationKey k : new ArrayList<BlockLocationKey>(this.holograms.keySet())) {
            HologramData d = this.holograms.remove(k);
            if (d == null) continue;
            d.task.cancel();
            for (ArmorStand as : d.stands) {
                if (as == null || as.isDead()) continue;
                as.remove();
            }
            Chunk chunk = new Location(Bukkit.getWorld((String)k.world), (double)k.x, (double)k.y, (double)k.z).getChunk();
            this.unforceLoadChunkIfUnused(chunk);
        }
        this.holograms.clear();
    }

    private ArmorStand spawnArmorStand(Location loc) {
        ArmorStand as = (ArmorStand)loc.getWorld().spawnEntity(loc, EntityType.ARMOR_STAND);
        as.setVisible(false);
        as.setGravity(false);
        as.setMarker(true);
        as.setCustomNameVisible(true);
        as.setCollidable(false);
        try {
            as.setPersistent(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return as;
    }

    private void setName(ArmorStand as, Component comp) {
        try {
            if (this.armorStandCustomNameComponent != null) {
                this.armorStandCustomNameComponent.invoke((Object)as, comp);
            } else {
                String legacy = LegacyComponentSerializer.legacySection().serialize(comp);
                as.setCustomName(legacy);
            }
            as.setCustomNameVisible(true);
        }
        catch (Throwable t) {
            try {
                String legacy = LegacyComponentSerializer.legacySection().serialize(comp);
                as.setCustomName(legacy);
                as.setCustomNameVisible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private Method findCustomNameComponentMethod() {
        try {
            Method m = ArmorStand.class.getMethod("customName", Component.class);
            m.setAccessible(true);
            return m;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private void forceLoadChunk(Chunk chunk) {
        ChunkKey key = new ChunkKey(chunk.getWorld().getName(), chunk.getX(), chunk.getZ());
        this.forceLoadedChunkRefCounts.merge(key, 1, Integer::sum);
        if (this.forceLoadedChunkRefCounts.get(key) == 1) {
            chunk.setForceLoaded(true);
        }
    }

    private void unforceLoadChunkIfUnused(Chunk chunk) {
        ChunkKey key = new ChunkKey(chunk.getWorld().getName(), chunk.getX(), chunk.getZ());
        this.forceLoadedChunkRefCounts.computeIfPresent(key, (k, count) -> {
            int newCount = count - 1;
            if (newCount <= 0) {
                chunk.setForceLoaded(false);
                return null;
            }
            return newCount;
        });
    }

    private static class HologramData {
        final BukkitTask task;
        final List<ArmorStand> stands;

        HologramData(BukkitTask t, List<ArmorStand> s) {
            this.task = t;
            this.stands = s;
        }
    }

    private static class ChunkKey {
        final String world;
        final int x;
        final int z;

        ChunkKey(String world, int x, int z) {
            this.world = world;
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ChunkKey)) {
                return false;
            }
            ChunkKey k = (ChunkKey)o;
            return this.x == k.x && this.z == k.z && this.world.equals(k.world);
        }

        public int hashCode() {
            return Objects.hash(this.world, this.x, this.z);
        }

        public String toString() {
            return "ChunkKey{world='" + this.world + "', x=" + this.x + ", z=" + this.z + "}";
        }
    }
}

