/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ParticleManager {
    private final AthiSAirdrops plugin;
    private final Set<Block> activeChests = ConcurrentHashMap.newKeySet();
    private BukkitTask task;
    private int intervalTicks = 10;

    public ParticleManager(AthiSAirdrops plugin) {
        this.plugin = plugin;
    }

    public void setInterval(int ticks) {
        this.intervalTicks = Math.max(1, ticks);
        this.restartIfRunning();
    }

    public void addChest(Block block) {
        if (block == null) {
            return;
        }
        this.activeChests.add(block);
        this.startIfNeeded();
    }

    public void removeChest(Block block) {
        if (block == null) {
            return;
        }
        this.activeChests.remove(block);
        if (this.activeChests.isEmpty()) {
            this.stop();
        }
    }

    private void startIfNeeded() {
        if (this.task != null) {
            return;
        }
        this.task = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            Iterator<Block> it = this.activeChests.iterator();
            while (it.hasNext()) {
                Block b = it.next();
                if (!(b.getState() instanceof Chest)) {
                    it.remove();
                    continue;
                }
                Location baseLoc = b.getLocation().clone().add(0.5, 1.0, 0.5);
                b.getWorld().spawnParticle(Particle.CAMPFIRE_SIGNAL_SMOKE, baseLoc, 1, 0.0, 1.5, 0.0, 0.05);
            }
        }, 0L, (long)this.intervalTicks);
    }

    private void restartIfRunning() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
            this.startIfNeeded();
        }
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        this.activeChests.clear();
    }
}

