/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.io.File;
import org.athlantes.athiSAirdrops.AirdropCommand;
import org.athlantes.athiSAirdrops.AirdropListeners;
import org.athlantes.athiSAirdrops.AirdropManager;
import org.athlantes.athiSAirdrops.AirdropTabCompleter;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class AthiSAirdrops
extends JavaPlugin {
    private static AthiSAirdrops instance;
    private AirdropManager manager;
    private boolean nexoEnabled = false;
    private boolean itemsAdderEnabled = false;
    private boolean mmoItemsEnabled = false;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        File lootFile = new File(this.getDataFolder(), "loot.yml");
        if (!lootFile.exists()) {
            this.saveResource("loot.yml", false);
        }
        this.itemsAdderEnabled = this.getServer().getPluginManager().isPluginEnabled("ItemsAdder");
        if (this.itemsAdderEnabled) {
            this.getLogger().info("ItemsAdder detected! Enabling ItemsAdder support.");
        }
        this.nexoEnabled = this.getServer().getPluginManager().isPluginEnabled("Nexo");
        if (this.nexoEnabled) {
            this.getLogger().info("Nexo detected! Enabling Nexo integration.");
        }
        this.mmoItemsEnabled = this.getServer().getPluginManager().isPluginEnabled("MMOItems");
        if (this.mmoItemsEnabled) {
            this.getLogger().info("MMOItems detected! Enabling MMOItems integration.");
        }
        this.manager = new AirdropManager(this);
        this.manager.cleanupLeftovers();
        this.getServer().getPluginManager().registerEvents((Listener)new AirdropListeners(this, this.manager), (Plugin)this);
        this.getCommand("airdrop").setExecutor((CommandExecutor)new AirdropCommand(this, this.manager));
        this.getCommand("airdrop").setTabCompleter((TabCompleter)new AirdropTabCompleter());
        if (this.getConfig().getBoolean("autostart", false)) {
            this.manager.start();
        }
        this.getLogger().info("AthiSAirdrops has been enabled!");
    }

    public void onDisable() {
        if (this.manager != null) {
            this.manager.stop();
        }
        this.getLogger().info("AthiSAirdrops has been disabled!");
    }

    public static AthiSAirdrops getInstance() {
        return instance;
    }

    public AirdropManager getManager() {
        return this.manager;
    }

    public boolean isItemsAdderEnabled() {
        return this.itemsAdderEnabled;
    }

    public boolean isNexoEnabled() {
        return this.nexoEnabled;
    }

    public boolean isMMOItemsEnabled() {
        return this.mmoItemsEnabled;
    }
}

