/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.athlantes.athiSAirdrops.AirdropLoot;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Chest;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CommandLootProvider
implements AirdropLoot.LootProvider {
    private static final Random RANDOM = new Random();
    private final AthiSAirdrops plugin;
    private static final LegacyComponentSerializer LEGACY = LegacyComponentSerializer.legacyAmpersand();

    public CommandLootProvider(AthiSAirdrops plugin) {
        this.plugin = plugin;
    }

    @Override
    public ConfigurationSection getSection(ConfigurationSection lootTable) {
        return lootTable.getConfigurationSection("commands");
    }

    @Override
    public int fillChest(Chest chest, ConfigurationSection section, int maxItems) {
        if (section == null) {
            return 0;
        }
        int added = 0;
        for (String key : section.getKeys(false)) {
            int amount;
            ItemStack item;
            ItemMeta meta;
            if (added >= maxItems) break;
            double chance = section.getDouble(key + ".chance", 1.0);
            if (RANDOM.nextDouble() > chance) continue;
            List consoleCmds = section.getStringList(key + ".console_commands");
            List playerCmds = section.getStringList(key + ".player_commands");
            if (consoleCmds.isEmpty() && playerCmds.isEmpty()) continue;
            String displayName = section.getString(key + ".name", "&aReward Voucher");
            List loreCfg = section.getStringList(key + ".lore");
            String materialCfg = section.getString(key + ".material", "PAPER");
            Material mat = Material.matchMaterial((String)materialCfg);
            if (mat == null) {
                mat = Material.PAPER;
            }
            if ((meta = (item = new ItemStack(mat, amount = Math.max(1, section.getInt(key + ".amount", 1)))).getItemMeta()) != null) {
                meta.displayName((Component)LEGACY.deserialize(displayName));
                ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
                if (!loreCfg.isEmpty()) {
                    lore.addAll(loreCfg.stream().map(arg_0 -> ((LegacyComponentSerializer)LEGACY).deserialize(arg_0)).toList());
                } else {
                    lore.add(LEGACY.deserialize("&7Right Click to redeem"));
                }
                meta.lore(lore);
                NamespacedKey keyConsoleMeta = new NamespacedKey((Plugin)this.plugin, "reward_console");
                NamespacedKey keyPlayerMeta = new NamespacedKey((Plugin)this.plugin, "reward_player");
                NamespacedKey keyConsume = new NamespacedKey((Plugin)this.plugin, "reward_consume");
                NamespacedKey keyCooldown = new NamespacedKey((Plugin)this.plugin, "reward_cooldown");
                NamespacedKey keyId = new NamespacedKey((Plugin)this.plugin, "reward_id");
                if (!consoleCmds.isEmpty()) {
                    meta.getPersistentDataContainer().set(keyConsoleMeta, PersistentDataType.STRING, (Object)String.join((CharSequence)"\n", consoleCmds));
                }
                if (!playerCmds.isEmpty()) {
                    meta.getPersistentDataContainer().set(keyPlayerMeta, PersistentDataType.STRING, (Object)String.join((CharSequence)"\n", playerCmds));
                }
                meta.getPersistentDataContainer().set(keyConsume, PersistentDataType.BYTE, (Object)((byte)(section.getBoolean(key + ".consume_on_use", true) ? 1 : 0)));
                if (section.contains(key + ".cooldown_seconds")) {
                    meta.getPersistentDataContainer().set(keyCooldown, PersistentDataType.INTEGER, (Object)section.getInt(key + ".cooldown_seconds", 0));
                }
                meta.getPersistentDataContainer().set(keyId, PersistentDataType.STRING, (Object)UUID.randomUUID().toString());
                item.setItemMeta(meta);
            }
            chest.getInventory().addItem(new ItemStack[]{item});
            ++added;
        }
        return added;
    }
}

