/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.util.LinkedHashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.athlantes.athiSAirdrops.AirdropManager;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class AirdropCommand
implements CommandExecutor {
    private final AthiSAirdrops plugin;
    public static final Map<String, Subcommand> SUBCOMMANDS = new LinkedHashMap<String, Subcommand>();

    public AirdropCommand(AthiSAirdrops plugin, AirdropManager manager) {
        this.plugin = plugin;
        this.register(new Subcommand("locate", "athisairdrops.locate", "/airdrop locate", (sender, args) -> this.sendMsg(sender, "messages.airdrop_locate_hint", new String[0])));
        this.register(new Subcommand("start", "athisairdrops.admin", "/airdrop start", (sender, args) -> {
            if (manager.isRunning()) {
                this.sendMsg(sender, "messages.system_already_running", new String[0]);
            } else {
                manager.start();
                this.sendMsg(sender, "messages.autostart", new String[0]);
            }
        }));
        this.register(new Subcommand("stop", "athisairdrops.admin", "/airdrop stop", (sender, args) -> {
            boolean wasRunning = manager.isRunning();
            manager.stop();
            if (wasRunning) {
                this.sendMsg(sender, "messages.system_stopped", new String[0]);
            } else if (!manager.getActiveAirdrops().isEmpty()) {
                this.sendMsg(sender, "messages.system_stopped_manual", new String[0]);
            } else {
                this.sendMsg(sender, "messages.system_not_running", new String[0]);
            }
        }));
        this.register(new Subcommand("spawn", "athisairdrops.admin", "/airdrop spawn <player|x y z>", (sender, args) -> {
            if (args.length == 2) {
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    this.sendMsg(sender, "messages.player_not_found", new String[0]);
                } else {
                    Location loc = target.getLocation().clone();
                    loc.setY((double)loc.getWorld().getHighestBlockYAt(loc) + 1.0);
                    manager.spawnAt(loc);
                    this.sendMsg(sender, "messages.spawned_at_player", "%player%", target.getName());
                }
            } else if (args.length == 4) {
                try {
                    double x = Double.parseDouble(args[1]);
                    double y = Double.parseDouble(args[2]);
                    double z = Double.parseDouble(args[3]);
                    World world = Bukkit.getWorld((String)plugin.getConfig().getString("world", "world"));
                    if (world == null) {
                        this.sendMsg(sender, "messages.invalid_world", new String[0]);
                        return;
                    }
                    Location loc = new Location(world, x, y, z);
                    loc.setY(Math.max(y, (double)world.getHighestBlockYAt(loc) + 1.0));
                    manager.spawnAt(loc);
                    this.sendMsg(sender, "messages.spawned_at_coords", "%x%", String.valueOf(x), "%y%", String.valueOf(loc.getY()), "%z%", String.valueOf(z));
                }
                catch (NumberFormatException e) {
                    this.sendMsg(sender, "messages.invalid_coordinates", new String[0]);
                }
            } else {
                this.sendMsg(sender, "messages.usage_spawn", new String[0]);
            }
        }));
        this.register(new Subcommand("reload", "athisairdrops.admin", "/airdrop reload", (sender, args) -> {
            plugin.reloadConfig();
            manager.reload();
            this.sendMsg(sender, "messages.reload_success", new String[0]);
        }));
        this.register(new Subcommand("status", "athisairdrops.admin", "/airdrop status", (sender, args) -> this.sendMsg(sender, "messages.status", "%status%", String.valueOf(manager.isRunning()))));
    }

    private void register(Subcommand sub) {
        SUBCOMMANDS.put(sub.name().toLowerCase(), sub);
    }

    private void sendMsg(CommandSender sender, String configPath, String ... placeholders) {
        Object msg = this.plugin.getConfig().getString(configPath);
        if (msg == null) {
            msg = "&cMissing message in config: " + configPath;
        }
        for (int i = 0; i < placeholders.length; i += 2) {
            msg = ((String)msg).replace(placeholders[i], placeholders[i + 1]);
        }
        sender.sendMessage((Component)Component.text((String)this.color((String)msg)));
    }

    private String color(String msg) {
        return msg.replace("&", "\u00a7");
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            this.showUsage(sender);
            return true;
        }
        Subcommand sub = SUBCOMMANDS.get(args[0].toLowerCase());
        if (sub == null) {
            this.sendMsg(sender, "messages.unknown_command", new String[0]);
            return true;
        }
        if (!sender.hasPermission(sub.permission())) {
            this.sendMsg(sender, "messages.no_permission", new String[0]);
            return true;
        }
        sub.handler().execute(sender, args);
        return true;
    }

    private void showUsage(CommandSender sender) {
        this.sendMsg(sender, "messages.available_commands_header", new String[0]);
        for (Subcommand sub : SUBCOMMANDS.values()) {
            if (!sender.hasPermission(sub.permission())) continue;
            this.sendMsg(sender, "messages.command_usage_format", "%usage%", sub.usage());
        }
    }

    public record Subcommand(String name, String permission, String usage, CommandHandler handler) {
    }

    @FunctionalInterface
    public static interface CommandHandler {
        public void execute(CommandSender var1, String[] var2);
    }
}

