/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.athlantes.athiSAirdrops.AirdropManager;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class AirdropListeners
implements Listener {
    private final AthiSAirdrops plugin;
    private final AirdropManager manager;
    private final Map<UUID, Long> compassCooldowns = new HashMap<UUID, Long>();

    public AirdropListeners(AthiSAirdrops plugin, AirdropManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    private void sendMsg(Player player, String path, Map<String, String> placeholders) {
        String raw = this.plugin.getConfig().getString(path, path);
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                raw = raw.replace("%" + entry.getKey() + "%", entry.getValue());
            }
        }
        player.sendMessage((Component)Component.text((String)this.color(raw)));
    }

    private void sendMsg(Player player, String path) {
        this.sendMsg(player, path, null);
    }

    private String color(String msg) {
        return msg.replace("&", "\u00a7");
    }

    private long getCompassCooldownMs() {
        return (long)this.plugin.getConfig().getInt("compass-cooldown", 10) * 1000L;
    }

    @EventHandler
    public void onChestBreak(BlockBreakEvent event) {
        Chest chest;
        BlockState blockState = event.getBlock().getState();
        if (blockState instanceof Chest && this.manager.isProtectedChest(chest = (Chest)blockState)) {
            event.setCancelled(true);
            this.sendMsg(event.getPlayer(), "messages.chest_protected");
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Object method;
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof Chest)) {
            return;
        }
        Chest chest = (Chest)inventoryHolder;
        if (!this.manager.isProtectedChest(chest)) {
            return;
        }
        long itemsLeft = Arrays.stream(event.getInventory().getContents()).filter(i -> i != null && i.getType() != Material.AIR).count();
        if (this.plugin.isItemsAdderEnabled()) {
            try {
                Class<?> iaAPIClass = Class.forName("dev.lone.itemsadder.api.ItemsAdder");
                method = iaAPIClass.getMethod("getCustomStack", ItemStack.class);
                for (ItemStack item : event.getInventory().getContents()) {
                    Object customStack;
                    if (item == null || (customStack = ((Method)method).invoke(null, item)) == null) continue;
                    ++itemsLeft;
                }
            }
            catch (Exception iaAPIClass) {
                // empty catch block
            }
        }
        if (itemsLeft <= 0L && (method = event.getPlayer()) instanceof Player) {
            BlockState blockState;
            Player player = (Player)method;
            this.sendMsg(player, "messages.chest_empty_notice");
            Location loc = chest.getLocation();
            Block block = loc.getBlock();
            if (block.getType() == Material.CHEST && (blockState = block.getState()) instanceof Chest) {
                Chest c = (Chest)blockState;
                boolean stillEmpty = Arrays.stream(c.getInventory().getContents()).allMatch(i -> i == null || i.getType() == Material.AIR);
                if (this.plugin.isItemsAdderEnabled()) {
                    try {
                        Class<?> iaAPIClass = Class.forName("dev.lone.itemsadder.api.ItemsAdder");
                        Method method2 = iaAPIClass.getMethod("getCustomStack", ItemStack.class);
                        for (ItemStack item : c.getInventory().getContents()) {
                            Object cs;
                            if (item == null || (cs = method2.invoke(null, item)) == null) continue;
                            stillEmpty = false;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (stillEmpty) {
                    this.manager.cleanupAirdropAt(loc);
                }
            }
        }
    }

    @EventHandler
    public void onCompassUse(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (!event.getAction().toString().contains("RIGHT_CLICK")) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() != Material.COMPASS) {
            return;
        }
        UUID id = player.getUniqueId();
        long now = System.currentTimeMillis();
        Long lastUse = this.compassCooldowns.get(id);
        long cooldownMs = this.getCompassCooldownMs();
        if (lastUse != null && now - lastUse < cooldownMs) {
            long secondsLeft = (cooldownMs - (now - lastUse)) / 1000L + 1L;
            this.sendMsg(player, "messages.compass_cooldown", Map.of("seconds", String.valueOf(secondsLeft)));
            event.setCancelled(true);
            return;
        }
        this.compassCooldowns.put(id, now);
        List<Location> active = this.manager.getActiveAirdrops().stream().filter(loc -> loc.getWorld() != null && loc.getWorld().equals((Object)player.getWorld())).toList();
        if (active.isEmpty()) {
            this.sendMsg(player, "messages.no_active_airdrop");
            event.setCancelled(true);
            return;
        }
        Location nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Location loc2 : active) {
            try {
                double dist = player.getLocation().distance(loc2);
                if (!(dist < nearestDistance)) continue;
                nearestDistance = dist;
                nearest = loc2;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (nearest == null) {
            this.sendMsg(player, "messages.no_active_airdrop");
            event.setCancelled(true);
            return;
        }
        this.sendMsg(player, "messages.compass_location", this.createCompassPlaceholders(player, nearest));
        event.setCancelled(true);
    }

    private Map<String, String> createCompassPlaceholders(Player player, Location drop) {
        double distance = player.getLocation().distance(drop);
        String direction = this.calculateDirection(player, drop);
        return Map.of("distance", String.valueOf((int)distance), "direction", direction);
    }

    private String calculateDirection(Player player, Location target) {
        double playerYaw;
        double relAngle;
        double dz;
        double dx = target.getX() - player.getLocation().getX();
        double angle = Math.toDegrees(Math.atan2(-dx, dz = target.getZ() - player.getLocation().getZ()));
        if (angle < 0.0) {
            angle += 360.0;
        }
        if ((relAngle = (angle - (playerYaw = (double)((player.getLocation().getYaw() + 360.0f) % 360.0f)) + 360.0) % 360.0) >= 337.5 || relAngle < 22.5) {
            return "ahead";
        }
        if (relAngle < 67.5) {
            return "ahead-right";
        }
        if (relAngle < 112.5) {
            return "right";
        }
        if (relAngle < 157.5) {
            return "behind-right";
        }
        if (relAngle < 202.5) {
            return "behind";
        }
        if (relAngle < 247.5) {
            return "behind-left";
        }
        if (relAngle < 292.5) {
            return "left";
        }
        return "ahead-left";
    }

    @EventHandler
    public void onChestInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null || event.getClickedBlock().getType() != Material.CHEST) {
            return;
        }
        Location loc = event.getClickedBlock().getLocation();
        if (this.manager.isChestLocked(loc)) {
            this.sendMsg(event.getPlayer(), "messages.chest_locked");
            event.setCancelled(true);
        }
    }
}

