/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.Chest;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AirdropLoot {
    private final AthiSAirdrops plugin;
    private final LootTableSelector lootTableSelector;
    private final List<LootProvider> lootProviders;

    public AirdropLoot(AthiSAirdrops plugin) {
        this.plugin = plugin;
        this.lootTableSelector = new LootTableSelector(plugin);
        this.lootProviders = new ArrayList<LootProvider>();
        if (plugin.isItemsAdderEnabled()) {
            this.lootProviders.add(new ItemsAdderLootProvider(plugin));
        }
        this.lootProviders.add(new VanillaLootProvider(plugin));
    }

    public void reload() {
        this.lootTableSelector.reload();
        this.validateVanillaLoot();
    }

    private void validateVanillaLoot() {
        for (String tableName : this.lootTableSelector.lootConfig.getKeys(false)) {
            ConfigurationSection vanillaSection;
            ConfigurationSection lootTable = this.lootTableSelector.lootConfig.getConfigurationSection(tableName);
            if (lootTable == null || (vanillaSection = lootTable.getConfigurationSection("loot")) == null) continue;
            for (String key : vanillaSection.getKeys(false)) {
                Material mat;
                String matStr = vanillaSection.getString(key + ".material");
                if (matStr == null || (mat = Material.matchMaterial((String)matStr)) != null) continue;
                this.plugin.getLogger().severe("[AthisAirdrops] Invalid vanilla item ID in loot.yml: " + matStr + " (table: " + tableName + ", key: " + key + ")");
            }
        }
    }

    public void fillChestWithLoot(Chest chest) {
        chest.getInventory().clear();
        ConfigurationSection lootTable = this.lootTableSelector.selectLootTable();
        if (lootTable == null) {
            this.plugin.getLogger().warning("No loot table selected or loot.yml missing/chances zero.");
            return;
        }
        int minItems = Math.max(1, lootTable.getInt("min-items", 1));
        int maxItems = Math.max(minItems, lootTable.getInt("max-items", minItems));
        int itemsToAdd = AirdropLoot.randomBetween(minItems, maxItems);
        for (LootProvider provider : this.lootProviders) {
            ConfigurationSection section = provider.getSection(lootTable);
            if (section == null) continue;
            provider.fillChest(chest, section, itemsToAdd);
        }
    }

    private boolean chestIsEmpty(Chest chest) {
        return Arrays.stream(chest.getInventory().getContents()).allMatch(Objects::isNull);
    }

    private static int randomBetween(int min, int max) {
        Random random = new Random();
        return max <= min ? min : min + random.nextInt(max - min + 1);
    }

    public static class LootTableSelector {
        private final AthiSAirdrops plugin;
        private FileConfiguration lootConfig;

        public LootTableSelector(AthiSAirdrops plugin) {
            this.plugin = plugin;
            File lootFile = new File(plugin.getDataFolder(), "loot.yml");
            this.lootConfig = YamlConfiguration.loadConfiguration((File)lootFile);
        }

        public void reload() {
            File lootFile = new File(this.plugin.getDataFolder(), "loot.yml");
            this.lootConfig = YamlConfiguration.loadConfiguration((File)lootFile);
        }

        public ConfigurationSection selectLootTable() {
            LinkedHashMap<String, Double> tableChances = new LinkedHashMap<String, Double>();
            double totalChance = 0.0;
            for (String tableName : this.lootConfig.getKeys(false)) {
                double chance = this.lootConfig.getDouble(tableName + ".chance", 1.0);
                if (!(chance > 0.0)) continue;
                tableChances.put(tableName, chance);
                totalChance += chance;
            }
            if (tableChances.isEmpty()) {
                return null;
            }
            double roll = Math.random() * totalChance;
            for (Map.Entry entry : tableChances.entrySet()) {
                if (!((roll -= ((Double)entry.getValue()).doubleValue()) <= 0.0)) continue;
                return this.lootConfig.getConfigurationSection((String)entry.getKey());
            }
            return null;
        }
    }

    public static class ItemsAdderLootProvider
    implements LootProvider {
        private static final Random RANDOM = new Random();
        private final AthiSAirdrops plugin;
        private Class<?> customStackClass;
        private Method getInstanceMethod;
        private Method getItemStackMethod;

        public ItemsAdderLootProvider(AthiSAirdrops plugin) {
            this.plugin = plugin;
            try {
                this.customStackClass = Class.forName("dev.lone.itemsadder.api.CustomStack");
                this.getInstanceMethod = this.customStackClass.getMethod("getInstance", String.class);
                this.getItemStackMethod = this.customStackClass.getMethod("getItemStack", new Class[0]);
            }
            catch (ClassNotFoundException e) {
                plugin.getLogger().info("ItemsAdder not found. Skipping IA loot.");
                this.customStackClass = null;
            }
            catch (Exception e) {
                plugin.getLogger().warning("Failed to load ItemsAdder API methods: " + e.getMessage());
                this.customStackClass = null;
            }
        }

        @Override
        public ConfigurationSection getSection(ConfigurationSection lootTable) {
            return lootTable.getConfigurationSection("itemsadder_loot");
        }

        @Override
        public int fillChest(Chest chest, ConfigurationSection section, int maxItems) {
            if (section == null || this.customStackClass == null) {
                return 0;
            }
            int added = 0;
            try {
                for (String key : section.getKeys(false)) {
                    if (added < maxItems) {
                        String id;
                        double chance = section.getDouble(key + ".chance", 1.0);
                        if (RANDOM.nextDouble() > chance || (id = section.getString(key + ".material")) == null) continue;
                        Object customStack = this.getInstanceMethod.invoke(null, id);
                        if (customStack == null) {
                            this.plugin.getLogger().warning("[AthisAirdrops] Unknown IA item ID: " + id + " (table: " + section.getCurrentPath() + ", itemsadder_loot: " + key + ")");
                            continue;
                        }
                        ItemStack base = (ItemStack)this.getItemStackMethod.invoke(customStack, new Object[0]);
                        int min = Math.max(1, section.getInt(key + ".min", 1));
                        int max = Math.max(min, section.getInt(key + ".max", min));
                        base.setAmount(AirdropLoot.randomBetween(min, max));
                        chest.getInventory().addItem(new ItemStack[]{base.clone()});
                        ++added;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to load ItemsAdder custom loot: " + e.getMessage());
                e.printStackTrace();
            }
            return added;
        }
    }

    public static class VanillaLootProvider
    implements LootProvider {
        private static final Random RANDOM = new Random();
        private final AthiSAirdrops plugin;

        public VanillaLootProvider(AthiSAirdrops plugin) {
            this.plugin = plugin;
        }

        @Override
        public ConfigurationSection getSection(ConfigurationSection lootTable) {
            return lootTable.getConfigurationSection("loot");
        }

        @Override
        public int fillChest(Chest chest, ConfigurationSection section, int maxItems) {
            if (section == null) {
                return 0;
            }
            ArrayList<ItemStack> pool = new ArrayList<ItemStack>();
            for (String key : section.getKeys(false)) {
                Material mat;
                double chance = section.getDouble(key + ".chance", 1.0);
                if (RANDOM.nextDouble() > chance || (mat = Material.matchMaterial((String)section.getString(key + ".material", "STONE"))) == null) continue;
                int min = Math.max(1, section.getInt(key + ".min", 1));
                int max = Math.max(min, section.getInt(key + ".max", min));
                ItemStack base = new ItemStack(mat, AirdropLoot.randomBetween(min, max));
                if (section.isConfigurationSection(key + ".enchantments")) {
                    ItemMeta meta = base.getItemMeta();
                    ConfigurationSection enchSection = section.getConfigurationSection(key + ".enchantments");
                    for (String enchKey : enchSection.getKeys(false)) {
                        NamespacedKey nsKey = NamespacedKey.minecraft((String)enchKey.toLowerCase(Locale.ROOT));
                        Enchantment ench = (Enchantment)Registry.ENCHANTMENT.get(nsKey);
                        if (ench == null) continue;
                        int level = Math.max(1, enchSection.getInt(enchKey, 1));
                        meta.addEnchant(ench, level, true);
                    }
                    base.setItemMeta(meta);
                }
                pool.add(base.clone());
            }
            Collections.shuffle(pool, RANDOM);
            int size = chest.getInventory().getSize();
            HashSet<Integer> usedSlots = new HashSet<Integer>();
            int added = 0;
            block2: for (ItemStack item : pool) {
                if (added >= maxItems) break;
                for (int tries = 0; tries < 40; ++tries) {
                    int slot = RANDOM.nextInt(size);
                    if (usedSlots.contains(slot)) continue;
                    chest.getInventory().setItem(slot, item);
                    usedSlots.add(slot);
                    ++added;
                    continue block2;
                }
            }
            return added;
        }
    }

    public static interface LootProvider {
        public ConfigurationSection getSection(ConfigurationSection var1);

        public int fillChest(Chest var1, ConfigurationSection var2, int var3);
    }
}

