/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.athlantes.athiSAirdrops.AirdropLoot;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.athlantes.athiSAirdrops.HologramManager;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AirdropManager {
    private final AthiSAirdrops plugin;
    private long spawnIntervalSeconds;
    private boolean replaceExistingBlock;
    private boolean lockAirdrop;
    private int unlockSeconds;
    private int despawnSeconds;
    private int particleIntervalTicks;
    private boolean autostart;
    private int minPlayersToSpawn;
    private boolean enableCompass;
    private int compassCooldown;
    private int lootCountMin;
    private int lootCountMax;
    private final AirdropAnimation animation;
    private final ParticleManager particleManager;
    private final AirdropLocationPicker locationPicker;
    private final AirdropLockManager lockManager;
    private final HologramManager hologramManager;
    private final AirdropLoot airdropLoot;
    private BukkitTask repeatingTask;
    private volatile Location lastAirdropLocation;
    private final NamespacedKey unbreakableKey;
    private final Set<Location> activeAirdrops = ConcurrentHashMap.newKeySet();

    public AirdropManager(AthiSAirdrops plugin) {
        this.plugin = plugin;
        this.unbreakableKey = new NamespacedKey((Plugin)plugin, "athis_unbreakable");
        this.hologramManager = new HologramManager((Plugin)plugin);
        this.airdropLoot = new AirdropLoot(plugin);
        this.animation = new AirdropAnimation(plugin);
        this.particleManager = new ParticleManager(plugin);
        this.locationPicker = new AirdropLocationPicker(plugin);
        this.lockManager = new AirdropLockManager();
        this.reload();
    }

    public void reload() {
        if (this.repeatingTask != null) {
            this.stop();
            this.repeatingTask = null;
        }
        this.plugin.reloadConfig();
        this.spawnIntervalSeconds = Math.max(5L, this.plugin.getConfig().getLong("spawn_interval_seconds", 240L));
        this.replaceExistingBlock = this.plugin.getConfig().getBoolean("replace_existing_block", false);
        this.lockAirdrop = this.plugin.getConfig().getBoolean("lock-airdrop", true);
        this.unlockSeconds = this.plugin.getConfig().getInt("time-before-unlock", 30);
        this.despawnSeconds = this.plugin.getConfig().getInt("time-before-despawn", 120);
        this.particleIntervalTicks = Math.max(1, this.plugin.getConfig().getInt("particle_interval_ticks", 10));
        this.autostart = this.plugin.getConfig().getBoolean("autostart", false);
        this.minPlayersToSpawn = this.plugin.getConfig().getInt("min_players_to_spawn", 3);
        this.enableCompass = this.plugin.getConfig().getBoolean("enable-compass", true);
        this.compassCooldown = this.plugin.getConfig().getInt("compass-cooldown", 10);
        this.lootCountMin = this.plugin.getConfig().getInt("loot_count.min", 5);
        this.lootCountMax = this.plugin.getConfig().getInt("loot_count.max", 10);
        this.particleManager.setInterval(this.particleIntervalTicks);
        this.airdropLoot.reload();
    }

    public Set<Location> getActiveAirdrops() {
        return Collections.unmodifiableSet(this.activeAirdrops);
    }

    public boolean isRunning() {
        return this.repeatingTask != null && !this.repeatingTask.isCancelled();
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.repeatingTask = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, this::scheduledSpawnAttempt, 0L, this.spawnIntervalSeconds * 20L);
    }

    public void stop() {
        if (this.repeatingTask != null) {
            this.repeatingTask.cancel();
            this.repeatingTask = null;
        }
        if (this.lastAirdropLocation != null) {
            this.cleanupAirdropAt(this.lastAirdropLocation);
            this.lastAirdropLocation = null;
        }
        this.particleManager.stop();
        this.hologramManager.removeAll();
        this.animation.stop();
    }

    private void scheduledSpawnAttempt() {
        World world = this.plugin.getServer().getWorld(this.plugin.getConfig().getString("world", "world"));
        if (world == null) {
            return;
        }
        Location loc = this.locationPicker.pickRandomValidLocation(world);
        if (loc != null) {
            this.spawnAt(loc);
        }
    }

    public void spawnAt(Location location) {
        if (location == null || location.getWorld() == null) {
            return;
        }
        Chunk chunk = location.getChunk();
        if (!chunk.isLoaded()) {
            chunk.load(true);
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (this.lastAirdropLocation != null) {
                this.cleanupAirdropAt(this.lastAirdropLocation);
            }
            this.animation.start(location, this::finishSpawn);
        });
    }

    private void finishSpawn(Location location) {
        if (location == null || location.getWorld() == null) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            Block block = location.getBlock();
            if (!this.replaceExistingBlock && !block.getType().isAir()) {
                int y = location.getWorld().getHighestBlockYAt(location.getBlockX(), location.getBlockZ());
                location.setY((double)y + 1.0);
                block = location.getBlock();
                if (!block.getType().isAir()) {
                    this.plugin.getLogger().info("Skipping spawn; target not air and replacement disabled.");
                    return;
                }
            }
            block.setType(Material.CHEST);
            BlockState patt0$temp = block.getState();
            if (!(patt0$temp instanceof Chest)) {
                this.plugin.getLogger().warning("Failed to set chest at " + String.valueOf(location));
                return;
            }
            Chest chest = (Chest)patt0$temp;
            chest.getPersistentDataContainer().set(this.unbreakableKey, PersistentDataType.BYTE, (Object)1);
            chest.update();
            this.airdropLoot.fillChestWithLoot(chest);
            boolean chestIsEmpty = Arrays.stream(chest.getInventory().getContents()).allMatch(Objects::isNull);
            if (chestIsEmpty) {
                this.plugin.getLogger().info("Airdrop spawn aborted: chest would be empty at " + String.valueOf(location));
                block.setType(Material.AIR);
                return;
            }
            if (this.lockAirdrop) {
                long unlockAt = System.currentTimeMillis() + (long)this.unlockSeconds * 1000L;
                this.lockManager.addLock(location, unlockAt);
            }
            this.particleManager.addChest(block);
            this.hologramManager.spawnHologram(location, chest, this.unlockSeconds, this.despawnSeconds, () -> this.cleanupAirdropAt(location));
            this.lastAirdropLocation = location.clone();
            this.activeAirdrops.add(location.clone());
            this.announceAirdrop(location);
        });
    }

    public void cleanupAirdropAt(Location location) {
        if (location == null || location.getWorld() == null) {
            return;
        }
        if (!this.plugin.isEnabled()) {
            this.cleanupAirdropNow(location);
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.cleanupAirdropNow(location));
    }

    private void cleanupAirdropNow(Location location) {
        Object object;
        Block block = location.getBlock();
        if (block.getType() == Material.CHEST && (object = block.getState()) instanceof Chest) {
            Chest chest = (Chest)object;
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getOpenInventory().getTopInventory().equals((Object)chest.getInventory())) continue;
                player.closeInventory();
            }
            try {
                chest.getInventory().clear();
                chest.getPersistentDataContainer().remove(this.unbreakableKey);
                chest.update();
                block.setType(Material.AIR);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to clear chest safely: " + e.getMessage());
            }
            this.particleManager.removeChest(block);
            this.hologramManager.removeHologram(location);
            this.lockManager.removeLock(location);
            this.activeAirdrops.remove(location);
            if (this.lastAirdropLocation != null && this.lastAirdropLocation.equals((Object)location)) {
                this.lastAirdropLocation = null;
            }
            String msgTemplate = this.plugin.getConfig().getString("messages.airdrop_despawned", "\u00a7eAirdrop at %x%, %z% has despawned.");
            String message = msgTemplate.replace("%x%", String.valueOf(location.getBlockX())).replace("%z%", String.valueOf(location.getBlockZ()));
            this.plugin.getServer().sendMessage((Component)Component.text((String)message));
        }
    }

    public boolean isProtectedChest(Chest chest) {
        return chest.getPersistentDataContainer().has(this.unbreakableKey, PersistentDataType.BYTE);
    }

    public boolean isChestLocked(Location location) {
        return this.lockManager.isLocked(location);
    }

    public Location getLastAirdropLocation() {
        return this.lastAirdropLocation;
    }

    private void announceAirdrop(Location location) {
        String biomeName = location.getBlock().getBiome().toString().replace('_', ' ').toLowerCase();
        Player nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Player p : this.plugin.getServer().getOnlinePlayers()) {
            if (!p.isOnline()) continue;
            try {
                double dist = p.getLocation().distance(location);
                if (!(dist < nearestDistance)) continue;
                nearestDistance = dist;
                nearest = p;
            }
            catch (IllegalArgumentException dist) {}
        }
        String msgTemplate = this.plugin.getConfig().getString("messages.airdrop_spawned", "\ud83d\udce6 Something has fallen in the %biome%, roughly %distance% blocks from you...");
        String locateHint = this.plugin.getConfig().getString("messages.airdrop_locate_hint", "\u00a7eUse /airdrop locate with a compass in your inventory to find it!");
        String msg = msgTemplate.replace("%distance%", nearest == null ? "some" : String.format("%.0f", nearestDistance)).replace("%biome%", biomeName);
        this.plugin.getServer().sendMessage((Component)Component.text((String)msg));
        this.plugin.getServer().sendMessage((Component)Component.text((String)locateHint));
    }

    private static class AirdropAnimation {
        private final AthiSAirdrops plugin;
        private BukkitTask animationTask;
        private ArmorStand currentDropStand;

        AirdropAnimation(AthiSAirdrops plugin) {
            this.plugin = plugin;
        }

        void start(final Location target, final Consumer<Location> onFinish) {
            this.stop();
            World world = target.getWorld();
            if (world == null) {
                return;
            }
            final Location startLoc = target.clone().add(0.0, 50.0, 0.0);
            this.currentDropStand = (ArmorStand)world.spawnEntity(startLoc, EntityType.ARMOR_STAND);
            this.currentDropStand.setInvisible(true);
            this.currentDropStand.setMarker(true);
            this.currentDropStand.setGravity(false);
            this.currentDropStand.setInvulnerable(true);
            this.currentDropStand.setCollidable(false);
            this.currentDropStand.getEquipment().setHelmet(new ItemStack(Material.CHEST));
            this.currentDropStand.setCustomNameVisible(false);
            double descentSpeed = 0.2;
            this.animationTask = new BukkitRunnable(){
                double currentY;
                {
                    this.currentY = startLoc.getY();
                }

                public void run() {
                    if (currentDropStand == null || currentDropStand.isDead()) {
                        this.cancel();
                        animationTask = null;
                        return;
                    }
                    this.currentY -= 0.2;
                    if (this.currentY <= target.getY()) {
                        if (currentDropStand != null) {
                            currentDropStand.remove();
                            currentDropStand = null;
                        }
                        try {
                            onFinish.accept(target);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.cancel();
                        animationTask = null;
                        return;
                    }
                    Location newLoc = currentDropStand.getLocation();
                    newLoc.setY(this.currentY);
                    currentDropStand.teleport(newLoc);
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 2L);
        }

        void stop() {
            if (this.animationTask != null) {
                this.animationTask.cancel();
                this.animationTask = null;
            }
            if (this.currentDropStand != null) {
                this.currentDropStand.remove();
                this.currentDropStand = null;
            }
        }
    }

    private static class ParticleManager {
        private final AthiSAirdrops plugin;
        private final Set<Block> activeChests = ConcurrentHashMap.newKeySet();
        private BukkitTask task;
        private int intervalTicks = 10;

        ParticleManager(AthiSAirdrops plugin) {
            this.plugin = plugin;
        }

        void setInterval(int ticks) {
            this.intervalTicks = Math.max(1, ticks);
            this.restartIfRunning();
        }

        void addChest(Block block) {
            if (block == null) {
                return;
            }
            this.activeChests.add(block);
            this.startIfNeeded();
        }

        void removeChest(Block block) {
            if (block == null) {
                return;
            }
            this.activeChests.remove(block);
            if (this.activeChests.isEmpty()) {
                this.stop();
            }
        }

        private void startIfNeeded() {
            if (this.task != null) {
                return;
            }
            this.task = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
                Iterator<Block> it = this.activeChests.iterator();
                while (it.hasNext()) {
                    Block b = it.next();
                    if (!(b.getState() instanceof Chest)) {
                        it.remove();
                        continue;
                    }
                    Location baseLoc = b.getLocation().clone().add(0.5, 1.0, 0.5);
                    b.getWorld().spawnParticle(Particle.CAMPFIRE_SIGNAL_SMOKE, baseLoc, 1, 0.0, 1.5, 0.0, 0.05);
                }
            }, 0L, (long)this.intervalTicks);
        }

        private void restartIfRunning() {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
                this.startIfNeeded();
            }
        }

        void stop() {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
            this.activeChests.clear();
        }
    }

    private static class AirdropLocationPicker {
        private final AthiSAirdrops plugin;
        private final Random random = new Random();

        AirdropLocationPicker(AthiSAirdrops plugin) {
            this.plugin = plugin;
        }

        Location pickRandomValidLocation(World world) {
            boolean onlyLoaded = this.plugin.getConfig().getBoolean("spawn_in_loaded_chunks_only", true);
            int radius = Math.max(10, this.plugin.getConfig().getInt("spawn_radius", 1000));
            int centerX = this.plugin.getConfig().getInt("center_x", world.getSpawnLocation().getBlockX());
            int centerZ = this.plugin.getConfig().getInt("center_z", world.getSpawnLocation().getBlockZ());
            int MAX_ATTEMPTS = this.plugin.getConfig().getInt("max_location_attempts", 100);
            if (onlyLoaded) {
                Chunk[] loaded = world.getLoadedChunks();
                if (loaded.length == 0) {
                    return null;
                }
                for (int attempts = 0; attempts < MAX_ATTEMPTS; ++attempts) {
                    Block below;
                    int bz;
                    int by;
                    Chunk c = loaded[this.random.nextInt(loaded.length)];
                    int bx = (c.getX() << 4) + this.random.nextInt(16);
                    Location loc = new Location(world, (double)bx + 0.5, (double)(by = world.getHighestBlockYAt(bx, bz = (c.getZ() << 4) + this.random.nextInt(16))) + 1.0, (double)bz + 0.5);
                    Block block = loc.getBlock();
                    if (!this.isValidSurface(block, below = loc.clone().subtract(0.0, 1.0, 0.0).getBlock())) continue;
                    return loc;
                }
                return null;
            }
            boolean loadIfGenerated = this.plugin.getConfig().getBoolean("load_generated_chunk_if_unloaded", false);
            for (int i = 0; i < MAX_ATTEMPTS; ++i) {
                Block below;
                int y;
                Location loc;
                Block block;
                int x = centerX + this.random.nextInt(radius * 2 + 1) - radius;
                int z = centerZ + this.random.nextInt(radius * 2 + 1) - radius;
                int chunkX = x >> 4;
                int chunkZ = z >> 4;
                boolean generated = false;
                try {
                    generated = world.isChunkGenerated(chunkX, chunkZ);
                }
                catch (NoSuchMethodError | UnsupportedOperationException ex) {
                    if (!world.isChunkLoaded(chunkX, chunkZ)) continue;
                    generated = true;
                }
                if (!generated) continue;
                if (!world.isChunkLoaded(chunkX, chunkZ)) {
                    if (!loadIfGenerated) continue;
                    world.getChunkAt(chunkX, chunkZ).load(true);
                }
                if (!this.isValidSurface(block = (loc = new Location(world, (double)x + 0.5, (double)(y = world.getHighestBlockYAt(x, z)) + 1.0, (double)z + 0.5)).getBlock(), below = loc.clone().subtract(0.0, 1.0, 0.0).getBlock())) continue;
                return loc;
            }
            return null;
        }

        private boolean isValidSurface(Block block, Block below) {
            if (block == null || below == null) {
                return false;
            }
            Material b = block.getType();
            Material bl = below.getType();
            if (b == Material.LAVA || b == Material.WATER) {
                return false;
            }
            if (bl == Material.LAVA || bl == Material.WATER) {
                return false;
            }
            return below.getType().isSolid();
        }
    }

    private static class AirdropLockManager {
        private final ConcurrentMap<BlockLocationKey, Long> unlockTimes = new ConcurrentHashMap<BlockLocationKey, Long>();

        private AirdropLockManager() {
        }

        void addLock(Location loc, long unlockAtMillis) {
            this.unlockTimes.put(BlockLocationKey.from(loc), unlockAtMillis);
        }

        boolean isLocked(Location loc) {
            Long at = (Long)this.unlockTimes.get(BlockLocationKey.from(loc));
            if (at == null) {
                return false;
            }
            if (System.currentTimeMillis() >= at) {
                this.unlockTimes.remove(BlockLocationKey.from(loc));
                return false;
            }
            return true;
        }

        void removeLock(Location loc) {
            this.unlockTimes.remove(BlockLocationKey.from(loc));
        }
    }

    private static class BlockLocationKey {
        final String world;
        final int x;
        final int y;
        final int z;

        BlockLocationKey(String world, int x, int y, int z) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        static BlockLocationKey from(Location l) {
            return new BlockLocationKey(l.getWorld().getName(), l.getBlockX(), l.getBlockY(), l.getBlockZ());
        }

        static BlockLocationKey from(Block b) {
            return new BlockLocationKey(b.getWorld().getName(), b.getX(), b.getY(), b.getZ());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BlockLocationKey)) {
                return false;
            }
            BlockLocationKey k = (BlockLocationKey)o;
            return this.x == k.x && this.y == k.y && this.z == k.z && this.world.equals(k.world);
        }

        public int hashCode() {
            return Objects.hash(this.world, this.x, this.y, this.z);
        }
    }
}

