/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import net.kyori.adventure.text.Component;
import org.athlantes.athiSAirdrops.AirdropManager;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AirdropCommand
implements CommandExecutor {
    private final AthiSAirdrops plugin;
    private final AirdropManager manager;

    public AirdropCommand(AthiSAirdrops plugin, AirdropManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            if (sender.hasPermission("athisairdrops.admin")) {
                sender.sendMessage((Component)Component.text((String)"\u00a7e Usage: /airdrop <locate|start|stop|spawn|reload|status>"));
            } else {
                sender.sendMessage((Component)Component.text((String)"\u00a7e Usage: /airdrop locate"));
            }
            return true;
        }
        String sub = args[0].toLowerCase();
        if (!sender.hasPermission("athisairdrops.admin")) {
            sender.sendMessage((Component)Component.text((String)this.plugin.getConfig().getString("messages.no_permission", "\u00a7c You don't have permission for this command.")));
            return true;
        }
        switch (sub) {
            case "start": {
                if (this.manager.isRunning()) {
                    sender.sendMessage((Component)Component.text((String)"\u00a7c Airdrop system already running."));
                } else {
                    this.manager.start();
                    sender.sendMessage((Component)Component.text((String)"\u00a7a Airdrop system started."));
                }
                return true;
            }
            case "stop": {
                if (!this.manager.isRunning()) {
                    sender.sendMessage((Component)Component.text((String)"\u00a7c Airdrop system not running."));
                } else {
                    this.manager.stop();
                    sender.sendMessage((Component)Component.text((String)"\u00a7a Airdrop system stopped."));
                }
                return true;
            }
            case "spawn": {
                if (args.length == 2) {
                    Player target = Bukkit.getPlayer((String)args[1]);
                    if (target == null) {
                        sender.sendMessage((Component)Component.text((String)"\u00a7c Player not found or offline."));
                    } else {
                        this.manager.spawnAt(target.getLocation());
                        sender.sendMessage((Component)Component.text((String)("\u00a7a Spawned airdrop at player " + target.getName())));
                    }
                    return true;
                }
                if (args.length == 4) {
                    try {
                        double x = Double.parseDouble(args[1]);
                        double y = Double.parseDouble(args[2]);
                        double z = Double.parseDouble(args[3]);
                        Location loc = new Location(Bukkit.getWorld((String)this.plugin.getConfig().getString("world", "world")), x, y, z);
                        this.manager.spawnAt(loc);
                        sender.sendMessage((Component)Component.text((String)("\u00a7a Spawned airdrop at " + x + ", " + y + ", " + z)));
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage((Component)Component.text((String)"\u00a7c Invalid coordinates."));
                    }
                    return true;
                }
                sender.sendMessage((Component)Component.text((String)"\u00a7e Usage: /airdrop spawn <player> OR /airdrop spawn <x> <y> <z>"));
                return true;
            }
            case "reload": {
                this.plugin.reloadConfig();
                this.manager.reload();
                sender.sendMessage((Component)Component.text((String)"\u00a7a Config and loot reloaded."));
                return true;
            }
            case "status": {
                sender.sendMessage((Component)Component.text((String)("\u00a76 Airdrop running: " + this.manager.isRunning())));
                return true;
            }
        }
        sender.sendMessage((Component)Component.text((String)"\u00a7e Unknown subcommand."));
        return true;
    }
}

