/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.athlantes.athiSAirdrops.AirdropManager;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class AirdropListeners
implements Listener {
    private final AthiSAirdrops plugin;
    private final AirdropManager manager;
    private final Map<UUID, Long> compassCooldowns = new HashMap<UUID, Long>();
    private static final long COMPASS_COOLDOWN_MS = 10000L;

    public AirdropListeners(AthiSAirdrops plugin, AirdropManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    @EventHandler
    public void onChestBreak(BlockBreakEvent event) {
        Chest chest;
        BlockState blockState = event.getBlock().getState();
        if (blockState instanceof Chest && this.manager.isProtectedChest(chest = (Chest)blockState)) {
            event.setCancelled(true);
            event.getPlayer().sendMessage((Component)Component.text((String)this.plugin.getConfig().getString("messages.chest_protected", "\u00a7cThis chest cannot be broken!")));
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity;
        long itemsLeft;
        Chest chest;
        Inventory inv = event.getInventory();
        InventoryHolder inventoryHolder = inv.getHolder();
        if (inventoryHolder instanceof Chest && this.manager.isProtectedChest(chest = (Chest)inventoryHolder) && (itemsLeft = Arrays.stream(inv.getContents()).filter(i -> i != null && i.getType() != Material.AIR).count()) <= 0L && (humanEntity = event.getPlayer()) instanceof Player) {
            Player player = (Player)humanEntity;
            player.sendMessage((Component)Component.text((String)this.plugin.getConfig().getString("messages.chest_empty_notice", "\u00a7eThat airdrop is empty.")));
        }
    }

    @EventHandler
    public void onCompassUse(PlayerInteractEvent event) {
        double playerYaw;
        double relativeAngle;
        double dz;
        long lastUse;
        long elapsed;
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (!event.getAction().toString().contains("RIGHT_CLICK")) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() != Material.COMPASS) {
            return;
        }
        UUID playerId = player.getUniqueId();
        long now = System.currentTimeMillis();
        if (this.compassCooldowns.containsKey(playerId) && (elapsed = now - (lastUse = this.compassCooldowns.get(playerId).longValue())) < 10000L) {
            long secondsLeft = (10000L - elapsed) / 1000L + 1L;
            player.sendMessage((Component)Component.text((String)("\u00a7cPlease wait " + secondsLeft + " seconds before using the compass again.")));
            event.setCancelled(true);
            return;
        }
        this.compassCooldowns.put(playerId, now);
        Location airdropLoc = this.manager.getLastAirdropLocation();
        if (airdropLoc == null) {
            player.sendMessage((Component)Component.text((String)"\u00a7eThere is no active airdrop currently."));
            event.setCancelled(true);
            return;
        }
        Location playerLoc = player.getLocation();
        double distance = playerLoc.distance(airdropLoc);
        double dx = airdropLoc.getX() - playerLoc.getX();
        double angleToAirdrop = Math.toDegrees(Math.atan2(-dx, dz = airdropLoc.getZ() - playerLoc.getZ()));
        if (angleToAirdrop < 0.0) {
            angleToAirdrop += 360.0;
        }
        String direction = (relativeAngle = (angleToAirdrop - (playerYaw = (double)((playerLoc.getYaw() + 360.0f) % 360.0f)) + 360.0) % 360.0) >= 337.5 || relativeAngle < 22.5 ? "ahead" : (relativeAngle < 67.5 ? "ahead-right" : (relativeAngle < 112.5 ? "right" : (relativeAngle < 157.5 ? "behind-right" : (relativeAngle < 202.5 ? "behind" : (relativeAngle < 247.5 ? "behind-left" : (relativeAngle < 292.5 ? "left" : "ahead-left"))))));
        player.sendMessage((Component)Component.text((String)("\u00a7aAirdrop is roughly " + (int)distance + " blocks " + direction + " from you.")));
        event.setCancelled(true);
    }

    @EventHandler
    public void onChestInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (block.getType() != Material.CHEST) {
            return;
        }
        Location loc = block.getLocation();
        if (this.manager.isChestLocked(loc)) {
            event.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "This airdrop chest is locked. Please wait a bit.");
            event.setCancelled(true);
        }
    }
}

