/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.bukkit.Material;
import org.bukkit.block.Chest;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AirdropLoot {
    private static final Random RANDOM = new Random();

    public static void fillChestWithLoot(AthiSAirdrops plugin, Chest chest) {
        int remaining;
        chest.getInventory().clear();
        File lootFile = new File(plugin.getDataFolder(), "loot.yml");
        YamlConfiguration lootConfig = YamlConfiguration.loadConfiguration((File)lootFile);
        String chosenTable = AirdropLoot.chooseLootTable((FileConfiguration)lootConfig);
        if (chosenTable == null) {
            plugin.getLogger().warning("No loot table selected. Please check loot.yml chances.");
            return;
        }
        ConfigurationSection lootTable = lootConfig.getConfigurationSection(chosenTable);
        if (lootTable == null) {
            plugin.getLogger().warning("Loot table section missing: " + chosenTable);
            return;
        }
        int minItems = plugin.getConfig().getInt("loot_count.min", 5);
        int maxItems = plugin.getConfig().getInt("loot_count.max", 10);
        int totalItemsToAdd = AirdropLoot.randomBetween(minItems, maxItems);
        int addedItems = 0;
        if (plugin.isItemsAdderEnabled() && lootTable.isConfigurationSection("itemsadder_loot")) {
            addedItems += AirdropLoot.fillWithItemsAdderLoot(plugin, chest, lootTable.getConfigurationSection("itemsadder_loot"), totalItemsToAdd);
        }
        if ((remaining = totalItemsToAdd - addedItems) > 0 && lootTable.isConfigurationSection("loot")) {
            AirdropLoot.fillWithVanillaLootRandomSlots(plugin, chest, lootTable.getConfigurationSection("loot"), remaining);
        }
        AirdropLoot.ensureAtLeastOneItem(plugin, chest, lootTable);
    }

    private static void ensureAtLeastOneItem(AthiSAirdrops plugin, Chest chest, ConfigurationSection lootTable) {
        int added;
        boolean chestIsEmpty = Arrays.stream(chest.getInventory().getContents()).allMatch(Objects::isNull);
        if (!chestIsEmpty) {
            return;
        }
        if (plugin.isItemsAdderEnabled() && lootTable.isConfigurationSection("itemsadder_loot") && (added = AirdropLoot.fillWithItemsAdderLoot(plugin, chest, lootTable.getConfigurationSection("itemsadder_loot"), 1)) > 0) {
            return;
        }
        if (lootTable.isConfigurationSection("loot")) {
            AirdropLoot.fillWithVanillaLootRandomSlots(plugin, chest, lootTable.getConfigurationSection("loot"), 1);
        }
    }

    private static String chooseLootTable(FileConfiguration lootCfg) {
        LinkedHashMap<String, Double> tableChances = new LinkedHashMap<String, Double>();
        double totalChance = 0.0;
        for (String tableName : lootCfg.getKeys(false)) {
            double chance = lootCfg.getDouble(tableName + ".chance", 1.0);
            if (!(chance > 0.0)) continue;
            tableChances.put(tableName, chance);
            totalChance += chance;
        }
        if (tableChances.isEmpty()) {
            return null;
        }
        double roll = RANDOM.nextDouble() * totalChance;
        for (Map.Entry entry : tableChances.entrySet()) {
            if (!((roll -= ((Double)entry.getValue()).doubleValue()) <= 0.0)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    private static int fillWithItemsAdderLoot(AthiSAirdrops plugin, Chest chest, ConfigurationSection iaSection, int maxItems) {
        int added = 0;
        try {
            Class<?> customStackClass = Class.forName("dev.lone.itemsadder.api.CustomStack");
            ArrayList keys = new ArrayList(iaSection.getKeys(false));
            Collections.shuffle(keys, RANDOM);
            for (String key : keys) {
                if (added < maxItems) {
                    Object customStack;
                    String id;
                    double chance = iaSection.getDouble(key + ".chance", 1.0);
                    if (RANDOM.nextDouble() > chance || (id = iaSection.getString(key + ".material")) == null || (customStack = customStackClass.getMethod("getInstance", String.class).invoke(null, id)) == null) continue;
                    ItemStack base = (ItemStack)customStackClass.getMethod("getItemStack", new Class[0]).invoke(customStack, new Object[0]);
                    int min = Math.max(1, iaSection.getInt(key + ".min", 1));
                    int max = Math.max(min, iaSection.getInt(key + ".max", min));
                    int weight = Math.max(1, iaSection.getInt(key + ".weight", 1));
                    base.setAmount(AirdropLoot.randomBetween(min, max));
                    for (int i = 0; i < weight && added < maxItems; ++added, ++i) {
                        chest.getInventory().addItem(new ItemStack[]{base.clone()});
                    }
                    continue;
                }
                break;
            }
        }
        catch (ClassNotFoundException e) {
            plugin.getLogger().info("ItemsAdder not found, skipping ItemsAdder custom loot.");
        }
        catch (Exception e) {
            plugin.getLogger().warning("Failed to load ItemsAdder custom loot: " + e.getMessage());
            e.printStackTrace();
        }
        return added;
    }

    private static void fillWithVanillaLootRandomSlots(AthiSAirdrops plugin, Chest chest, ConfigurationSection vanillaSection, int itemsToAdd) {
        ArrayList<ItemStack> pool = new ArrayList<ItemStack>();
        for (String key : vanillaSection.getKeys(false)) {
            Material mat;
            double chance = vanillaSection.getDouble(key + ".chance", 1.0);
            if (RANDOM.nextDouble() > chance || (mat = Material.matchMaterial((String)vanillaSection.getString(key + ".material", "STONE"))) == null) continue;
            int min = Math.max(1, vanillaSection.getInt(key + ".min", 1));
            int max = Math.max(min, vanillaSection.getInt(key + ".max", min));
            int weight = Math.max(1, vanillaSection.getInt(key + ".weight", 1));
            ItemStack base = new ItemStack(mat, AirdropLoot.randomBetween(min, max));
            if (vanillaSection.isConfigurationSection(key + ".enchantments")) {
                ItemMeta meta = base.getItemMeta();
                for (String enchKey : vanillaSection.getConfigurationSection(key + ".enchantments").getKeys(false)) {
                    Enchantment ench = Enchantment.getByName((String)enchKey.toUpperCase(Locale.ROOT));
                    if (ench == null) continue;
                    int level = Math.max(1, vanillaSection.getInt(key + ".enchantments." + enchKey, 1));
                    meta.addEnchant(ench, level, true);
                }
                base.setItemMeta(meta);
            }
            for (int i = 0; i < weight; ++i) {
                pool.add(base.clone());
            }
        }
        Collections.shuffle(pool, RANDOM);
        int size = chest.getInventory().getSize();
        HashSet<Integer> usedSlots = new HashSet<Integer>();
        int added = 0;
        block3: for (ItemStack item : pool) {
            if (added >= itemsToAdd) break;
            for (int tries = 0; tries < 40; ++tries) {
                int slot = RANDOM.nextInt(size);
                if (usedSlots.contains(slot)) continue;
                chest.getInventory().setItem(slot, item);
                usedSlots.add(slot);
                ++added;
                continue block3;
            }
        }
    }

    private static int randomBetween(int min, int max) {
        return max <= min ? min : min + RANDOM.nextInt(max - min + 1);
    }
}

