/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import org.athlantes.athiSAirdrops.AirdropLoot;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.athlantes.athiSAirdrops.HologramManager;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AirdropManager {
    private final AthiSAirdrops plugin;
    private final Random random = new Random();
    private BukkitTask animationTask = null;
    private ArmorStand currentDropStand = null;
    private BukkitTask repeatingTask;
    private Location lastAirdropLocation;
    private final Map<BlockLocationKey, BukkitTask> particleTasks = new ConcurrentHashMap<BlockLocationKey, BukkitTask>();
    private final HologramManager hologramManager;
    private final NamespacedKey unbreakableKey;
    private final Map<BlockLocationKey, Long> chestUnlockTimes = new ConcurrentHashMap<BlockLocationKey, Long>();

    public AirdropManager(AthiSAirdrops plugin) {
        this.plugin = plugin;
        this.hologramManager = new HologramManager((Plugin)plugin);
        this.unbreakableKey = new NamespacedKey((Plugin)plugin, "athis_unbreakable");
    }

    public void reload() {
    }

    public boolean isRunning() {
        return this.repeatingTask != null && !this.repeatingTask.isCancelled();
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        long intervalSeconds = Math.max(5L, this.plugin.getConfig().getLong("spawn_interval_seconds", 240L));
        this.repeatingTask = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, this::scheduledSpawnAttempt, 0L, intervalSeconds * 20L);
    }

    public void stop() {
        if (this.repeatingTask != null) {
            this.repeatingTask.cancel();
            this.repeatingTask = null;
        }
        if (this.lastAirdropLocation != null) {
            this.cleanupAirdropAt(this.lastAirdropLocation);
            this.lastAirdropLocation = null;
        }
        this.particleTasks.values().forEach(BukkitTask::cancel);
        this.particleTasks.clear();
        this.hologramManager.removeAll();
        this.stopAnimation();
    }

    private void scheduledSpawnAttempt() {
        World world = this.plugin.getServer().getWorld(this.plugin.getConfig().getString("world", "world"));
        if (world == null) {
            return;
        }
        Location loc = this.pickRandomValidLocation(world);
        if (loc != null) {
            this.spawn(loc);
        }
    }

    public void spawnAt(Location location) {
        if (location == null || location.getWorld() == null) {
            return;
        }
        Chunk chunk = location.getChunk();
        if (!chunk.isLoaded()) {
            chunk.load(true);
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (this.lastAirdropLocation != null) {
                this.cleanupAirdropAt(this.lastAirdropLocation);
                this.stopAnimation();
            }
            this.startAirdropAnimation(location);
        });
    }

    private void spawn(Location location) {
        if (location == null || location.getWorld() == null) {
            return;
        }
        Chunk chunk = location.getChunk();
        if (!chunk.isLoaded()) {
            chunk.load(true);
        }
        if (this.lastAirdropLocation != null) {
            this.cleanupAirdropAt(this.lastAirdropLocation);
        }
        this.stopAnimation();
        this.startAirdropAnimation(location);
    }

    private void startAirdropAnimation(final Location location) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        if (this.currentDropStand != null) {
            this.currentDropStand.remove();
            this.currentDropStand = null;
        }
        if (this.animationTask != null) {
            this.animationTask.cancel();
            this.animationTask = null;
        }
        final Location startLoc = location.clone().add(0.0, 50.0, 0.0);
        this.currentDropStand = (ArmorStand)world.spawnEntity(startLoc, EntityType.ARMOR_STAND);
        this.currentDropStand.setInvisible(true);
        this.currentDropStand.setMarker(true);
        this.currentDropStand.setGravity(false);
        this.currentDropStand.setInvulnerable(true);
        this.currentDropStand.setCollidable(false);
        this.currentDropStand.getEquipment().setHelmet(new ItemStack(Material.CHEST));
        this.currentDropStand.setCustomNameVisible(false);
        double descentSpeed = 0.1;
        this.animationTask = new BukkitRunnable(){
            double currentY;
            {
                this.currentY = startLoc.getY();
            }

            public void run() {
                if (AirdropManager.this.currentDropStand == null) {
                    this.cancel();
                    return;
                }
                this.currentY -= 0.1;
                if (this.currentY <= location.getY()) {
                    AirdropManager.this.currentDropStand.remove();
                    AirdropManager.this.currentDropStand = null;
                    AirdropManager.this.finishSpawn(location);
                    this.cancel();
                    AirdropManager.this.animationTask = null;
                    return;
                }
                Location newLoc = AirdropManager.this.currentDropStand.getLocation();
                newLoc.setY(this.currentY);
                AirdropManager.this.currentDropStand.teleport(newLoc);
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public void stopAnimation() {
        if (this.animationTask != null) {
            this.animationTask.cancel();
            this.animationTask = null;
        }
        if (this.currentDropStand != null) {
            this.currentDropStand.remove();
            this.currentDropStand = null;
        }
    }

    private void finishSpawn(Location location) {
        Block block = location.getBlock();
        boolean allowReplace = this.plugin.getConfig().getBoolean("replace_existing_block", false);
        if (!allowReplace && !block.getType().isAir()) {
            int y = location.getWorld().getHighestBlockYAt(location.getBlockX(), location.getBlockZ());
            location.setY((double)y + 1.0);
            block = location.getBlock();
            if (!block.getType().isAir()) {
                this.plugin.getLogger().info("Skipping spawn; target not air and replacement disabled.");
                return;
            }
        }
        block.setType(Material.CHEST);
        BlockState blockState = block.getState();
        if (!(blockState instanceof Chest)) {
            this.plugin.getLogger().warning("Failed to set chest at " + String.valueOf(location));
            return;
        }
        Chest chest = (Chest)blockState;
        chest.getPersistentDataContainer().set(this.unbreakableKey, PersistentDataType.BYTE, (Object)1);
        chest.update();
        AirdropLoot.fillChestWithLoot(this.plugin, chest);
        boolean chestIsEmpty = Arrays.stream(chest.getInventory().getContents()).allMatch(Objects::isNull);
        if (chestIsEmpty) {
            this.plugin.getLogger().info("Airdrop spawn aborted: chest would be empty at " + String.valueOf(location));
            block.setType(Material.AIR);
            return;
        }
        boolean lockAirdrop = this.plugin.getConfig().getBoolean("lock-airdrop", true);
        int unlockSeconds = lockAirdrop ? this.plugin.getConfig().getInt("time-before-unlock", 30) : 0;
        int despawnSeconds = this.plugin.getConfig().getInt("time-before-despawn", 120);
        if (lockAirdrop) {
            long unlockAt = System.currentTimeMillis() + (long)unlockSeconds * 1000L;
            this.chestUnlockTimes.put(BlockLocationKey.from(location), unlockAt);
        }
        this.startPersistentParticles(block);
        this.hologramManager.spawnHologram(location, chest, unlockSeconds, despawnSeconds, () -> {
            this.cleanupAirdropAt(location);
            String msgTemplate = this.plugin.getConfig().getString("messages.airdrop_despawned", "\u00a7eAirdrop at %x%, %z% has despawned.");
            String message = msgTemplate.replace("%x%", String.valueOf(location.getBlockX())).replace("%z%", String.valueOf(location.getBlockZ()));
            this.plugin.getServer().sendMessage((Component)Component.text((String)message));
        });
        this.lastAirdropLocation = location.clone();
        this.announceAirdrop(location);
    }

    private void cleanupAirdropAt(Location location) {
        BlockLocationKey key;
        BukkitTask ptask;
        if (location == null || location.getWorld() == null) {
            return;
        }
        Block block = location.getBlock();
        BlockState blockState = block.getState();
        if (blockState instanceof Chest) {
            Chest chest = (Chest)blockState;
            chest.getInventory().clear();
            chest.getPersistentDataContainer().remove(this.unbreakableKey);
            block.setType(Material.AIR);
        }
        if ((ptask = this.particleTasks.remove(key = BlockLocationKey.from(location))) != null) {
            ptask.cancel();
        }
        this.hologramManager.removeHologram(location);
        this.chestUnlockTimes.remove(BlockLocationKey.from(location));
        if (this.lastAirdropLocation != null && this.lastAirdropLocation.equals((Object)location)) {
            this.lastAirdropLocation = null;
        }
    }

    private void startPersistentParticles(Block block) {
        BlockLocationKey key = BlockLocationKey.from(block.getLocation());
        BukkitTask task = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!(block.getState() instanceof Chest)) {
                BukkitTask t = this.particleTasks.remove(key);
                if (t != null) {
                    t.cancel();
                }
                return;
            }
            Location baseLoc = block.getLocation().clone().add(0.5, 1.0, 0.5);
            block.getWorld().spawnParticle(Particle.CAMPFIRE_SIGNAL_SMOKE, baseLoc, 1, 0.0, 1.5, 0.0, 0.05);
        }, 0L, (long)Math.max(1, this.plugin.getConfig().getInt("particle_interval_ticks", 10)));
        this.particleTasks.put(key, task);
    }

    private void announceAirdrop(Location location) {
        String biomeName = location.getBlock().getBiome().toString().replace('_', ' ').toLowerCase();
        Player nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Player p : this.plugin.getServer().getOnlinePlayers()) {
            double dist = p.getLocation().distance(location);
            if (!(dist < nearestDistance)) continue;
            nearestDistance = dist;
            nearest = p;
        }
        String msgTemplate = this.plugin.getConfig().getString("messages.airdrop_spawned", "\ud83d\udce6 Something has fallen in the %biome%, roughly %distance% blocks from you...");
        String locateHint = this.plugin.getConfig().getString("messages.airdrop_locate_hint", "\u00a7eUse /airdrop locate with a compass in your inventory to find it!");
        String msg = msgTemplate.replace("%distance%", nearest == null ? "some" : String.format("%.0f", nearestDistance)).replace("%biome%", biomeName);
        this.plugin.getServer().sendMessage((Component)Component.text((String)msg));
        this.plugin.getServer().sendMessage((Component)Component.text((String)locateHint));
    }

    private Location pickRandomValidLocation(World world) {
        boolean onlyLoaded = this.plugin.getConfig().getBoolean("spawn_in_loaded_chunks_only", true);
        int radius = Math.max(10, this.plugin.getConfig().getInt("spawn_radius", 1000));
        int centerX = this.plugin.getConfig().getInt("center_x", world.getSpawnLocation().getBlockX());
        int centerZ = this.plugin.getConfig().getInt("center_z", world.getSpawnLocation().getBlockZ());
        int MAX_ATTEMPTS = this.plugin.getConfig().getInt("max_location_attempts", 100);
        if (onlyLoaded) {
            Chunk[] loaded = world.getLoadedChunks();
            if (loaded.length == 0) {
                return null;
            }
            for (int attempts = 0; attempts < MAX_ATTEMPTS; ++attempts) {
                Block below;
                int bz;
                int by;
                Chunk c = loaded[this.random.nextInt(loaded.length)];
                int bx = (c.getX() << 4) + this.random.nextInt(16);
                Location loc = new Location(world, (double)bx + 0.5, (double)(by = world.getHighestBlockYAt(bx, bz = (c.getZ() << 4) + this.random.nextInt(16))) + 1.0, (double)bz + 0.5);
                Block block = loc.getBlock();
                if (!this.isValidSurface(block, below = loc.clone().subtract(0.0, 1.0, 0.0).getBlock())) continue;
                return loc;
            }
            return null;
        }
        boolean loadIfGenerated = this.plugin.getConfig().getBoolean("load_generated_chunk_if_unloaded", false);
        for (int i = 0; i < MAX_ATTEMPTS; ++i) {
            Block below;
            int y;
            Location loc;
            Block block;
            int x = centerX + this.random.nextInt(radius * 2 + 1) - radius;
            int z = centerZ + this.random.nextInt(radius * 2 + 1) - radius;
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            boolean generated = false;
            try {
                generated = world.isChunkGenerated(chunkX, chunkZ);
            }
            catch (NoSuchMethodError | UnsupportedOperationException ex) {
                if (!world.isChunkLoaded(chunkX, chunkZ)) continue;
                generated = true;
            }
            if (!generated) continue;
            if (!world.isChunkLoaded(chunkX, chunkZ)) {
                if (!loadIfGenerated) continue;
                world.getChunkAt(chunkX, chunkZ).load(true);
            }
            if (!this.isValidSurface(block = (loc = new Location(world, (double)x + 0.5, (double)(y = world.getHighestBlockYAt(x, z)) + 1.0, (double)z + 0.5)).getBlock(), below = loc.clone().subtract(0.0, 1.0, 0.0).getBlock())) continue;
            return loc;
        }
        return null;
    }

    private boolean isValidSurface(Block block, Block below) {
        if (block == null || below == null) {
            return false;
        }
        Material b = block.getType();
        Material bl = below.getType();
        if (b == Material.LAVA || b == Material.WATER) {
            return false;
        }
        if (bl == Material.LAVA || bl == Material.WATER) {
            return false;
        }
        return below.getType().isSolid();
    }

    public boolean isProtectedChest(Chest chest) {
        return chest.getPersistentDataContainer().has(this.unbreakableKey, PersistentDataType.BYTE);
    }

    public boolean isChestLocked(Location location) {
        BlockLocationKey key = BlockLocationKey.from(location);
        Long unlockTime = this.chestUnlockTimes.get(key);
        if (unlockTime == null) {
            return false;
        }
        if (System.currentTimeMillis() >= unlockTime) {
            this.chestUnlockTimes.remove(key);
            return false;
        }
        return true;
    }

    public Location getLastAirdropLocation() {
        return this.lastAirdropLocation;
    }

    private static class BlockLocationKey {
        final String world;
        final int x;
        final int y;
        final int z;

        BlockLocationKey(String world, int x, int y, int z) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        static BlockLocationKey from(Location l) {
            return new BlockLocationKey(l.getWorld().getName(), l.getBlockX(), l.getBlockY(), l.getBlockZ());
        }

        static BlockLocationKey from(Block b) {
            return new BlockLocationKey(b.getWorld().getName(), b.getX(), b.getY(), b.getZ());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BlockLocationKey)) {
                return false;
            }
            BlockLocationKey k = (BlockLocationKey)o;
            return this.x == k.x && this.y == k.y && this.z == k.z && this.world.equals(k.world);
        }

        public int hashCode() {
            return Objects.hash(this.world, this.x, this.y, this.z);
        }
    }
}

