/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Chest;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class HologramManager {
    private final Plugin plugin;
    private final Map<BlockLocationKey, HologramData> holograms = new ConcurrentHashMap<BlockLocationKey, HologramData>();
    private final Method armorStandCustomNameComponent = this.findCustomNameComponentMethod();
    private final Set<Chunk> loadedChunks = Collections.newSetFromMap(new ConcurrentHashMap());

    public HologramManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public void spawnHologram(Location location, Chest chest, int unlockSeconds, int despawnSeconds, Runnable onEmpty) {
        if (location == null || location.getWorld() == null || chest == null) {
            return;
        }
        BlockLocationKey key = BlockLocationKey.from(location);
        this.removeHologram(location);
        Chunk chunk = location.getChunk();
        if (!chunk.isLoaded()) {
            chunk.load(true);
        }
        chunk.setForceLoaded(true);
        this.loadedChunks.add(chunk);
        int createDelay = Math.max(1, this.plugin.getConfig().getInt("hologram.create_delay_ticks", 2));
        int retries = Math.max(0, this.plugin.getConfig().getInt("hologram.spawn_retries", 3));
        long retryDelay = Math.max(1, this.plugin.getConfig().getInt("hologram.retry_delay_ticks", 10));
        this.plugin.getServer().getScheduler().runTaskLater(this.plugin, () -> {
            if (!location.getChunk().isLoaded()) {
                this.trySpawnWithRetries(location, chest, unlockSeconds, despawnSeconds, onEmpty, retries, retryDelay);
                return;
            }
            this.createHologramEntities(location, chest, unlockSeconds, despawnSeconds, onEmpty);
        }, (long)createDelay);
    }

    private void trySpawnWithRetries(Location location, Chest chest, int unlockSeconds, int despawnSeconds, Runnable onEmpty, int retries, long retryDelay) {
        if (retries <= 0) {
            this.plugin.getLogger().warning("Hologram spawn failed: chunk never loaded for " + String.valueOf(location));
            return;
        }
        this.plugin.getServer().getScheduler().runTaskLater(this.plugin, () -> {
            if (location.getChunk().isLoaded()) {
                this.createHologramEntities(location, chest, unlockSeconds, despawnSeconds, onEmpty);
            } else {
                this.trySpawnWithRetries(location, chest, unlockSeconds, despawnSeconds, onEmpty, retries - 1, retryDelay);
            }
        }, retryDelay);
    }

    private void createHologramEntities(Location location, Chest chest, int unlockSeconds, int despawnSeconds, Runnable onEmpty) {
        Location topLoc = location.clone().add(0.5, 1.9, 0.5);
        Location bottomLoc = location.clone().add(0.5, 1.6, 0.5);
        ArmorStand top = this.spawnArmorStand(topLoc);
        ArmorStand bottom = this.spawnArmorStand(bottomLoc);
        int[] unlockSecondsLeft = new int[]{unlockSeconds};
        int[] despawnSecondsLeft = new int[]{despawnSeconds};
        BlockLocationKey key = BlockLocationKey.from(location);
        BukkitTask task = this.plugin.getServer().getScheduler().runTaskTimer(this.plugin, () -> {
            TextComponent topComp;
            if (chest.getBlock().getType() != Material.CHEST) {
                this.removeHologram(location);
                return;
            }
            long itemsLeft = Arrays.stream(chest.getInventory().getContents()).filter(i -> i != null && i.getType() != Material.AIR).count();
            if (unlockSecondsLeft[0] > 0) {
                String leftTime = String.format("%d:%02d", unlockSecondsLeft[0] / 60, unlockSecondsLeft[0] % 60);
                topComp = Component.text((String)("\ud83d\udd12 Unlock in: " + leftTime));
                unlockSecondsLeft[0] = unlockSecondsLeft[0] - 1;
            } else {
                String leftTime = String.format("%d:%02d", despawnSecondsLeft[0] / 60, despawnSecondsLeft[0] % 60);
                topComp = Component.text((String)("\u23f3 Despawn in: " + leftTime));
                despawnSecondsLeft[0] = despawnSecondsLeft[0] - 1;
            }
            TextComponent bottomComp = Component.text((String)("\ud83c\udf81 Items Left: " + itemsLeft));
            this.setName(top, (Component)topComp);
            this.setName(bottom, (Component)bottomComp);
            if (itemsLeft <= 0L) {
                try {
                    onEmpty.run();
                }
                catch (Exception ex) {
                    this.plugin.getLogger().warning("onEmpty callback failed: " + ex.getMessage());
                }
                this.removeHologram(location);
                return;
            }
            if (unlockSecondsLeft[0] <= 0 && despawnSecondsLeft[0] < 0) {
                if (location.getBlock().getType() == Material.CHEST) {
                    location.getBlock().setType(Material.AIR);
                }
                this.removeHologram(location);
                String msgTemplate = this.plugin.getConfig().getString("messages.airdrop_despawned", "\u00a7eAirdrop at %x%, %z% has despawned.");
                String message = msgTemplate.replace("%x%", String.valueOf(location.getBlockX())).replace("%z%", String.valueOf(location.getBlockZ()));
                this.plugin.getServer().sendMessage((Component)Component.text((String)message));
            }
        }, 0L, 20L);
        this.holograms.put(key, new HologramData(task, List.of(top, bottom)));
    }

    public void removeHologram(Location location) {
        if (location == null || location.getWorld() == null) {
            return;
        }
        BlockLocationKey key = BlockLocationKey.from(location);
        HologramData data = this.holograms.remove(key);
        if (data == null) {
            return;
        }
        data.task.cancel();
        for (ArmorStand as : data.stands) {
            try {
                if (as == null || as.isDead()) continue;
                as.remove();
            }
            catch (Throwable throwable) {}
        }
        Chunk chunk = location.getChunk();
        if (this.loadedChunks.contains(chunk)) {
            this.loadedChunks.remove(chunk);
            chunk.setForceLoaded(false);
        }
    }

    public void removeAll() {
        for (BlockLocationKey k : new ArrayList<BlockLocationKey>(this.holograms.keySet())) {
            HologramData d = this.holograms.remove(k);
            if (d == null) continue;
            d.task.cancel();
            for (ArmorStand as : d.stands) {
                if (as == null || as.isDead()) continue;
                as.remove();
            }
        }
        this.holograms.clear();
    }

    private ArmorStand spawnArmorStand(Location loc) {
        ArmorStand as = (ArmorStand)loc.getWorld().spawnEntity(loc, EntityType.ARMOR_STAND);
        as.setVisible(false);
        as.setGravity(false);
        as.setMarker(true);
        as.setCustomNameVisible(true);
        as.setCollidable(false);
        try {
            as.setPersistent(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return as;
    }

    private void setName(ArmorStand as, Component comp) {
        try {
            if (this.armorStandCustomNameComponent != null) {
                this.armorStandCustomNameComponent.invoke((Object)as, comp);
            } else {
                String legacy = LegacyComponentSerializer.legacySection().serialize(comp);
                as.setCustomName(legacy);
            }
            as.setCustomNameVisible(true);
        }
        catch (Throwable t) {
            try {
                String legacy = LegacyComponentSerializer.legacySection().serialize(comp);
                as.setCustomName(legacy);
                as.setCustomNameVisible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private Method findCustomNameComponentMethod() {
        try {
            Method m = ArmorStand.class.getMethod("customName", Component.class);
            m.setAccessible(true);
            return m;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static class BlockLocationKey {
        final String world;
        final int x;
        final int y;
        final int z;

        BlockLocationKey(String world, int x, int y, int z) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        static BlockLocationKey from(Location l) {
            return new BlockLocationKey(l.getWorld().getName(), l.getBlockX(), l.getBlockY(), l.getBlockZ());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BlockLocationKey)) {
                return false;
            }
            BlockLocationKey k = (BlockLocationKey)o;
            return this.x == k.x && this.y == k.y && this.z == k.z && this.world.equals(k.world);
        }

        public int hashCode() {
            return Objects.hash(this.world, this.x, this.y, this.z);
        }
    }

    private static class HologramData {
        final BukkitTask task;
        final List<ArmorStand> stands;

        HologramData(BukkitTask t, List<ArmorStand> s) {
            this.task = t;
            this.stands = s;
        }
    }
}

