/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.athlantes.athiSAirdrops.AirdropManager;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.athlantes.athiSAirdrops.Messages;
import org.athlantes.athiSAirdrops.SilentCommandSender;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class AirdropListeners
implements Listener {
    private final AthiSAirdrops plugin;
    private final AirdropManager manager;
    private final Map<UUID, Long> compassCooldowns = new HashMap<UUID, Long>();
    private final Map<UUID, Map<String, Long>> commandCooldowns = new HashMap<UUID, Map<String, Long>>();

    public AirdropListeners(AthiSAirdrops plugin, AirdropManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    private long getCompassCooldownMs() {
        return (long)this.plugin.getConfig().getInt("compass-cooldown", 10) * 1000L;
    }

    @EventHandler
    public void onChestBreak(BlockBreakEvent event) {
        Chest chest;
        BlockState blockState = event.getBlock().getState();
        if (blockState instanceof Chest && this.manager.isProtectedChest(chest = (Chest)blockState)) {
            event.setCancelled(true);
            Messages.send((CommandSender)event.getPlayer(), "messages.chest_protected", new String[0]);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof Chest)) {
            return;
        }
        Chest chest = (Chest)inventoryHolder;
        if (!this.manager.isProtectedChest(chest)) {
            return;
        }
        boolean empty = Arrays.stream(event.getInventory().getContents()).allMatch(i -> i == null || i.getType() == Material.AIR);
        if (empty && event.getPlayer() instanceof Player) {
            Chest c;
            boolean stillEmpty;
            BlockState blockState;
            Messages.send((CommandSender)event.getPlayer(), "messages.chest_empty_notice", new String[0]);
            Location loc = chest.getLocation();
            Block block = loc.getBlock();
            if (block.getType() == Material.CHEST && (blockState = block.getState()) instanceof Chest && (stillEmpty = Arrays.stream((c = (Chest)blockState).getInventory().getContents()).allMatch(i -> i == null || i.getType() == Material.AIR))) {
                this.manager.cleanupAirdropAt(loc, false);
            }
        }
    }

    @EventHandler
    public void onCompassUse(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (!event.getAction().toString().contains("RIGHT_CLICK")) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() != Material.COMPASS) {
            return;
        }
        boolean compassEnabled = this.plugin.getConfig().getBoolean("enable-compass", true);
        if (!compassEnabled) {
            return;
        }
        UUID id = player.getUniqueId();
        long now = System.currentTimeMillis();
        Long lastUse = this.compassCooldowns.get(id);
        long cooldownMs = this.getCompassCooldownMs();
        if (lastUse != null && now - lastUse < cooldownMs) {
            long secondsLeft = (cooldownMs - (now - lastUse)) / 1000L + 1L;
            Messages.send((CommandSender)player, "messages.compass_cooldown", "%seconds%", String.valueOf(secondsLeft));
            event.setCancelled(true);
            return;
        }
        this.compassCooldowns.put(id, now);
        Set<Location> activeAirdrops = this.manager.getAllVisibleAirdrops();
        List<Location> sameWorldAirdrops = activeAirdrops.stream().filter(loc -> loc.getWorld() != null && loc.getWorld().equals((Object)player.getWorld())).toList();
        if (sameWorldAirdrops.isEmpty()) {
            Messages.send((CommandSender)player, "messages.no_active_airdrop", new String[0]);
            event.setCancelled(true);
            return;
        }
        Location nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Location loc2 : sameWorldAirdrops) {
            try {
                double dist = player.getLocation().distance(loc2);
                if (!(dist < nearestDistance)) continue;
                nearestDistance = dist;
                nearest = loc2;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (nearest == null) {
            Messages.send((CommandSender)player, "messages.no_active_airdrop", new String[0]);
            event.setCancelled(true);
            return;
        }
        player.setCompassTarget(nearest);
        String direction = this.calculateDirection(player, nearest);
        Messages.send((CommandSender)player, "messages.compass_location", "%distance%", String.valueOf((int)nearestDistance), "%direction%", direction);
        event.setCancelled(true);
    }

    private String calculateDirection(Player player, Location target) {
        double playerYaw;
        double relAngle;
        double dz;
        double dx = target.getX() - player.getLocation().getX();
        double angle = Math.toDegrees(Math.atan2(-dx, dz = target.getZ() - player.getLocation().getZ()));
        if (angle < 0.0) {
            angle += 360.0;
        }
        if ((relAngle = (angle - (playerYaw = (double)((player.getLocation().getYaw() + 360.0f) % 360.0f)) + 360.0) % 360.0) >= 337.5 || relAngle < 22.5) {
            return "ahead";
        }
        if (relAngle < 67.5) {
            return "ahead-right";
        }
        if (relAngle < 112.5) {
            return "right";
        }
        if (relAngle < 157.5) {
            return "behind-right";
        }
        if (relAngle < 202.5) {
            return "behind";
        }
        if (relAngle < 247.5) {
            return "behind-left";
        }
        if (relAngle < 292.5) {
            return "left";
        }
        return "ahead-left";
    }

    @EventHandler
    public void onChestInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null || event.getClickedBlock().getType() != Material.CHEST) {
            return;
        }
        Location loc = event.getClickedBlock().getLocation();
        if (this.manager.isChestLocked(loc)) {
            Messages.send((CommandSender)event.getPlayer(), "messages.chest_locked", new String[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerUse(PlayerInteractEvent event) {
        if (!event.getAction().toString().contains("RIGHT_CLICK")) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        NamespacedKey keyCmd = new NamespacedKey((Plugin)this.plugin, "reward_command");
        if (meta.getPersistentDataContainer().has(keyCmd, PersistentDataType.STRING)) {
            String joinedCmds = (String)meta.getPersistentDataContainer().get(keyCmd, PersistentDataType.STRING);
            Player player = event.getPlayer();
            if (joinedCmds == null || joinedCmds.isBlank()) {
                return;
            }
            NamespacedKey keyId = new NamespacedKey((Plugin)this.plugin, "reward_id");
            String rewardId = null;
            if (meta.getPersistentDataContainer().has(keyId, PersistentDataType.STRING)) {
                rewardId = (String)meta.getPersistentDataContainer().get(keyId, PersistentDataType.STRING);
            }
            String cooldownKey = rewardId != null && !rewardId.isBlank() ? rewardId : joinedCmds;
            NamespacedKey keyExec = new NamespacedKey((Plugin)this.plugin, "reward_executor");
            NamespacedKey keyPerm = new NamespacedKey((Plugin)this.plugin, "reward_permission");
            NamespacedKey keyConsume = new NamespacedKey((Plugin)this.plugin, "reward_consume");
            NamespacedKey keyCooldown = new NamespacedKey((Plugin)this.plugin, "reward_cooldown");
            NamespacedKey keySilent = new NamespacedKey((Plugin)this.plugin, "reward_silent");
            String executor = "console";
            if (meta.getPersistentDataContainer().has(keyExec, PersistentDataType.STRING)) {
                executor = (String)meta.getPersistentDataContainer().get(keyExec, PersistentDataType.STRING);
            }
            String permission = "";
            if (meta.getPersistentDataContainer().has(keyPerm, PersistentDataType.STRING)) {
                permission = (String)meta.getPersistentDataContainer().get(keyPerm, PersistentDataType.STRING);
            }
            boolean consumeOnUse = true;
            if (meta.getPersistentDataContainer().has(keyConsume, PersistentDataType.BYTE)) {
                Byte b = (Byte)meta.getPersistentDataContainer().get(keyConsume, PersistentDataType.BYTE);
                consumeOnUse = b != null && b != 0;
            }
            int cooldownSeconds = 0;
            if (meta.getPersistentDataContainer().has(keyCooldown, PersistentDataType.INTEGER)) {
                Integer c = (Integer)meta.getPersistentDataContainer().get(keyCooldown, PersistentDataType.INTEGER);
                cooldownSeconds = c != null ? c : 0;
            }
            boolean silent = false;
            if (meta.getPersistentDataContainer().has(keySilent, PersistentDataType.BYTE)) {
                Byte sb = (Byte)meta.getPersistentDataContainer().get(keySilent, PersistentDataType.BYTE);
                boolean bl = silent = sb != null && sb != 0;
            }
            if (permission != null && !permission.isBlank() && !player.hasPermission(permission)) {
                player.sendMessage(Component.text((String)"You do not have permission to redeem this item.").color((TextColor)NamedTextColor.RED));
                event.setCancelled(true);
                return;
            }
            if (cooldownSeconds > 0) {
                UUID uuid = player.getUniqueId();
                long now = System.currentTimeMillis();
                Map m = this.commandCooldowns.computeIfAbsent(uuid, k -> new HashMap());
                Long last = (Long)m.get(cooldownKey);
                if (last != null && now - last < (long)cooldownSeconds * 1000L) {
                    long secondsLeft = ((long)cooldownSeconds * 1000L - (now - last)) / 1000L + 1L;
                    player.sendMessage(Component.text((String)("This voucher is on cooldown for " + secondsLeft + "s.")).color((TextColor)NamedTextColor.RED));
                    event.setCancelled(true);
                    return;
                }
            }
            String[] cmds = joinedCmds.split("\\n");
            Player execSenderPlayer = player;
            ConsoleCommandSender execSenderConsole = Bukkit.getConsoleSender();
            Object senderForPlayer = silent ? new SilentCommandSender((CommandSender)execSenderPlayer) : execSenderPlayer;
            Object senderForConsole = silent ? new SilentCommandSender((CommandSender)execSenderConsole) : execSenderConsole;
            for (String c : cmds) {
                if (c == null || c.isBlank()) continue;
                String finalCmd = c.replace("%player%", player.getName());
                try {
                    if (executor != null && executor.equalsIgnoreCase("player")) {
                        Bukkit.dispatchCommand((CommandSender)senderForPlayer, (String)finalCmd);
                        continue;
                    }
                    Bukkit.dispatchCommand((CommandSender)senderForConsole, (String)finalCmd);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (cooldownSeconds > 0) {
                UUID uuid = player.getUniqueId();
                Map m = this.commandCooldowns.computeIfAbsent(uuid, k -> new HashMap());
                m.put(cooldownKey, System.currentTimeMillis());
            }
            if (consumeOnUse) {
                int amt = Math.max(0, item.getAmount() - 1);
                item.setAmount(amt);
            }
            player.sendMessage(Component.text((String)"You redeemed your reward!").color((TextColor)NamedTextColor.GREEN));
            event.setCancelled(true);
        }
    }
}

