/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.block.Block;

public final class BlockLocationKey {
    public final String world;
    public final int x;
    public final int y;
    public final int z;

    public BlockLocationKey(String world, int x, int y, int z) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static BlockLocationKey from(Location l) {
        return new BlockLocationKey(l.getWorld().getName(), l.getBlockX(), l.getBlockY(), l.getBlockZ());
    }

    public static BlockLocationKey from(Block b) {
        return new BlockLocationKey(b.getWorld().getName(), b.getX(), b.getY(), b.getZ());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockLocationKey)) {
            return false;
        }
        BlockLocationKey k = (BlockLocationKey)o;
        return this.x == k.x && this.y == k.y && this.z == k.z && this.world.equals(k.world);
    }

    public int hashCode() {
        return Objects.hash(this.world, this.x, this.y, this.z);
    }

    public String toString() {
        return "BlockLocationKey{world='" + this.world + "', x=" + this.x + ", y=" + this.y + ", z=" + this.z + "}";
    }
}

