/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.athiSAirdrops;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.athlantes.athiSAirdrops.AirdropLoot;
import org.athlantes.athiSAirdrops.AthiSAirdrops;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Chest;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CommandLootProvider
implements AirdropLoot.LootProvider {
    private static final Random RANDOM = new Random();
    private final AthiSAirdrops plugin;
    private static final LegacyComponentSerializer LEGACY = LegacyComponentSerializer.legacyAmpersand();

    public CommandLootProvider(AthiSAirdrops plugin) {
        this.plugin = plugin;
    }

    @Override
    public ConfigurationSection getSection(ConfigurationSection lootTable) {
        return lootTable.getConfigurationSection("commands");
    }

    @Override
    public int fillChest(Chest chest, ConfigurationSection section, int maxItems) {
        if (section == null) {
            return 0;
        }
        int added = 0;
        for (String key : section.getKeys(false)) {
            int amount;
            ItemStack item;
            ItemMeta meta;
            List cmdList;
            if (added >= maxItems) break;
            double chance = section.getDouble(key + ".chance", 1.0);
            if (RANDOM.nextDouble() > chance) continue;
            ArrayList<String> commands = new ArrayList<String>();
            String singleCmd = section.getString(key + ".command");
            if (singleCmd != null && !singleCmd.isBlank()) {
                commands.add(singleCmd);
            }
            if (!(cmdList = section.getStringList(key + ".commands")).isEmpty()) {
                commands.addAll(cmdList.stream().filter(s -> s != null && !s.isBlank()).toList());
            }
            if (commands.isEmpty()) continue;
            String displayName = section.getString(key + ".name", "&aReward Voucher");
            List loreCfg = section.getStringList(key + ".lore");
            String materialCfg = section.getString(key + ".material", "PAPER");
            Material mat = Material.matchMaterial((String)materialCfg);
            if (mat == null) {
                mat = Material.PAPER;
            }
            if ((meta = (item = new ItemStack(mat, amount = Math.max(1, section.getInt(key + ".amount", 1)))).getItemMeta()) != null) {
                TextComponent nameComp = LEGACY.deserialize(displayName);
                try {
                    meta.displayName((Component)nameComp);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                List<Object> lore = new ArrayList<TextComponent>();
                if (!loreCfg.isEmpty()) {
                    lore = loreCfg.stream().map(s -> LEGACY.deserialize(s)).toList();
                } else {
                    lore.add(LEGACY.deserialize("&7Right Click to redeem"));
                }
                try {
                    meta.lore(lore);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (section.contains(key + ".custom-model-data")) {
                    int cmd = section.getInt(key + ".custom-model-data", 0);
                    try {
                        meta.setCustomModelData(Integer.valueOf(cmd));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                String executor = section.getString(key + ".executor", "console");
                String permission = section.getString(key + ".permission", "");
                boolean consumeOnUse = section.getBoolean(key + ".consume_on_use", true);
                int cooldown = section.getInt(key + ".cooldown_seconds", 0);
                boolean silent = section.getBoolean(key + ".silent", false);
                NamespacedKey keyCmd = new NamespacedKey((Plugin)this.plugin, "reward_command");
                NamespacedKey keyExec = new NamespacedKey((Plugin)this.plugin, "reward_executor");
                NamespacedKey keyPerm = new NamespacedKey((Plugin)this.plugin, "reward_permission");
                NamespacedKey keyConsume = new NamespacedKey((Plugin)this.plugin, "reward_consume");
                NamespacedKey keyCooldown = new NamespacedKey((Plugin)this.plugin, "reward_cooldown");
                NamespacedKey keyId = new NamespacedKey((Plugin)this.plugin, "reward_id");
                NamespacedKey keySilent = new NamespacedKey((Plugin)this.plugin, "reward_silent");
                String joinedCmds = String.join((CharSequence)"\n", commands);
                meta.getPersistentDataContainer().set(keyCmd, PersistentDataType.STRING, (Object)joinedCmds);
                meta.getPersistentDataContainer().set(keyExec, PersistentDataType.STRING, (Object)executor);
                if (!permission.isBlank()) {
                    meta.getPersistentDataContainer().set(keyPerm, PersistentDataType.STRING, (Object)permission);
                }
                meta.getPersistentDataContainer().set(keyConsume, PersistentDataType.BYTE, (Object)((byte)(consumeOnUse ? 1 : 0)));
                if (cooldown > 0) {
                    meta.getPersistentDataContainer().set(keyCooldown, PersistentDataType.INTEGER, (Object)cooldown);
                }
                meta.getPersistentDataContainer().set(keySilent, PersistentDataType.BYTE, (Object)((byte)(silent ? 1 : 0)));
                String uuid = UUID.randomUUID().toString();
                meta.getPersistentDataContainer().set(keyId, PersistentDataType.STRING, (Object)uuid);
                item.setItemMeta(meta);
            }
            chest.getInventory().addItem(new ItemStack[]{item});
            ++added;
        }
        return added;
    }
}

