/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess;

import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import lombok.Generated;
import net.minecraft.class_1934;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_3675;
import net.minecraft.class_4065;
import net.minecraft.class_6599;
import net.minecraft.class_746;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.util.Strings;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.features.AutoLibrarySetup;
import org.mcaccess.minecraftaccess.features.BiomeIndicator;
import org.mcaccess.minecraftaccess.features.CameraControls;
import org.mcaccess.minecraftaccess.features.FacingDirection;
import org.mcaccess.minecraftaccess.features.FallDetector;
import org.mcaccess.minecraftaccess.features.FluidDetector;
import org.mcaccess.minecraftaccess.features.HUDStatus;
import org.mcaccess.minecraftaccess.features.MenuFix;
import org.mcaccess.minecraftaccess.features.MouseKeySimulation;
import org.mcaccess.minecraftaccess.features.NarrateHeldItem;
import org.mcaccess.minecraftaccess.features.PlayerStatus;
import org.mcaccess.minecraftaccess.features.PlayerWarnings;
import org.mcaccess.minecraftaccess.features.PositionNarrator;
import org.mcaccess.minecraftaccess.features.XPIndicator;
import org.mcaccess.minecraftaccess.features.access_menu.AccessMenu;
import org.mcaccess.minecraftaccess.features.inventory_controls.InventoryControls;
import org.mcaccess.minecraftaccess.features.narrate_crosshair.NarrateCrosshair;
import org.mcaccess.minecraftaccess.features.point_of_interest.POIManager;
import org.mcaccess.minecraftaccess.mixin.GameNarratorAccessor;
import org.mcaccess.minecraftaccess.screen_reader.ScreenReaderController;
import org.mcaccess.minecraftaccess.screen_reader.ScreenReaderInterface;
import org.mcaccess.minecraftaccess.utils.KeyBindingsHandler;
import org.mcaccess.minecraftaccess.utils.condition.Keystroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MainClass {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MainClass.class);
    private static final class_310 CLIENT = class_310.method_1551();
    public static final String MOD_ID = "minecraft_access";
    private static ScreenReaderInterface screenReader = null;
    public static AccessMenu accessMenu = null;
    public static BiomeIndicator biomeIndicator = null;
    public static FacingDirection facingDirection = null;
    public static FallDetector fallDetector = null;
    public static FluidDetector fluidDetector = null;
    public static HUDStatus hudStatus = null;
    public static InventoryControls inventoryControls = null;
    public static NarrateCrosshair narrateCrosshair = null;
    public static NarrateHeldItem narrateHeldItem = null;
    public static PlayerStatus playerStatus = null;
    public static PlayerWarnings playerWarnings = null;
    public static POIManager poiManager = null;
    public static XPIndicator xpIndicator = null;

    private MainClass() {
    }

    public static void init() {
        Config.init();
        String startupMessage = "Initializing Minecraft Access: version " + Platform.getMod((String)MOD_ID).getVersion();
        log.info(startupMessage);
        new AutoLibrarySetup().initialize();
        ScreenReaderController.refreshScreenReader();
        if (MainClass.getScreenReader() != null && MainClass.getScreenReader().isInitialized()) {
            MainClass.getScreenReader().narrate(startupMessage, true);
        }
        for (KeyBindingsHandler.Keys key : KeyBindingsHandler.Keys.values()) {
            KeyMappingRegistry.register((class_304)key.mapping);
        }
        ClientTickEvent.CLIENT_POST.register(MainClass::clientTickEventsMethod);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(MainClass::initWorldState);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (MainClass.getScreenReader() != null && MainClass.getScreenReader().isInitialized()) {
                MainClass.getScreenReader().closeScreenReader();
            }
        }, "Shutdown-thread"));
    }

    public static void clientTickEventsMethod(class_310 client) {
        Config config = Config.getInstance();
        MainClass.changeLogLevelBaseOnDebugConfig();
        if (config.menuFixEnabled) {
            MenuFix.tick(client);
        }
        if (client.field_1687 == null || client.field_1724 == null) {
            Keystroke.updateInstances();
            return;
        }
        narrateCrosshair.tick();
        facingDirection.tick();
        PositionNarrator.getINSTANCE().tick();
        poiManager.tick();
        fallDetector.tick();
        hudStatus.tick();
        if (client.field_1755 == null || !(client.field_1755.method_25399() instanceof class_342) && !(client.field_1755 instanceof class_6599)) {
            MouseKeySimulation.tick();
        }
        if (inventoryControls != null && config.inventoryControls.enabled) {
            inventoryControls.tick();
        }
        assert (client.field_1761 != null);
        class_1934 mode = client.field_1761.method_2920();
        if (xpIndicator != null && config.features.xpIndicatorEnabled && (mode == class_1934.field_9215 || mode == class_1934.field_9216)) {
            xpIndicator.tick();
        }
        if (biomeIndicator != null && config.features.biomeIndicatorEnabled) {
            biomeIndicator.tick();
        }
        if (playerStatus != null) {
            playerStatus.tick();
        }
        if (client.field_1755 == null) {
            CameraControls.tick();
        }
        if (playerWarnings != null) {
            if (config.playerWarnings.enabled && (mode == class_1934.field_9215 || mode == class_1934.field_9216)) {
                playerWarnings.tick();
            }
            if (config.playerWarnings.durabilityWarnings.enableHeldItems || config.playerWarnings.durabilityWarnings.enableWornArmor) {
                playerWarnings.durabilityWarnings();
            }
        }
        if (accessMenu != null && config.accessMenu.enabled) {
            accessMenu.tick();
        }
        if (mode != class_1934.field_9219) {
            narrateHeldItem.tick();
        }
        Keystroke.updateInstances();
    }

    private static void initWorldState(class_746 player) {
        accessMenu = new AccessMenu();
        biomeIndicator = new BiomeIndicator();
        facingDirection = new FacingDirection();
        fallDetector = new FallDetector();
        fluidDetector = new FluidDetector();
        hudStatus = new HUDStatus();
        inventoryControls = new InventoryControls();
        narrateCrosshair = new NarrateCrosshair();
        narrateHeldItem = new NarrateHeldItem();
        playerStatus = new PlayerStatus();
        playerWarnings = new PlayerWarnings();
        poiManager = new POIManager();
        xpIndicator = new XPIndicator();
        if (MainClass.CLIENT.field_1690.field_1844.method_1435(KeyBindingsHandler.Keys.CAMERA_CONTROLS_RIGHT.mapping)) {
            MainClass.CLIENT.field_1690.field_1844.method_1422(class_3675.class_307.field_1668.method_1447(79));
            MainClass.CLIENT.field_1690.method_1640();
            MainClass.CLIENT.field_1690.method_1636();
            log.info("Rebound advancements key");
        }
    }

    private static void changeLogLevelBaseOnDebugConfig() {
        boolean debugMode;
        boolean bl = debugMode = Config.getInstance().debugMode || Platform.isDevelopmentEnvironment();
        if (debugMode) {
            if (!log.isDebugEnabled()) {
                Configurator.setLevel((String)"org.mcaccess.minecraftaccess", (Level)Level.DEBUG);
            }
        } else if (log.isDebugEnabled()) {
            Configurator.setLevel((String)"org.mcaccess.minecraftaccess", (Level)Level.INFO);
        }
    }

    public static void setScreenReader(ScreenReaderInterface screenReader) {
        MainClass.screenReader = screenReader;
    }

    public static void narrate(String text, boolean interrupt) {
        if (Strings.isEmpty((CharSequence)text) || !CLIENT.method_1569()) {
            log.warn("The narration of string \"{}\" with interrupt={} was suppressed", (Object)text, (Object)interrupt);
            return;
        }
        if (MainClass.CLIENT.field_1690.method_42476().method_41753() != class_4065.field_18176) {
            ((GameNarratorAccessor)CLIENT.method_44713()).invokeNarrateMessage(text, interrupt);
        }
    }

    @Generated
    public static ScreenReaderInterface getScreenReader() {
        return screenReader;
    }
}

