/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features;

import java.time.Clock;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import lombok.Generated;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.mcaccess.minecraftaccess.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallDetector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FallDetector.class);
    private final Clock clock;
    private long previousTimeInMillis;
    private final class_310 client = class_310.method_1551();
    private int count;
    private Config.FallDetector config;

    public FallDetector() {
        this.clock = Clock.systemDefaultZone();
        this.previousTimeInMillis = this.clock.millis();
        this.config = Config.getInstance().fallDetector;
    }

    public void tick() {
        this.config = Config.getInstance().fallDetector;
        if (!this.config.enabled) {
            return;
        }
        if (this.client.field_1724 == null) {
            return;
        }
        if (this.client.field_1755 != null) {
            return;
        }
        if (!this.client.field_1724.method_24828()) {
            return;
        }
        if (this.client.field_1724.method_5869()) {
            return;
        }
        if (this.client.field_1724.method_5681()) {
            return;
        }
        if (this.client.field_1724.method_20232()) {
            return;
        }
        long currentTimeInMillis = this.clock.millis();
        if (currentTimeInMillis - this.previousTimeInMillis < (long)this.config.delay) {
            return;
        }
        this.previousTimeInMillis = currentTimeInMillis;
        log.trace("Searching for fall in nearby area...");
        this.searchNearbyPositions();
        log.trace("Searching ended");
    }

    private void searchNearbyPositions() {
        if (this.client.field_1687 == null) {
            return;
        }
        assert (this.client.field_1724 != null);
        class_2338 center = this.client.field_1724.method_24515();
        LinkedList<class_2338> toSearch = new LinkedList<class_2338>();
        HashSet<class_2338> searched = new HashSet<class_2338>();
        int[] dirX = new int[]{-1, 0, 1, 0};
        int[] dirZ = new int[]{0, 1, 0, -1};
        this.count = 0;
        toSearch.add(center);
        searched.add(center);
        while (!toSearch.isEmpty()) {
            class_2338 item = (class_2338)toSearch.poll();
            this.checkForFall(item);
            for (int i = 0; i < 4; ++i) {
                class_2338 dir = new class_2338(item.method_10263() + dirX[i], item.method_10264(), item.method_10260() + dirZ[i]);
                if (!this.isValid(dir, center, searched)) continue;
                toSearch.add(dir);
                searched.add(dir);
            }
        }
    }

    private boolean isValid(class_2338 dir, class_2338 center, Set<class_2338> searched) {
        if (Math.abs(dir.method_10263() - center.method_10263()) > this.config.range) {
            return false;
        }
        if (Math.abs(dir.method_10260() - center.method_10260()) > this.config.range) {
            return false;
        }
        return !searched.contains(dir);
    }

    private void checkForFall(class_2338 toCheck) {
        assert (this.client.field_1687 != null);
        if (!this.client.field_1687.method_8320(toCheck).method_26215()) {
            return;
        }
        if (this.getDepth(toCheck, this.config.depth) < this.config.depth) {
            return;
        }
        ++this.count;
        log.debug("{}) Found qualified fall position: x:{} y:{} z:{}", new Object[]{this.count, toCheck.method_10263(), toCheck.method_10264(), toCheck.method_10260()});
        this.client.field_1687.method_45446(toCheck, class_3417.field_14927, class_3419.field_15245, this.config.volume, 1.0f, true);
    }

    private int getDepth(class_2338 blockPos, int maxDepth) {
        if (maxDepth <= 0) {
            return 0;
        }
        assert (this.client.field_1687 != null);
        if (!this.client.field_1687.method_8320(blockPos).method_26215()) {
            return 0;
        }
        return 1 + this.getDepth(blockPos.method_10074(), maxDepth - 1);
    }
}

