/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features;

import lombok.Generated;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.utils.NarrationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluidDetector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FluidDetector.class);

    public void findClosestWaterSource(boolean closeCurrentlyOpenedScreen) {
        if (closeCurrentlyOpenedScreen && class_310.method_1551().field_1755 != null && class_310.method_1551().field_1724 != null) {
            class_310.method_1551().field_1724.method_3137();
        }
        log.debug("Finding closest water source");
        this.findClosestFluidSource(true);
    }

    public void findClosestLavaSource(boolean closeCurrentlyOpenedScreen) {
        if (closeCurrentlyOpenedScreen && class_310.method_1551().field_1755 != null && class_310.method_1551().field_1724 != null) {
            class_310.method_1551().field_1724.method_3137();
        }
        log.debug("Finding closest lava source");
        this.findClosestFluidSource(false);
    }

    private void findClosestFluidSource(boolean water) {
        int posZ;
        int posY;
        class_310 minecraftClient = class_310.method_1551();
        if (minecraftClient.field_1687 == null) {
            return;
        }
        if (minecraftClient.field_1724 == null) {
            return;
        }
        Config.AccessMenu.FluidDetector config = Config.getInstance().accessMenu.fluidDetector;
        class_2338 pos = minecraftClient.field_1724.method_24515();
        int posX = pos.method_10263();
        class_2338 startingPointPos = new class_2338(new class_2382(posX, posY = pos.method_10264(), posZ = pos.method_10260()));
        class_2338 closestFluidPos = FluidDetector.findFluid(minecraftClient, startingPointPos, config.range, water);
        if (closestFluidPos == null) {
            log.debug("Unable to find closest fluid source");
            MainClass.narrate(class_1074.method_4662((String)"minecraft_access.other.not_found", (Object[])new Object[0]), true);
            return;
        }
        log.debug("{FluidDetector} playing sound at %dx %dy %dz".formatted(closestFluidPos.method_10263(), closestFluidPos.method_10264(), closestFluidPos.method_10260()));
        minecraftClient.field_1687.method_8396((class_1297)minecraftClient.field_1724, closestFluidPos, class_3417.field_15197, class_3419.field_15245, config.volume, 1.0f);
        String posDifference = NarrationUtils.narrateRelativePositionOfPlayerAnd(closestFluidPos);
        String name = minecraftClient.field_1687.method_8320(closestFluidPos).method_26204().method_9518().getString();
        MainClass.narrate(name + ", " + posDifference, true);
    }

    private static class_2338 findFluid(class_310 minecraftClient, class_2338 blockPos, int range, boolean water) {
        boolean rightTarget;
        if (minecraftClient.field_1687 == null) {
            return null;
        }
        if (minecraftClient.field_1724 == null) {
            return null;
        }
        class_2680 blockState = minecraftClient.field_1687.method_8320(blockPos);
        if (blockState.method_27852(class_2246.field_10243)) {
            return null;
        }
        class_3610 fluidState = minecraftClient.field_1687.method_8316(blockPos);
        boolean bl = rightTarget = fluidState.method_15767(class_3486.field_15518) && !water || fluidState.method_15767(class_3486.field_15517) && water;
        if (rightTarget && fluidState.method_15771()) {
            return blockPos;
        }
        if (range - 1 >= 0 && blockState.method_26215()) {
            int posX = blockPos.method_10263();
            int posY = blockPos.method_10264();
            int posZ = blockPos.method_10260();
            int rangeVal = range - 1;
            class_2338 bp1 = FluidDetector.findFluid(minecraftClient, new class_2338(new class_2382(posX, posY, posZ - 1)), rangeVal, water);
            class_2338 bp2 = FluidDetector.findFluid(minecraftClient, new class_2338(new class_2382(posX, posY, posZ + 1)), rangeVal, water);
            class_2338 bp3 = FluidDetector.findFluid(minecraftClient, new class_2338(new class_2382(posX - 1, posY, posZ)), rangeVal, water);
            class_2338 bp4 = FluidDetector.findFluid(minecraftClient, new class_2338(new class_2382(posX + 1, posY, posZ)), rangeVal, water);
            class_2338 bp5 = FluidDetector.findFluid(minecraftClient, new class_2338(new class_2382(posX, posY - 1, posZ)), rangeVal, water);
            class_2338 bp6 = FluidDetector.findFluid(minecraftClient, new class_2338(new class_2382(posX, posY + 1, posZ)), rangeVal, water);
            if (bp1 != null) {
                return bp1;
            }
            if (bp2 != null) {
                return bp2;
            }
            if (bp3 != null) {
                return bp3;
            }
            if (bp4 != null) {
                return bp4;
            }
            if (bp5 != null) {
                return bp5;
            }
            return bp6;
        }
        return null;
    }
}

