/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.inventory_controls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_1735;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mcaccess.minecraftaccess.MainClass;
import org.mcaccess.minecraftaccess.features.inventory_controls.SlotItem;

public class SlotsGroup {
    @NotNull
    private final String groupKey;
    @Nullable
    private final String groupName;
    @Nullable
    private final Byte index;
    public List<SlotItem> slotItems;
    public boolean isScrollable = false;
    private final Map<class_1735, String> slotNamePrefixMap = new HashMap<class_1735, String>();

    public SlotsGroup(@NotNull String groupKey, @Nullable String groupName, @Nullable Byte index, @Nullable List<SlotItem> slotItems) {
        this.groupKey = groupKey;
        this.groupName = groupName;
        this.index = index;
        this.slotItems = Objects.requireNonNullElseGet(slotItems, ArrayList::new);
    }

    public SlotsGroup(@NotNull String groupKey, @Nullable List<SlotItem> slotItems) {
        this(groupKey, null, null, slotItems);
    }

    public SlotsGroup(@NotNull String groupKey) {
        this(groupKey, null, null, null);
    }

    public void setSlotPrefix(class_1735 slot, String prefix) {
        this.slotNamePrefixMap.put(slot, prefix);
    }

    public String getSlotPrefix(class_1735 slot) {
        String output = this.slotNamePrefixMap.get(slot);
        return output != null ? output : "";
    }

    public SlotItem getFirstGroupItem() {
        return this.slotItems.getFirst();
    }

    public SlotItem getLastGroupItem() {
        return this.slotItems.getLast();
    }

    public boolean hasSlotItemAbove(@NotNull SlotItem slotItem) {
        return slotItem.upSlotItem != null || slotItem.y != this.getFirstGroupItem().y;
    }

    public boolean hasSlotItemBelow(@NotNull SlotItem slotItem) {
        return slotItem.downSlotItem != null || slotItem.y != this.getLastGroupItem().y;
    }

    public boolean hasSlotItemLeft(@NotNull SlotItem slotItem) {
        return slotItem.leftSlotItem != null || slotItem.x != this.getFirstGroupItem().x;
    }

    public boolean hasSlotItemRight(@NotNull SlotItem slotItem) {
        return slotItem.rightSlotItem != null || slotItem.x != this.getLastGroupItem().x;
    }

    void mapTheGroupList(int factor) {
        this.mapTheGroupList(factor, false);
    }

    void mapTheGroupList(int factor, boolean transpose) {
        int size = this.slotItems.size();
        for (int i = 0; i < size; ++i) {
            int above = i - factor;
            int right = i + 1;
            int below = i + factor;
            int left = i - 1;
            if (above >= 0) {
                if (transpose) {
                    this.slotItems.get((int)i).leftSlotItem = this.slotItems.get(above);
                } else {
                    this.slotItems.get((int)i).upSlotItem = this.slotItems.get(above);
                }
            }
            if (right < size && right % factor != 0) {
                if (transpose) {
                    this.slotItems.get((int)i).downSlotItem = this.slotItems.get(right);
                } else {
                    this.slotItems.get((int)i).rightSlotItem = this.slotItems.get(right);
                }
            }
            if (below < size) {
                if (transpose) {
                    this.slotItems.get((int)i).rightSlotItem = this.slotItems.get(below);
                } else {
                    this.slotItems.get((int)i).downSlotItem = this.slotItems.get(below);
                }
            }
            if (left < 0 || (left + 1) % factor == 0) continue;
            if (transpose) {
                this.slotItems.get((int)i).upSlotItem = this.slotItems.get(left);
                continue;
            }
            this.slotItems.get((int)i).leftSlotItem = this.slotItems.get(left);
        }
    }

    void setRowColumnPrefixForSlots() {
        int size = (int)Math.round(Math.sqrt(this.slotItems.size()));
        int i = 0;
        for (int row = 1; row <= size; ++row) {
            for (int column = 1; column <= size; ++column) {
                class_1735 slot = this.slotItems.get((int)i).slot;
                String prefix = MainClass.inventoryControls.getRowAndColumnFormat().formatted(row, column);
                this.setSlotPrefix(slot, prefix);
                ++i;
            }
        }
    }

    public String getGroupName() {
        String key = String.format("minecraft_access.slot_group.%s", this.groupKey);
        String translation = this.groupName == null || class_1074.method_4663((String)key) ? class_1074.method_4662((String)key, (Object[])new Object[0]) : this.groupName;
        return this.index == null ? translation : String.format("%s %d", translation, this.index);
    }
}

