/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.point_of_interest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.features.point_of_interest.BuiltinEntityPOIGroups;
import org.mcaccess.minecraftaccess.features.point_of_interest.POIGroup;
import org.mcaccess.minecraftaccess.utils.condition.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POIEntities {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(POIEntities.class);
    private final class_310 client = class_310.method_1551();
    private Config.POI.Entities config;
    private final Interval interval = Interval.defaultDelay();
    @Nullable
    private Class<? extends class_1297> marked = null;
    private final POIGroup<class_1297> markedGroup = new POIGroup<class_1297>("minecraft_access.point_of_interest.group.markedEntity", new POIGroup.Sound(class_3417.field_15197, -5.0f), e -> this.marked != null && this.marked.isInstance(e));
    private final POIGroup<class_1297> otherEntitiesGroup = new POIGroup<class_1297>("minecraft_access.point_of_interest.group.otherEntities", entity -> true);
    final POIGroup<class_1297>[] groups = (POIGroup[])Stream.of(List.of(this.markedGroup), BuiltinEntityPOIGroups.ALL, List.of(this.otherEntitiesGroup)).flatMap(Collection::stream).toArray(POIGroup[]::new);
    private List<class_1297> lastScanResults = new ArrayList<class_1297>();

    POIEntities() {
        this.loadConfig();
    }

    public void tick(boolean isMarking, class_1297 markedEntity) {
        this.setMarked(markedEntity);
        this.loadConfig();
        if (!this.config.enabled) {
            return;
        }
        if (!this.interval.isReady()) {
            return;
        }
        if (this.client.field_1724 == null) {
            return;
        }
        if (this.client.field_1687 == null) {
            return;
        }
        if (this.client.field_1755 != null) {
            return;
        }
        log.trace("POIEntities started");
        this.scanEntitiesAroundPlayer();
        this.playerSoundAtFoundPOI(isMarking);
        log.trace("POIEntities ended");
    }

    private void scanEntitiesAroundPlayer() {
        ArrayList<class_1297> currentScanResults = new ArrayList<class_1297>();
        for (POIGroup<class_1297> group : this.groups) {
            group.clear();
        }
        class_746 player = this.client.field_1724;
        assert (player != null);
        class_238 scanBox = player.method_5829().method_1009((double)this.config.range, (double)this.config.range, (double)this.config.range);
        assert (this.client.field_1687 != null);
        List entities = this.client.field_1687.method_8335((class_1297)player, scanBox);
        block1: for (class_1297 entity : entities) {
            for (POIGroup<class_1297> group : this.groups) {
                if (!group.addIfQualified(entity)) continue;
                currentScanResults.add(entity);
                continue block1;
            }
        }
        this.lastScanResults = currentScanResults;
    }

    private void playerSoundAtFoundPOI(boolean isMarking) {
        if (this.config.volume == 0.0f) {
            return;
        }
        Function<class_1297, class_243> mapper = e -> e.method_24515().method_46558();
        if (isMarking && Config.getInstance().poi.marking.suppressOtherWhenEnabled) {
            this.markedGroup.playSoundForGroupItems(mapper, this.config.volume);
        } else if (this.config.playSound) {
            for (POIGroup<class_1297> group : this.groups) {
                group.playSoundForGroupItems(mapper, this.config.volume);
            }
        }
    }

    private void loadConfig() {
        this.config = Config.getInstance().poi.entities;
        this.interval.setDelay(this.config.delay, Interval.Unit.MILLISECOND);
    }

    private void setMarked(@Nullable class_1297 entity) {
        this.marked = Optional.ofNullable(entity).map(Object::getClass).orElse(null);
    }

    @Generated
    public List<class_1297> getLastScanResults() {
        return this.lastScanResults;
    }
}

