/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.features.point_of_interest;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_746;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.UnmodifiableView;
import org.mcaccess.minecraftaccess.MainClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POIGroup<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(POIGroup.class);
    private final String nameTranslateKey;
    private final Sound sound;
    private final Predicate<T> predicate;
    private final List<T> items = new ArrayList<T>();

    public POIGroup(String nameTranslateKey, Sound sound, Predicate<T> predicate) {
        this.nameTranslateKey = nameTranslateKey;
        this.sound = sound;
        this.predicate = predicate;
    }

    public POIGroup(String nameTranslateKey, Predicate<T> predicate) {
        this(nameTranslateKey, new Sound(null, 0.0f), predicate);
    }

    public String getTranslatedName() {
        return class_1074.method_4662((String)this.nameTranslateKey, (Object[])new Object[0]);
    }

    public boolean addIfQualified(T item) {
        if (!MainClass.poiManager.objectTracker.isObjectValid(item)) {
            return false;
        }
        if (this.predicate.test(item)) {
            log.debug("[{}] Add POI item [{}]", (Object)this.getTranslatedName(), item);
            this.items.add(item);
            return true;
        }
        return false;
    }

    public void clear() {
        this.items.clear();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Contract(pure=true)
    public @UnmodifiableView List<T> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public @UnmodifiableView List<T> sortByDistance() {
        ArrayList<T> result = new ArrayList<T>(this.items);
        Map<Object, Double> cache = result.stream().collect(Collectors.toMap(k -> k, this::distanceBetweenPlayerAnd));
        result.sort(Comparator.comparing(cache::get));
        return Collections.unmodifiableList(result);
    }

    private double distanceBetweenPlayerAnd(T item) {
        class_746 player = class_310.method_1551().field_1724;
        T t = item;
        Objects.requireNonNull(t);
        T t2 = t;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1297.class, class_2338.class}, t2, n)) {
            case 0 -> {
                class_1297 entity = (class_1297)t2;
                if (!$assertionsDisabled && player == null) {
                    throw new AssertionError();
                }
                yield player.method_5739(entity);
            }
            case 1 -> {
                class_2338 blockPos = (class_2338)t2;
                if (!$assertionsDisabled && player == null) {
                    throw new AssertionError();
                }
                yield player.method_33571().method_1022(blockPos.method_46558());
            }
            default -> Double.MAX_VALUE;
        };
    }

    public void playSoundForGroupItems(Function<T, class_243> mapper, float volume) {
        for (T item : this.items) {
            class_243 pos = mapper.apply(item);
            this.sound.play(pos, volume);
        }
    }

    public record Sound(class_3414 sound, float pitch) {
        static Logger log = LoggerFactory.getLogger(Sound.class);

        public void play(class_243 pos, float volume) {
            if (this.sound == null) {
                return;
            }
            log.debug("Play POI sound [{}] at [x:{} y:{} z{}]", new Object[]{this.sound, pos.field_1352, pos.field_1351, pos.field_1350});
            assert (class_310.method_1551().field_1687 != null);
            class_310.method_1551().field_1687.method_8486(pos.field_1352, pos.field_1351, pos.field_1350, this.sound, class_3419.field_15245, volume, this.pitch, true);
        }
    }
}

