/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.mixin;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_329;
import org.mcaccess.minecraftaccess.Config;
import org.mcaccess.minecraftaccess.MainClass;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_329.class})
abstract class GuiMixin {
    @Shadow
    private class_2561 field_2016;
    @Shadow
    private class_2561 field_2039;
    @Unique
    private String previousActionBarContent = "";

    GuiMixin() {
    }

    @Inject(at={@At(value="HEAD")}, method={"setOverlayMessage(Lnet/minecraft/network/chat/Component;Z)V"})
    private void narrateActionbar(class_2561 message, boolean tinted, CallbackInfo ci) {
        Config config = Config.getInstance();
        if (config.features.actionBarEnabled) {
            boolean contentChanged;
            String msg = message.getString();
            boolean bl = contentChanged = !this.previousActionBarContent.equals(msg);
            if (contentChanged) {
                if (config.features.onlyNarrateActionBarUpdates) {
                    this.onlyNarrateChangedParts(msg);
                } else {
                    MainClass.narrate(msg, true);
                }
                this.previousActionBarContent = msg;
            }
        }
    }

    @Unique
    private void onlyNarrateChangedParts(String msg) {
        List<String> parts = Arrays.asList(this.splitToParts(msg));
        List<String> previousParts = Arrays.asList(this.splitToParts(this.previousActionBarContent));
        parts.removeAll(previousParts);
        String narration = String.join((CharSequence)", ", parts);
        MainClass.narrate(narration, true);
    }

    @Inject(method={"setTitle"}, at={@At(value="TAIL")})
    private void setTitleMixin(class_2561 title, CallbackInfo ci) {
        MainClass.narrate(title.getString(), true);
        if (this.field_2039 != null) {
            MainClass.narrate(this.field_2039.getString(), false);
        }
    }

    @Inject(method={"setSubtitle"}, at={@At(value="HEAD")})
    private void setSubtitleMixin(class_2561 subtitle, CallbackInfo ci) {
        if (this.field_2016 != null && this.field_2039 == null) {
            MainClass.narrate(subtitle.getString(), false);
        }
    }

    @Unique
    private String[] splitToParts(String msg) {
        if (msg.contains(",")) {
            return msg.split(",");
        }
        return msg.split("\\s");
    }
}

