/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.screen_reader;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.mcaccess.minecraftaccess.screen_reader.ScreenReaderInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenReaderWindows
implements ScreenReaderInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScreenReaderWindows.class);
    TolkInterface mainInstance = null;

    @Override
    public void initializeScreenReader() {
        boolean isLoaded;
        Path path = Paths.get("Tolk.dll", new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            log.error("Tolk not installed!");
            return;
        }
        log.info("Initializing Tolk for windows at: {}", (Object)path);
        TolkInterface instance = (TolkInterface)Native.load((String)path.toString(), TolkInterface.class);
        instance.Tolk_TrySAPI(true);
        instance.Tolk_Load();
        boolean bl = isLoaded = instance.Tolk_IsLoaded() && instance.Tolk_HasSpeech();
        if (isLoaded) {
            log.info("Successfully initialized screen reader");
            this.mainInstance = instance;
        } else {
            log.error("Unable to initialize screen reader");
        }
    }

    @Override
    public boolean isInitialized() {
        return this.mainInstance != null;
    }

    @Override
    public void narrate(String text, boolean interrupt) {
        if (this.mainInstance == null) {
            return;
        }
        String narration = this.formatNarration(text);
        char[] ch = new char[narration.length() + 1];
        for (int i = 0; i < narration.length(); ++i) {
            ch[i] = narration.charAt(i);
        }
        boolean re = this.mainInstance.Tolk_Output(ch, interrupt);
        if (re) {
            log.info("Narrating(interrupt:{})= {}", (Object)interrupt, (Object)narration);
        } else {
            log.error("Unable to narrate");
        }
    }

    @Override
    public void closeScreenReader() {
        if (this.mainInstance == null) {
            return;
        }
        this.mainInstance.Tolk_Unload();
    }

    private static interface TolkInterface
    extends Library {
        public void Tolk_Load();

        public boolean Tolk_IsLoaded();

        public boolean Tolk_HasSpeech();

        public void Tolk_Unload();

        public void Tolk_TrySAPI(boolean var1);

        public boolean Tolk_Output(char[] var1, boolean var2);
    }
}

