/*
 * Decompiled with CFR 0.152.
 */
package org.mcaccess.minecraftaccess.utils.position;

import lombok.Generated;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import org.mcaccess.minecraftaccess.utils.NarrationUtils;
import org.mcaccess.minecraftaccess.utils.position.Orientation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlayerPositionUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlayerPositionUtils.class);
    private static final class_310 CLIENT = class_310.method_1551();
    private static final String POSITION_FORMAT = "{x}, {y}, {z}";

    private PlayerPositionUtils() {
    }

    public static String getNarratableXYZPosition() {
        return POSITION_FORMAT.replace("{x}", PlayerPositionUtils.getNarratableXPos()).replace("{y}", PlayerPositionUtils.getNarratableYPos()).replace("{z}", PlayerPositionUtils.getNarratableZPos());
    }

    public static String getNarratableXPos() {
        assert (PlayerPositionUtils.CLIENT.field_1724 != null);
        return NarrationUtils.narrateNumber(PlayerPositionUtils.CLIENT.field_1724.method_73189().field_1352) + "x";
    }

    public static String getNarratableYPos() {
        assert (PlayerPositionUtils.CLIENT.field_1724 != null);
        return NarrationUtils.narrateNumber(PlayerPositionUtils.CLIENT.field_1724.method_73189().field_1351) + "y";
    }

    public static String getNarratableZPos() {
        assert (PlayerPositionUtils.CLIENT.field_1724 != null);
        return NarrationUtils.narrateNumber(PlayerPositionUtils.CLIENT.field_1724.method_73189().field_1350) + "z";
    }

    public static int getVerticalFacingDirection() {
        assert (PlayerPositionUtils.CLIENT.field_1724 != null);
        return (int)PlayerPositionUtils.CLIENT.field_1724.method_5802().field_1343;
    }

    public static String getVerticalFacingDirectionInWords() {
        int angle = PlayerPositionUtils.getVerticalFacingDirection();
        if (PlayerPositionUtils.isBetween(angle, -90, -88)) {
            return class_1074.method_4662((String)"minecraft_access.direction.up", (Object[])new Object[0]);
        }
        if (PlayerPositionUtils.isBetween(angle, -87, -3)) {
            return class_1074.method_4662((String)"minecraft_access.direction.degrees", (Object[])new Object[]{NarrationUtils.narrateNumber(-angle)}) + " " + class_1074.method_4662((String)"minecraft_access.direction.up", (Object[])new Object[0]);
        }
        if (PlayerPositionUtils.isBetween(angle, -2, 2)) {
            return class_1074.method_4662((String)"minecraft_access.direction.straight", (Object[])new Object[0]);
        }
        if (PlayerPositionUtils.isBetween(angle, 3, 87)) {
            return class_1074.method_4662((String)"minecraft_access.direction.degrees", (Object[])new Object[]{NarrationUtils.narrateNumber(angle)}) + " " + class_1074.method_4662((String)"minecraft_access.direction.down", (Object[])new Object[0]);
        }
        if (PlayerPositionUtils.isBetween(angle, 88, 90)) {
            return class_1074.method_4662((String)"minecraft_access.direction.down", (Object[])new Object[0]);
        }
        return null;
    }

    public static boolean isBetween(int x, int lower, int upper) {
        return lower <= x && x <= upper;
    }

    public static int getHorizontalFacingDirectionInDegrees() {
        assert (PlayerPositionUtils.CLIENT.field_1724 != null);
        int angle = (int)PlayerPositionUtils.CLIENT.field_1724.method_5802().field_1342;
        return angle % 360;
    }

    public static Orientation getHorizontalFacing() {
        int angle = PlayerPositionUtils.getHorizontalFacingDirectionInDegrees();
        return Orientation.ofHorizontal(angle);
    }

    public static String getHorizontalFacingDirectionInWords() {
        return class_1074.method_4662((String)("minecraft_access.direction." + String.valueOf((Object)PlayerPositionUtils.getHorizontalFacing())), (Object[])new Object[0]);
    }
}

